/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiDecoderFactory;
import com.sun.jimi.core.JimiEncoderFactory;
import com.sun.jimi.core.JimiExtension;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Hashtable;
import java.util.Vector;

public class JimiControl {
    protected static Hashtable mimeToDecoderMap = new Hashtable();
    protected static Hashtable mimeToEncoderMap = new Hashtable();
    protected static Hashtable fileExtensionToDecoderMap = new Hashtable();
    protected static Hashtable fileExtensionToEncoderMap = new Hashtable();
    protected static Vector decoderFactories = new Vector();
    protected static Vector encoderFactories = new Vector();
    protected static Vector extensions = new Vector();
    protected static boolean extensionsAllowed = true;

    public static synchronized void addExtension(JimiExtension jimiExtension) {
        if (!extensionsAllowed) {
            throw new RuntimeException("This JIMI license does not permit extensions.");
        }
        extensions.addElement(jimiExtension);
        JimiDecoderFactory[] jimiDecoderFactoryArray = jimiExtension.getDecoders();
        for (int i = 0; i < jimiDecoderFactoryArray.length; ++i) {
            JimiControl.addDecoder(jimiDecoderFactoryArray[i]);
        }
        JimiEncoderFactory[] jimiEncoderFactoryArray = jimiExtension.getEncoders();
        for (int i = 0; i < jimiEncoderFactoryArray.length; ++i) {
            JimiControl.addEncoder(jimiEncoderFactoryArray[i]);
        }
    }

    protected static JimiDecoderFactory getDecoderByType(String string) {
        return (JimiDecoderFactory)mimeToDecoderMap.get(string);
    }

    protected static JimiDecoderFactory getDecoderByFileExtension(String string) {
        String string2 = string;
        if (string2.lastIndexOf(".") != -1) {
            string2 = string2.substring(string2.lastIndexOf(".") + 1);
        }
        return (JimiDecoderFactory)fileExtensionToDecoderMap.get(string2.toLowerCase());
    }

    protected static synchronized JimiDecoderFactory getDecoderForInputStream(PushbackInputStream pushbackInputStream) {
        byte[] byArray = new byte[16];
        try {
            DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);
            dataInputStream.readFully(byArray);
            pushbackInputStream.unread(byArray);
            int n = decoderFactories.size();
            for (int i = 0; i < n; ++i) {
                JimiDecoderFactory jimiDecoderFactory = (JimiDecoderFactory)decoderFactories.elementAt(i);
                byte[][] byArray2 = jimiDecoderFactory.getFormatSignatures();
                if (byArray2 == null) continue;
                for (int j = 0; j < byArray2.length; ++j) {
                    int n2 = 0;
                    int n3 = Math.min(byArray2[j].length, byArray.length);
                    if (n2 >= n3 || byArray2[j][n2] != byArray[n2]) continue;
                    return jimiDecoderFactory;
                }
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static JimiEncoderFactory getEncoderByType(String string) {
        return (JimiEncoderFactory)mimeToEncoderMap.get(string);
    }

    protected static JimiEncoderFactory getEncoderByFileExtension(String string) {
        String string2 = string;
        if (string2.lastIndexOf(".") != -1) {
            string2 = string2.substring(string2.lastIndexOf(".") + 1);
        }
        return (JimiEncoderFactory)fileExtensionToEncoderMap.get(string2.toLowerCase());
    }

    protected static void addDecoder(JimiDecoderFactory jimiDecoderFactory) {
        decoderFactories.addElement(jimiDecoderFactory);
        String[] stringArray = jimiDecoderFactory.getMimeTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            mimeToDecoderMap.put(stringArray[i], jimiDecoderFactory);
            if (stringArray[i].indexOf(47) <= 0) continue;
            String string = stringArray[i].substring(0, stringArray[i].indexOf(47) + 1) + "x-" + stringArray[i].substring(stringArray[i].indexOf(47) + 1);
            mimeToDecoderMap.put(string, jimiDecoderFactory);
        }
        String[] stringArray2 = jimiDecoderFactory.getFilenameExtensions();
        for (int i = 0; i < stringArray2.length; ++i) {
            fileExtensionToDecoderMap.put(stringArray2[i], jimiDecoderFactory);
        }
    }

    protected static void addEncoder(JimiEncoderFactory jimiEncoderFactory) {
        encoderFactories.addElement(jimiEncoderFactory);
        String[] stringArray = jimiEncoderFactory.getMimeTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            mimeToEncoderMap.put(stringArray[i], jimiEncoderFactory);
            if (stringArray[i].indexOf(47) <= 0) continue;
            String string = stringArray[i].substring(0, stringArray[i].indexOf(47) + 1) + "x-" + stringArray[i].substring(stringArray[i].indexOf(47) + 1);
            mimeToEncoderMap.put(string, jimiEncoderFactory);
        }
        String[] stringArray2 = jimiEncoderFactory.getFilenameExtensions();
        for (int i = 0; i < stringArray2.length; ++i) {
            fileExtensionToEncoderMap.put(stringArray2[i], jimiEncoderFactory);
        }
    }

    protected static void disableExtensions() {
        extensionsAllowed = false;
    }
}

