/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;

public class JimiFactoryManager {
    protected static JimiImageFactory memoryFactory = new MemoryJimiImageFactory();
    protected static JimiImageFactory oneshotFactory;
    protected static JimiImageFactory vmemFactory;
    protected static boolean stampingAvailable;
    protected static boolean vmemInitialized;
    protected static final String ONESHOT_FACTORY_NAME = "com.sun.jimi.core.OneshotJimiImageFactory";
    protected static final String VMEM_FACTORY_NAME = "com.sun.jimi.core.VMemJimiImageFactory";

    public static JimiImageFactory getMemoryFactory() {
        return memoryFactory;
    }

    public static JimiImageFactory getVMemFactory() {
        if (!vmemInitialized) {
            JimiFactoryManager.initVMemFactory();
        }
        return vmemFactory;
    }

    public static JimiImageFactory getOneshotFactory() {
        return oneshotFactory;
    }

    protected static void initVMemFactory() {
        vmemInitialized = true;
        try {
            Class<?> clazz = Class.forName(VMEM_FACTORY_NAME);
            vmemFactory = (JimiImageFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            vmemFactory = memoryFactory;
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName(ONESHOT_FACTORY_NAME);
            oneshotFactory = (JimiImageFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            oneshotFactory = memoryFactory;
        }
        stampingAvailable = false;
    }
}

