/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.options.FormatOptionSet;
import java.awt.Image;
import java.awt.image.ImageProducer;

public class JimiImageEnumeration {
    protected static final int MODE_JIMIIMAGE = 0;
    protected static final int MODE_IMAGEPRODUCER = 1;
    protected int mode;
    protected ImageProducer[] producers;
    protected JimiImage[] jimiImages;
    protected int imageCount;
    protected int imageIndex = 0;
    protected FormatOptionSet options;

    public JimiImageEnumeration(Image[] imageArray) {
        ImageProducer[] imageProducerArray = new ImageProducer[imageArray.length];
        for (int i = 0; i < imageArray.length; ++i) {
            imageProducerArray[i] = imageArray[i].getSource();
        }
        this.producers = imageProducerArray;
        this.mode = 1;
        this.imageCount = imageProducerArray.length;
    }

    public JimiImageEnumeration(ImageProducer[] imageProducerArray) {
        this.producers = imageProducerArray;
        this.mode = 1;
        this.imageCount = imageProducerArray.length;
    }

    public JimiImageEnumeration(JimiImage[] jimiImageArray) {
        this.jimiImages = jimiImageArray;
        this.mode = 0;
        this.imageCount = jimiImageArray.length;
    }

    public JimiImageEnumeration(Image image) {
        this(new Image[]{image});
    }

    public JimiImageEnumeration(ImageProducer imageProducer) {
        this(new ImageProducer[]{imageProducer});
    }

    public JimiImageEnumeration(JimiImage jimiImage) {
        this(new JimiImage[]{jimiImage});
    }

    public int countImages() {
        return this.imageCount;
    }

    public JimiImage getNextImage() throws JimiException {
        JimiImage jimiImage;
        if (!this.hasMoreImages()) {
            return null;
        }
        if (this.mode == 1) {
            jimiImage = Jimi.createRasterImage(this.producers[this.imageIndex]);
            this.producers[this.imageIndex] = null;
        } else {
            jimiImage = this.jimiImages[this.imageIndex];
            this.jimiImages[this.imageIndex] = null;
        }
        jimiImage.waitFinished();
        if (this.options != null) {
            jimiImage.setOptions(this.options);
        }
        ++this.imageIndex;
        return jimiImage;
    }

    public boolean hasMoreImages() {
        return this.imageIndex < this.imageCount;
    }

    public void setOptions(FormatOptionSet formatOptionSet) {
        this.options = formatOptionSet;
    }
}

