/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.QueuedImageProducerProxy;
import java.awt.image.ImageProducer;

public class JimiImageHandle
implements JimiImage {
    protected JimiImage image;
    protected boolean error;
    protected QueuedImageProducerProxy producerProxy = new QueuedImageProducerProxy();

    public synchronized void setJimiImage(JimiImage jimiImage) {
        this.image = jimiImage;
        this.producerProxy.setImageProducer(jimiImage.getImageProducer());
        this.notifyAll();
    }

    protected synchronized void waitImageSet() {
        while (this.image == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isImageSet() {
        return this.image != null;
    }

    public JimiImage getWrappedJimiImage() throws JimiException {
        this.waitImageSet();
        if (this.image == null) {
            throw new JimiException();
        }
        return this.image;
    }

    @Override
    public void waitFinished() {
        this.waitImageSet();
        this.image.waitFinished();
    }

    public void waitInfoAvailable() {
        this.waitImageSet();
    }

    @Override
    public ImageProducer getImageProducer() {
        return this.producerProxy;
    }

    @Override
    public boolean isError() {
        this.waitImageSet();
        return this.image.isError();
    }

    @Override
    public JimiImageFactory getFactory() {
        if (this.image != null) {
            return this.image.getFactory();
        }
        return new MemoryJimiImageFactory();
    }

    @Override
    public FormatOptionSet getOptions() {
        this.waitImageSet();
        if (this.image instanceof JimiRasterImage) {
            ((JimiRasterImage)this.image).waitInfoAvailable();
        }
        return this.image.getOptions();
    }

    @Override
    public void setOptions(FormatOptionSet formatOptionSet) {
        this.waitImageSet();
        this.image.setOptions(formatOptionSet);
    }
}

