/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.ImageSeriesDecodingController;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiImageHandle;
import com.sun.jimi.core.JimiMultiImageRasterDecoderRunner;
import com.sun.jimi.core.JimiRasterDecoderSupport;
import com.sun.jimi.core.MImageSeriesDecodingController;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import java.io.IOException;
import java.io.InputStream;

public abstract class JimiMultiImageRasterDecoder
extends JimiRasterDecoderSupport {
    protected JimiDecodingController currentDecodingController;
    protected JimiImageHandle currentHandle;
    protected MImageSeriesDecodingController controller;
    protected boolean error;
    protected boolean busy = false;

    public ImageSeriesDecodingController initDecoding(JimiImageFactory jimiImageFactory, InputStream inputStream) {
        super.init(jimiImageFactory, inputStream);
        this.controller = new MImageSeriesDecodingController(this);
        return this.controller;
    }

    protected JimiDecodingController initNextDecoding() {
        this.waitReady();
        this.currentHandle = new JimiImageHandle();
        this.currentDecodingController = new JimiDecodingController(this.currentHandle);
        JimiMultiImageRasterDecoderRunner jimiMultiImageRasterDecoderRunner = new JimiMultiImageRasterDecoderRunner(this);
        new Thread(jimiMultiImageRasterDecoderRunner).start();
        return this.currentDecodingController;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void driveDecoding() {
        try {
            try {
                if (this.progressListener != null) {
                    this.progressListener.setStarted();
                }
                this.setJimiImage(this.doInitNextDecoding(this.getJimiImageFactory(), this.getInput()));
                this.doNextImageDecode();
                if (this.progressListener != null) {
                    this.progressListener.setFinished();
                }
                Object var2_1 = null;
                this.progressListener = null;
                this.setBusy(false);
                if (!this.noMoreRequests) return;
                this.cleanup();
                return;
            }
            catch (JimiException jimiException) {
                if (this.progressListener != null) {
                    this.progressListener.setAbort(jimiException.getMessage());
                }
                Object var2_2 = null;
                this.progressListener = null;
                this.setBusy(false);
                if (!this.noMoreRequests) return;
                this.cleanup();
                return;
            }
            catch (IOException iOException) {
                if (this.progressListener != null) {
                    this.progressListener.setAbort();
                }
                Object var2_3 = null;
                this.progressListener = null;
                this.setBusy(false);
                if (!this.noMoreRequests) return;
                this.cleanup();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.progressListener = null;
            this.setBusy(false);
            if (!this.noMoreRequests) throw throwable;
            this.cleanup();
            throw throwable;
        }
    }

    public abstract MutableJimiRasterImage doInitNextDecoding(JimiImageFactory var1, InputStream var2) throws JimiException, IOException;

    public abstract void doNextImageDecode() throws JimiException, IOException;

    public abstract void doSkipNextImage() throws JimiException, IOException;

    public abstract boolean hasMoreImages();

    protected synchronized void setJimiImage(MutableJimiRasterImage mutableJimiRasterImage) {
        mutableJimiRasterImage.setDecodingController(this.currentDecodingController);
        this.currentHandle.setJimiImage(mutableJimiRasterImage);
        this.currentDecodingController.waitDecodingRequest();
    }

    public JimiImageFactory getJimiImageFactory() {
        return this.factory;
    }

    public void setProgress(int n) {
        super.setProgress(n);
    }

    public InputStream getInput() {
        return this.input;
    }

    protected synchronized void setBusy(boolean bl) {
        this.busy = bl;
        this.notifyAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void waitReady() {
        while (this.busy) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

