/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageEnumeration;
import com.sun.jimi.core.JimiRasterEncoderSupport;
import com.sun.jimi.core.JimiRasterImageEnumeration;
import com.sun.jimi.core.util.ProgressListener;
import java.io.IOException;
import java.io.OutputStream;

public abstract class JimiMultiImageRasterEncoder
extends JimiRasterEncoderSupport {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void encodeImages(JimiImageEnumeration jimiImageEnumeration, OutputStream outputStream) throws JimiException {
        try {
            this.progressListener.setStarted();
            this.doEncodeImages(new JimiRasterImageEnumeration(jimiImageEnumeration), outputStream);
            this.progressListener.setFinished();
            return;
        }
        catch (JimiException jimiException) {
            this.progressListener.setAbort(jimiException.getMessage());
            throw jimiException;
        }
        catch (IOException iOException) {
            this.progressListener.setAbort();
            throw new JimiException(iOException.toString());
        }
    }

    public final void encodeImages(JimiImageEnumeration jimiImageEnumeration, OutputStream outputStream, ProgressListener progressListener) throws JimiException {
        this.setProgressListener(progressListener);
        this.encodeImages(jimiImageEnumeration, outputStream);
    }

    public abstract void doEncodeImages(JimiRasterImageEnumeration var1, OutputStream var2) throws JimiException, IOException;

    public void setProgress(int n) {
        super.setProgress(n);
    }
}

