/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiEncoder;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageEnumeration;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.ProgressListener;
import com.sun.jimi.core.util.ProgressMonitorSupport;
import java.io.IOException;
import java.io.OutputStream;

public abstract class JimiSingleImageRasterEncoder
extends ProgressMonitorSupport
implements JimiEncoder {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void encodeImage(JimiImage jimiImage, OutputStream outputStream) throws JimiException {
        try {
            jimiImage.waitFinished();
            this.doEncodeImage(JimiUtil.asJimiRasterImage(jimiImage), outputStream);
            return;
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void encodeImage(JimiImage jimiImage, OutputStream outputStream, ProgressListener progressListener) throws JimiException {
        this.progressListener = progressListener;
        try {
            jimiImage.waitFinished();
            this.progressListener.setStarted();
            this.doEncodeImage(JimiUtil.asJimiRasterImage(jimiImage), outputStream);
            this.progressListener.setFinished();
            return;
        }
        catch (JimiException jimiException) {
            this.progressListener.setAbort(jimiException.getMessage());
            throw jimiException;
        }
        catch (IOException iOException) {
            this.progressListener.setAbort();
            throw new JimiException(iOException.toString());
        }
    }

    public abstract void doEncodeImage(JimiRasterImage var1, OutputStream var2) throws JimiException, IOException;

    public final void encodeImages(JimiImageEnumeration jimiImageEnumeration, OutputStream outputStream) throws JimiException {
        this.encodeImage(jimiImageEnumeration.getNextImage(), outputStream);
    }

    public final void encodeImages(JimiImageEnumeration jimiImageEnumeration, OutputStream outputStream, ProgressListener progressListener) throws JimiException {
        this.encodeImage(jimiImageEnumeration.getNextImage(), outputStream, progressListener);
    }

    public void setProgress(int n) {
        super.setProgress(n);
    }
}

