/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.VMMControl;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.ChanneledIntRasterImage;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.VMemByteRasterImage;
import com.sun.jimi.core.raster.VMemChanneledIntRasterImage;
import com.sun.jimi.core.raster.VMemIntRasterImage;
import com.sun.jimi.util.FileRandomAccessStorage;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;

public class VMemJimiImageFactory
implements JimiImageFactory {
    protected static long id;
    protected JimiImageFactory memoryFactory = new MemoryJimiImageFactory();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntRasterImage createIntRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            if (n * n2 * 4 < VMMControl.threshold) {
                return this.memoryFactory.createIntRasterImage(n, n2, colorModel);
            }
            return new VMemIntRasterImage(VMemJimiImageFactory.createNextStorage(VMMControl.getDirectory()), n, n2, colorModel);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteRasterImage createByteRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            if (n * n2 < VMMControl.threshold) {
                return this.memoryFactory.createByteRasterImage(n, n2, colorModel);
            }
            return new VMemByteRasterImage(VMemJimiImageFactory.createNextStorage(VMMControl.getDirectory()), n, n2, colorModel);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BitRasterImage createBitRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            return this.memoryFactory.createCompressedBitRasterImage(n, n2, colorModel);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BitRasterImage createCompressedBitRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            return this.memoryFactory.createCompressedBitRasterImage(n, n2, colorModel);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChanneledIntRasterImage createChanneledIntRasterImage(int n, int n2, ColorModel colorModel) {
        try {
            if (n * n2 * 4 < VMMControl.threshold) {
                return this.memoryFactory.createChanneledIntRasterImage(n, n2, colorModel);
            }
            return new VMemChanneledIntRasterImage(VMemJimiImageFactory.createNextStorage(VMMControl.getDirectory()), n, n2, colorModel);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static synchronized RandomAccessStorage createNextStorage(File file) throws IOException {
        Object object;
        File file2 = null;
        while ((file2 = new File((String)(object = file + "/" + "jimidat." + ++id))).exists() && !file2.delete()) {
        }
        object = new FileRandomAccessStorage(file2);
        return object;
    }
}

