/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.compat;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.ChanneledIntRasterImage;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import java.util.Hashtable;

public class AdaptiveRasterImage {
    public static final int CHANNEL_ALPHA = 24;
    public static final int CHANNEL_RED = 16;
    public static final int CHANNEL_GREEN = 8;
    public static final int CHANNEL_BLUE = 0;
    public static final int NO_ALPHA = 0;
    public static final int ALPHA_DATA = 1;
    public static final int ALPHA = 0;
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int BLUE = 3;
    protected static final int MODE_INT = 0;
    protected static final int MODE_BYTE = 1;
    protected static final int MODE_BIT = 2;
    protected static final int MODE_CHANNELED = 3;
    protected int mode;
    protected ColorModel cm;
    protected int hints = -1;
    protected int width;
    protected int height;
    protected JimiImageFactory factory;
    protected IntRasterImage intImage;
    protected ChanneledIntRasterImage channelImage;
    protected ByteRasterImage byteImage;
    protected BitRasterImage bitImage;
    protected JimiRasterImage rasterImage;
    protected MutableJimiRasterImage mutableImage;
    protected JimiDecoderBase decoder;
    protected boolean rgbDefault = false;
    protected Hashtable properties = new Hashtable();
    protected Boolean alphaSignificant;
    protected boolean waitForOptions;
    protected FormatOptionSet options;

    public JimiRasterImage getBackend() {
        return this.rasterImage;
    }

    public void setDecoder(JimiDecoderBase jimiDecoderBase) {
        this.decoder = jimiDecoderBase;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public int getWidth() {
        return this.rasterImage == null ? this.width : this.rasterImage.getWidth();
    }

    public int getHeight() {
        return this.rasterImage == null ? this.height : this.rasterImage.getHeight();
    }

    public ColorModel getColorModel() {
        return this.rasterImage == null ? this.cm : this.rasterImage.getColorModel();
    }

    public void setColorModel(ColorModel colorModel) {
        this.cm = colorModel;
    }

    public void setOptions(FormatOptionSet formatOptionSet) {
        this.options = formatOptionSet;
        if (this.mutableImage != null) {
            this.mutableImage.setOptions(formatOptionSet);
        }
    }

    public FormatOptionSet getOptions() {
        return this.rasterImage.getOptions();
    }

    public void setHints(int n) {
        this.hints = n;
        if (this.mutableImage != null) {
            this.mutableImage.setImageConsumerHints(n);
        }
    }

    public void setPixels() throws JimiException {
        this.createBackEnd();
    }

    protected void createBackEnd() throws JimiException {
        int n = this.cm.getPixelSize();
        if (n == 1) {
            this.bitImage = this.factory.createBitRasterImage(this.width, this.height, this.cm);
            this.mutableImage = this.bitImage;
            this.rasterImage = this.bitImage;
            this.mode = 2;
        } else if (n <= 8) {
            this.byteImage = this.factory.createByteRasterImage(this.width, this.height, this.cm);
            this.mutableImage = this.byteImage;
            this.rasterImage = this.byteImage;
            this.mode = 1;
        } else if (this.decoder != null && this.decoder.usesChanneledData()) {
            this.channelImage = this.factory.createChanneledIntRasterImage(this.width, this.height, this.cm);
            this.intImage = this.channelImage;
            this.mutableImage = this.channelImage;
            this.rasterImage = this.channelImage;
            this.mode = 3;
        } else {
            this.intImage = this.factory.createIntRasterImage(this.width, this.height, this.cm);
            this.mutableImage = this.intImage;
            this.rasterImage = this.intImage;
            this.mode = 0;
        }
        if (this.hints != -1) {
            this.mutableImage.setImageConsumerHints(this.hints);
        }
        Enumeration enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = this.mutableImage.getProperties();
            Object k = enumeration.nextElement();
            hashtable.put(k, this.properties.get(k));
        }
        if (this.options != null) {
            this.mutableImage.setOptions(this.options);
        }
        if (this.decoder != null) {
            this.decoder.jimiImageCreated(this.mutableImage);
        }
    }

    public void setAbort() {
        this.setError();
    }

    public void setError() {
        this.mutableImage.setError();
    }

    public void setRGBDefault(boolean bl) {
        this.rgbDefault = bl;
    }

    public void addFullCoverage() {
        if (this.mutableImage != null) {
            this.mutableImage.setFinished();
        }
    }

    public synchronized void setChannel(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) throws JimiException {
        switch (this.mode) {
            case 3: {
                this.channelImage.setChannelRectangle(n, n2, n3, n4, n5, byArray, n6, n7);
                break;
            }
            case 0: {
                throw new JimiException();
            }
            case 1: {
                this.byteImage.setRectangle(n2, n3, n4, n5, byArray, n6, n7);
                break;
            }
            case 2: {
                this.bitImage.setRectangle(n2, n3, n4, n5, byArray, n6, n7);
            }
        }
    }

    public void setChannel(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws JimiException {
        switch (this.mode) {
            case 0: 
            case 3: {
                this.intImage.setRectangle(n, n2, n3, n4, nArray, n5, n6);
                break;
            }
            default: {
                throw new JimiException();
            }
        }
    }

    public void setPackedChannel(int n, byte[] byArray, int n2, int n3) throws JimiException {
        switch (this.mode) {
            case 2: {
                this.bitImage.setRectanglePacked(0, n, this.width, 1, byArray, n2, n3);
                break;
            }
            default: {
                throw new JimiException();
            }
        }
    }

    public void setPackedChannel(int n, byte[] byArray) throws JimiException {
        this.setPackedChannel(n, byArray, 0, this.width);
    }

    public void setChannel(int n, int n2, byte[] byArray, int n3, int n4) throws JimiException {
        this.setChannel(n, 0, n2, this.width, 1, byArray, n3, n4);
    }

    public void setChannel(int n, int n2, byte[] byArray) throws JimiException {
        this.setChannel(n, n2, byArray, 0, this.width);
    }

    public void setChannel(int n, int[] nArray) throws JimiException {
        this.setChannel(0, n, this.width, 1, nArray, 0, this.width);
    }

    public void setChannel(long l) throws JimiException {
    }

    public void getChannel(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) throws JimiException {
        switch (this.mode) {
            case 0: {
                this.intImage.getChannelRectangle(n, n2, n3, n4, n5, byArray, n6, n7);
                break;
            }
            case 3: {
                this.channelImage.getChannelRectangle(n, n2, n3, n4, n5, byArray, n6, n7);
                break;
            }
            case 1: {
                this.byteImage.getRectangle(n2, n3, n4, n5, byArray, n6, n7);
                break;
            }
            case 2: {
                this.bitImage.getRectangle(n2, n3, n4, n5, byArray, n6, n7);
                break;
            }
            default: {
                throw new JimiException("");
            }
        }
    }

    public void getChannel(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws JimiException {
        if (this.rgbDefault) {
            this.rasterImage.getRectangleRGB(n, n2, n3, n4, nArray, n5, n6);
        } else {
            switch (this.mode) {
                case 0: 
                case 3: {
                    this.intImage.getRectangle(n, n2, n3, n4, nArray, n5, n6);
                    break;
                }
                default: {
                    byte[] byArray = new byte[this.getWidth()];
                    int n7 = 0;
                    while (n7 < n4) {
                        if (this.mode == 1) {
                            this.byteImage.getRow(n2, byArray, n5);
                        } else if (this.mode == 2) {
                            this.bitImage.getRow(n2, byArray, n5);
                        } else {
                            throw new JimiException("int[] getChannel on non-int image");
                        }
                        int n8 = 0;
                        while (n8 < n3) {
                            nArray[n5 + n7 * n6 + n8] = byArray[n8] & 0xFF;
                            ++n8;
                        }
                        ++n7;
                    }
                    break block0;
                }
            }
        }
    }

    public void getChannel(int n, int n2, byte[] byArray, int n3) throws JimiException {
        this.getChannel(n, 0, n2, this.getWidth(), 1, byArray, n3, 0);
    }

    public void getChannelRGB(int n, byte[] byArray, int n2) throws JimiException {
        this.rasterImage.getRectangleRGBChannels(0, n, this.getWidth(), 1, byArray, n2, this.getWidth());
    }

    public void getChannelRGBA(int n, byte[] byArray, int n2) throws JimiException {
        this.rasterImage.getRectangleRGBAChannels(0, n, this.getWidth(), 1, byArray, n2, this.getWidth());
    }

    public void getChannel(int n, int[] nArray, int n2) throws JimiException {
        this.getChannel(0, n, this.width, 1, nArray, n2, 0);
    }

    public long getChannel(int n, int n2) throws JimiException {
        return this.rasterImage.getPixelRGB(n, n2);
    }

    public void setChannel(int n, int n2, long l) throws JimiException {
        switch (this.mode) {
            case 0: {
                this.intImage.setPixel(n, n2, (int)l);
                break;
            }
            case 1: {
                this.byteImage.setPixel(n, n2, (byte)l);
                break;
            }
        }
    }

    public void setProperty(String string, Object object) {
        if (this.mutableImage != null) {
            this.mutableImage.getProperties().put(string, object);
        } else {
            this.properties.put(string, object);
        }
    }

    public int getAlphaStatus() {
        if (this.alphaSignificant != null) {
            return this.alphaSignificant != false ? 1 : 0;
        }
        if (this.cm instanceof DirectColorModel && ((DirectColorModel)this.cm).getAlphaMask() != 0) {
            this.alphaSignificant = new Boolean(true);
            return this.getAlphaStatus();
        }
        if (this.cm instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)this.cm;
            byte[] byArray = new byte[indexColorModel.getMapSize()];
            indexColorModel.getAlphas(byArray);
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] != 255) {
                    this.alphaSignificant = new Boolean(true);
                    return this.getAlphaStatus();
                }
                ++n;
            }
        }
        this.alphaSignificant = new Boolean(false);
        return this.getAlphaStatus();
    }

    public void setWaitForOptions(boolean bl) {
        if (this.mutableImage != null) {
            this.mutableImage.setWaitForOptions(bl);
        }
        this.waitForOptions = bl;
    }

    public AdaptiveRasterImage(JimiImageFactory jimiImageFactory) {
        this.factory = jimiImageFactory;
    }

    public AdaptiveRasterImage(JimiImageFactory jimiImageFactory, JimiDecoderBase jimiDecoderBase) {
        this(jimiImageFactory);
        this.setDecoder(jimiDecoderBase);
        this.setWaitForOptions(jimiDecoderBase.mustWaitForOptions());
    }

    public AdaptiveRasterImage(JimiRasterImage jimiRasterImage) {
        this.rasterImage = jimiRasterImage;
        this.width = jimiRasterImage.getWidth();
        this.height = jimiRasterImage.getHeight();
        if (jimiRasterImage instanceof ChanneledIntRasterImage) {
            this.mode = 3;
            this.channelImage = (ChanneledIntRasterImage)jimiRasterImage;
            this.intImage = this.channelImage;
        } else if (jimiRasterImage instanceof IntRasterImage) {
            this.intImage = (IntRasterImage)jimiRasterImage;
            this.mode = 0;
        } else if (jimiRasterImage instanceof ByteRasterImage) {
            this.byteImage = (ByteRasterImage)jimiRasterImage;
            this.mode = 1;
        } else if (jimiRasterImage instanceof BitRasterImage) {
            this.bitImage = (BitRasterImage)jimiRasterImage;
            this.mode = 2;
        }
    }
}

