/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.component.AbstractRenderer;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.component.JimiScrollPane;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class AreaRenderer
extends AbstractRenderer
implements AdjustmentListener {
    private int cropX = 0;
    private int cropY = 0;
    private int cropWidth = 0;
    private int cropHeight = 0;
    private int parts = 4;
    private Image[] images;
    private JimiScrollPane jsp;
    private Image bufferImage;
    private Graphics buffer;

    public Component getContentPane() {
        return this.jsp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render() {
        this.cropWidth = this.image.getWidth(null) / this.parts;
        int n = this.image.getWidth(null) % this.parts;
        this.cropHeight = this.image.getHeight(null);
        this.cropX = this.jsp.getHorizontalPosition();
        this.cropY = this.jsp.getVerticalPosition();
        try {
            this.raster = Jimi.createRasterImage(this.image.getSource());
        }
        catch (JimiException jimiException) {
        }
        this.bufferImage = this.canvas.createImage(this.image.getWidth(null), this.image.getHeight(null));
        this.buffer = this.bufferImage.getGraphics();
        if (this.cropWidth % 2 != 0) {
            ++this.cropWidth;
        }
        int n2 = 0;
        while (n2 < this.parts) {
            this.producer = this.raster.getCroppedImageProducer(n2 * this.cropWidth, 0 - n2, this.cropWidth, this.cropHeight);
            this.images[n2] = Toolkit.getDefaultToolkit().createImage(this.producer);
            this.buffer.drawImage(this.images[n2], n2 * this.cropWidth, 0, null);
            ++n2;
        }
        GraphicsUtils.waitForImage(this.image);
    }

    public void paint(Graphics graphics) {
        if (this.bufferImage != null) {
            graphics.drawImage(this.bufferImage, 0, 0, this);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.cropX > this.cropWidth || this.cropY > this.cropHeight) {
            this.render();
        }
    }

    public AreaRenderer(JimiCanvas jimiCanvas) {
        this.canvas = jimiCanvas;
        this.jsp = new JimiScrollPane();
        this.jsp.add(this);
        this.images = new Image[this.parts];
    }
}

