/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.component.FitToWidthPanel;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.component.JimiImageRenderer;
import com.sun.jimi.core.raster.JimiRasterImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.ImageProducer;

public class FitWidthRenderer
extends Panel
implements JimiImageRenderer,
AdjustmentListener {
    protected JimiRasterImage rasterImage;
    protected Scrollbar scroller;
    protected FitToWidthPanel panel;
    protected JimiCanvas canvas;

    public void calibrateScrolling() {
        if (this.rasterImage == null || this.rasterImage.getWidth() == 0 || this.rasterImage.getHeight() == 0) {
            return;
        }
        int n = this.panel.getSize().width;
        int n2 = this.panel.getSize().height;
        if (n == 0 || n2 == 0) {
            return;
        }
        int n3 = this.rasterImage.getWidth();
        int n4 = this.rasterImage.getHeight();
        int n5 = n4 * n / n3;
        if (n5 > n2) {
            this.scroller.setValues(0, n2, 0, n5);
            this.scroller.setBlockIncrement(n2);
            this.scroller.setPageIncrement(n2);
            this.scroller.setVisible(true);
        } else {
            this.scroller.setVisible(false);
        }
        this.validate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setImage(Image image) {
        if (image == null) {
            return;
        }
        try {
            this.setRasterImage(Jimi.createRasterImage(image.getSource()));
            return;
        }
        catch (JimiException jimiException) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setImageProducer(ImageProducer imageProducer) {
        if (imageProducer == null) {
            return;
        }
        try {
            this.setRasterImage(Jimi.createRasterImage(imageProducer));
            return;
        }
        catch (JimiException jimiException) {
        }
    }

    public void setRasterImage(JimiRasterImage jimiRasterImage) {
        if (jimiRasterImage == null) {
            return;
        }
        jimiRasterImage.waitFinished();
        this.rasterImage = jimiRasterImage;
        this.panel.setImageProducer(jimiRasterImage.getImageProducer());
        this.calibrateScrolling();
    }

    public Component getContentPane() {
        return this;
    }

    public void render() {
        this.panel.redraw();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.panel.setPosition(this.scroller.getValue());
    }

    public FitWidthRenderer(JimiCanvas jimiCanvas) {
        this.canvas = jimiCanvas;
        this.panel = new FitToWidthPanel(jimiCanvas);
        this.scroller = new Scrollbar(1, 0, 10, 0, 100);
        this.scroller.setUnitIncrement(10);
        this.scroller.addAdjustmentListener(this);
        this.scroller.setVisible(false);
        this.scroller.addAdjustmentListener(this);
        FitWidthRenderer fitWidthRenderer = this;
        if (fitWidthRenderer == null) {
            throw null;
        }
        this.addComponentListener(fitWidthRenderer.new ResizeListener());
        this.setLayout(new BorderLayout());
        this.add((Component)this.panel, "Center");
        this.add((Component)this.scroller, "East");
        this.setBackground(jimiCanvas.getBackground());
        this.panel.setBackground(jimiCanvas.getBackground());
    }

    class ResizeListener
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            FitWidthRenderer.this.calibrateScrolling();
        }

        ResizeListener() {
        }
    }

    class ResizeWatcher
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            FitWidthRenderer.this.calibrateScrolling();
            FitWidthRenderer.this.panel.redraw();
        }

        ResizeWatcher() {
        }
    }
}

