/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.component.ScrollPaneLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Scrollbar;

public class JimiScrollPane
extends Container {
    public static final int SCROLL_HORIZONTAL = 0;
    public static final int SCROLL_VERTICAL = 1;
    public static final int SCROLL_AS_NEEDED = 2;
    public static final int SCROLL_ALWAYS = 3;
    private static final int DEFAULT_POLICY = 2;
    private int policy = 2;
    private Scrollbar horizontal;
    private Scrollbar vertical;
    private Component comp;
    private Button box;
    private int compHeight;
    private int compWidth;
    private int paintX;
    private int paintY;

    public Component add(Component component) {
        this.comp = component;
        return super.add(component, 0);
    }

    public Dimension preferredSize() {
        return super.preferredSize();
    }

    public int getVerticalPosition() {
        return this.paintY;
    }

    public int getHorizontalPosition() {
        return this.paintX;
    }

    public int getVBarOffset() {
        int n = Math.max(this.vertical.size().width, this.vertical.preferredSize().width);
        return n;
    }

    public int getHBarOffset() {
        int n = Math.max(this.horizontal.size().height, this.horizontal.preferredSize().height);
        return n;
    }

    public Scrollbar getVerticalBar() {
        return this.vertical;
    }

    public Scrollbar getHorizontalBar() {
        return this.horizontal;
    }

    public void setScrollPolicy(int n) {
        this.policy = n;
    }

    public int getScrollPolicy() {
        return this.policy;
    }

    public void layout() {
        switch (this.policy) {
            case 0: {
                this.add("south", this.horizontal);
                this.add("center", this.comp);
                break;
            }
            case 1: {
                this.add("east", this.vertical);
                this.add("center", this.comp);
                break;
            }
            case 2: {
                boolean bl = false;
                boolean bl2 = false;
                int n = this.comp.preferredSize().width;
                int n2 = this.comp.preferredSize().height;
                if (n2 > this.size().height - this.vertical.preferredSize().height) {
                    this.add("east", this.vertical);
                    bl2 = true;
                }
                if (n > this.size().width - this.horizontal.preferredSize().width) {
                    this.add("south", this.horizontal);
                    bl = true;
                }
                if (bl && bl2) {
                    this.add("corner", this.box);
                }
                this.add("center", this.comp);
                break;
            }
            case 3: {
                this.add("east", this.vertical);
                this.add("south", this.horizontal);
                this.add("corner", this.box);
                this.add("center", this.comp);
                break;
            }
        }
        if (this.vertical != null) {
            this.compHeight = this.comp.preferredSize().height - this.getViewPort().height;
            this.vertical.setValues(0, 20, 0, this.compHeight + 20);
        }
        if (this.horizontal != null) {
            this.compWidth = this.comp.preferredSize().width - this.getViewPort().width;
            this.horizontal.setValues(0, 20, 0, this.compWidth + 20);
        }
        super.layout();
    }

    protected Dimension getViewPort() {
        int n = 0;
        int n2 = 0;
        if (this.policy == 1) {
            if (this.vertical != null) {
                n = this.size().width;
                n2 = this.size().height;
            }
        } else if (this.policy == 0) {
            n = this.size().width;
            n2 = this.size().height;
        } else if (this.policy == 3) {
            n = this.size().width - this.vertical.preferredSize().width;
            n2 = this.size().height - this.horizontal.preferredSize().height;
        } else if (this.policy == 2) {
            if (this.vertical != null) {
                n = this.size().width - this.vertical.preferredSize().width;
                n2 = this.horizontal != null ? this.size().height - this.horizontal.preferredSize().height : this.size().height;
            }
            if (this.horizontal != null) {
                n2 = this.size().height - this.horizontal.preferredSize().height;
                n = this.vertical != null ? this.size().width - this.vertical.preferredSize().width : this.size().width;
            }
        }
        return new Dimension(n, n2);
    }

    public boolean handleEvent(Event event) {
        Object object = event.target;
        if (object instanceof Button) {
            this.comp.move(-this.compWidth / 2, -this.compHeight / 2);
            this.vertical.setValue(this.compHeight / 2);
            this.horizontal.setValue(this.compWidth / 2);
        } else if (object instanceof Scrollbar) {
            int n = (Integer)event.arg;
            if (this.policy == 1) {
                this.paintY = -n;
                this.paintX = 0;
                this.comp.move(this.paintX, this.paintY);
            } else if (this.policy == 0) {
                this.paintY = 0;
                this.paintX = -n;
                this.comp.move(this.paintX, this.paintY);
            } else if (this.policy == 3 || this.policy == 2) {
                if (object == this.horizontal) {
                    this.paintX = -n;
                    this.paintY = -this.vertical.getValue();
                } else if (object == this.vertical) {
                    this.paintY = -n;
                    this.paintX = -this.horizontal.getValue();
                }
                this.comp.move(this.paintX, this.paintY);
            }
        } else {
            return false;
        }
        return super.handleEvent(event);
    }

    public JimiScrollPane() {
        this.setLayout(new ScrollPaneLayout());
        this.horizontal = new Scrollbar(0);
        this.horizontal.setLineIncrement(10);
        this.vertical = new Scrollbar(1);
        this.vertical.setLineIncrement(10);
        this.box = new Button();
    }

    public JimiScrollPane(int n) {
        this();
        this.policy = n;
    }

    public JimiScrollPane(Component component, int n) {
        this(n);
        this.comp = component;
        super.add(component, 0);
    }

    public JimiScrollPane(Component component) {
        this(component, 2);
    }
}

