/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ScrollPaneLayout
implements LayoutManager {
    Component south;
    Component east;
    Component corner;
    Component center;

    public void removeLayoutComponent(Component component) {
        if (component == this.corner) {
            this.corner = null;
        } else if (component == this.south) {
            this.south = null;
        } else if (component == this.center) {
            this.center = null;
        } else if (component == this.east) {
            this.east = null;
        } else {
            component = null;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(50, 50);
    }

    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Cloneable cloneable;
            Dimension dimension = new Dimension(0, 0);
            if (this.center != null && this.center.isVisible()) {
                cloneable = this.center.preferredSize();
                dimension.width += cloneable.width;
                dimension.height = Math.max(cloneable.height, dimension.height);
            } else if (this.east != null && this.east.isVisible()) {
                cloneable = this.east.preferredSize();
                dimension.width += cloneable.width;
                dimension.height = Math.max(cloneable.height, dimension.height);
            } else if (this.south != null && this.south.isVisible()) {
                cloneable = this.south.preferredSize();
                dimension.width = Math.max(cloneable.width, dimension.width);
                dimension.height += cloneable.height;
            } else if (this.corner != null && this.corner.isVisible()) {
                cloneable = this.corner.preferredSize();
                dimension.width = Math.max(cloneable.width, dimension.width);
                dimension.height += cloneable.height;
            } else {
                dimension.width = 100;
                dimension.height = 100;
            }
            cloneable = container.insets();
            dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
            dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            Dimension dimension2 = dimension;
            Object var3_6 = null;
            return dimension2;
        }
    }

    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension;
            Insets insets = container.insets();
            int n = 0 - insets.top;
            int n2 = container.size().height - insets.bottom;
            int n3 = 0 - insets.left;
            int n4 = container.size().width - insets.right;
            if (this.east != null && this.east.isVisible()) {
                dimension = this.east.preferredSize();
                if (this.south != null) {
                    this.east.reshape(n4 - dimension.width, n, dimension.width, n2 - this.south.preferredSize().height);
                } else if (this.south == null) {
                    this.east.reshape(n4 - dimension.width, n, dimension.width, n2);
                }
            }
            if (this.south != null && this.south.isVisible()) {
                dimension = this.south.preferredSize();
                if (this.east != null) {
                    this.south.reshape(n3, n2 - dimension.height, n4 - this.east.preferredSize().width, dimension.height);
                } else if (this.east == null) {
                    this.south.reshape(n3, n2 - dimension.height, n4, dimension.height);
                }
            }
            if (this.east != null && this.south != null && this.corner != null && this.corner.isVisible() && this.south.isVisible() && this.east.isVisible()) {
                dimension = this.corner.preferredSize();
                int n5 = n4 - this.east.size().width;
                int n6 = n2 - this.south.size().height;
                int n7 = n4 - this.south.size().width;
                int n8 = n2 - this.east.size().height;
                this.corner.reshape(n5, n6, n7, n8);
                this.corner.setBackground(Color.lightGray);
                this.corner.setForeground(Color.gray);
            }
            if (this.center != null && this.center.isVisible()) {
                dimension = this.center.preferredSize();
                if (this.east != null && this.east.isVisible() && this.south == null) {
                    this.center.reshape(n3, n, n4 - this.east.size().width, dimension.height);
                } else if (this.south != null && this.south.isVisible() && this.east == null) {
                    this.center.reshape(n3, n, dimension.width, n2 - this.south.size().height);
                } else {
                    this.center.reshape(n3, n, dimension.width, dimension.height);
                }
            }
        }
    }

    public void addLayoutComponent(String string, Component component) {
        if (string.equals("corner")) {
            this.corner = component;
        }
        if (string.equals("south")) {
            this.south = component;
        }
        if (string.equals("east")) {
            this.east = component;
        }
        if (string.equals("center")) {
            this.center = component;
        }
    }
}

