/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class SmartCroppingPanel
extends Canvas {
    public static final int HORIZONTAL_PADDING = 150;
    public static final int VERTICAL_PADDING = 150;
    protected JimiRasterImage raster;
    protected Image cached;
    protected Rectangle cachedArea;
    protected Point position = new Point(0, 0);
    protected Rectangle viewingArea = new Rectangle();
    protected JimiCanvas canvas;
    protected boolean needsRedraw = true;
    private Point offset = new Point();

    public void setPosition(int n, int n2) {
        this.position.x = n;
        this.position.y = n2;
        this.repaint();
    }

    public void setImage(JimiRasterImage jimiRasterImage) {
        this.raster = jimiRasterImage;
        this.updateCache();
        this.setPosition(0, 0);
        this.redraw();
    }

    protected void updateCache() {
        if (this.cached != null) {
            this.cached.flush();
        }
        Dimension dimension = this.getSize();
        int n = Math.max(0, this.position.x - 150);
        int n2 = Math.min(this.raster.getWidth(), this.position.x + dimension.width + 150);
        int n3 = Math.max(0, this.position.y - 150);
        int n4 = Math.min(this.raster.getHeight(), this.position.y + dimension.height + 150);
        this.cachedArea = new Rectangle(n, n3, n2 - n, n4 - n3);
        this.cached = this.createImage(this.raster.getCroppedImageProducer(this.cachedArea.x, this.cachedArea.y, this.cachedArea.width, this.cachedArea.height));
        GraphicsUtils.waitForImage(this.cached);
    }

    protected boolean isCacheValid() {
        Dimension dimension = this.getSize();
        return this.position.x >= this.cachedArea.x && this.position.y >= this.cachedArea.y && this.position.x + dimension.width < this.cachedArea.x + this.cachedArea.width && this.position.y + dimension.height < this.cachedArea.y + this.cachedArea.height;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void redraw() {
        this.needsRedraw = true;
        this.repaint();
    }

    public synchronized void paint(Graphics graphics) {
        if (this.raster == null || this.needsRedraw) {
            graphics.fillRect(0, 0, this.size().width, this.size().height);
            this.needsRedraw = false;
        }
        if (this.raster != null) {
            if (this.cached == null || !this.isCacheValid()) {
                this.updateCache();
            }
            int n = this.size().width;
            int n2 = this.size().height;
            int n3 = 0;
            int n4 = 0;
            int n5 = this.raster.getWidth();
            int n6 = this.raster.getHeight();
            switch (this.canvas.getJustificationPolicy()) {
                case 0: {
                    n4 = (n - n5) / 2;
                    n3 = (n2 - n6) / 2;
                    break;
                }
                case 18: {
                    n4 = 0;
                    n3 = 0;
                    break;
                }
                case 10: {
                    n4 = n - n5;
                    n3 = 0;
                    break;
                }
                case 2: {
                    n4 = (n - n5) / 2;
                    n3 = 0;
                    break;
                }
                case 4: {
                    n4 = (n - n5) / 2;
                    n3 = n2 - n6;
                    break;
                }
                case 20: {
                    n4 = 0;
                    n3 = n2 - n6;
                    break;
                }
                case 12: {
                    n4 = n - n5;
                    n3 = n2 - n6;
                    break;
                }
                case 8: {
                    n4 = n - n5;
                    n3 = (n2 - n6) / 2;
                    break;
                }
                case 16: {
                    n4 = 0;
                    n3 = (n2 - n6) / 2;
                    break;
                }
            }
            if (n > n5 && n2 > n6) {
                graphics.fillRect(0, 0, n, n2);
            } else {
                int n7;
                if (n2 > n6) {
                    n7 = this.canvas.getJustificationPolicy();
                    if ((n7 & 2) != 0) {
                        graphics.fillRect(0, n6, n, n2 - n6);
                    } else if ((n7 & 4) != 0) {
                        graphics.fillRect(0, 0, n, n2 - n6);
                    } else {
                        graphics.fillRect(0, 0, n, (n2 - n6) / 2);
                        graphics.fillRect(0, n6 + (n2 - n6) / 2, n, (n2 - n6) / 2);
                    }
                }
                if (n > n5) {
                    n7 = this.canvas.getJustificationPolicy();
                    if ((n7 & 8) != 0) {
                        graphics.fillRect(0, 0, n - n5, n2);
                    } else if ((n7 & 0x10) != 0) {
                        graphics.fillRect(n5, 0, n - n5, n2);
                    } else {
                        graphics.fillRect(0, 0, (n - n5) / 2, n2);
                        graphics.fillRect(n5 + (n - n5) / 2, 0, (n - n5) / 2, n2);
                    }
                }
            }
            if (n < n5) {
                n4 = this.cachedArea.x - this.position.x;
            }
            if (n2 < n6) {
                n3 = this.cachedArea.y - this.position.y;
            }
            graphics.drawImage(this.cached, n4, n3, null);
        }
    }

    protected Point calculatePosition() {
        int n = this.size().width;
        int n2 = this.size().height;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.raster.getWidth();
        int n6 = this.raster.getHeight();
        switch (this.canvas.getJustificationPolicy()) {
            case 0: {
                n4 = (n - n5) / 2;
                n3 = (n2 - n6) / 2;
                break;
            }
            case 18: {
                n4 = 0;
                n3 = 0;
                break;
            }
            case 10: {
                n4 = n - n5;
                n3 = 0;
                break;
            }
            case 2: {
                n4 = (n - n5) / 2;
                n3 = 0;
                break;
            }
            case 4: {
                n4 = (n - n5) / 2;
                n3 = n2 - n6;
                break;
            }
            case 20: {
                n4 = 0;
                n3 = n2 - n6;
                break;
            }
            case 12: {
                n4 = n - n5;
                n3 = n2 - n6;
                break;
            }
            case 8: {
                n4 = n - n5;
                n3 = (n2 - n6) / 2;
                break;
            }
            case 16: {
                n4 = 0;
                n3 = (n2 - n6) / 2;
                break;
            }
        }
        this.offset.x = n4;
        this.offset.y = n3;
        if (n < n5) {
            this.offset.x = this.cachedArea.x - this.position.x;
        }
        if (n2 < n6) {
            this.offset.y = this.cachedArea.y - this.position.y;
        }
        return this.offset;
    }

    public SmartCroppingPanel(JimiCanvas jimiCanvas) {
        this.canvas = jimiCanvas;
    }
}

