/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.cur;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.ico.IconDir;
import com.sun.jimi.core.decoder.ico.IconImage;
import com.sun.jimi.core.decoder.ico.RGBQuad;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CURDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage ji_;
    private InputStream in_;
    private LEDataInputStream din_;
    private int state;
    private IconDir curDir_;
    private byte[] byteScanLine;
    private ColorModel model_;

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.curDir_ = null;
        this.in_ = inputStream;
        this.din_ = new LEDataInputStream(new BufferedInputStream(this.in_));
        this.din_.mark(4096);
        this.ji_ = adaptiveRasterImage;
        this.state = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean driveDecoder() throws JimiException {
        try {
            this.curDir_ = new IconDir(this.din_);
            this.state |= 2;
            IconImage[] iconImageArray = new IconImage[this.curDir_.getCount()];
            int n = 0;
            while (n < iconImageArray.length) {
                this.din_.reset();
                this.din_.skip(this.curDir_.getEntry(n).getImageOffset());
                iconImageArray[n] = new IconImage(this.din_);
                ++n;
            }
            this.initJimiImage(iconImageArray[0]);
            this.ji_.setChannel(0L);
            n = 0;
            while (n < iconImageArray[0].getHeight()) {
                this.ji_.setChannel(0, iconImageArray[0].getHeight() - 1 - n, iconImageArray[0].getXORMap(), n * iconImageArray[0].getWidth(), iconImageArray[0].getWidth());
                this.setProgress(n * 100 / iconImageArray[0].getHeight());
                ++n;
            }
            this.ji_.addFullCoverage();
            this.state |= 4;
            return false;
        }
        catch (IOException iOException) {
            this.state |= 1;
            throw new JimiException("IO error reading CUR file");
        }
        catch (JimiException jimiException) {
            this.state |= 1;
            throw jimiException;
        }
    }

    public void freeDecoder() throws JimiException {
        this.in_ = null;
        this.din_ = null;
        this.ji_ = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji_;
    }

    private void initJimiImage(IconImage iconImage) throws JimiException {
        this.ji_.setSize(iconImage.getWidth(), iconImage.getHeight());
        RGBQuad[] rGBQuadArray = iconImage.getColors();
        byte[] byArray = new byte[rGBQuadArray.length];
        byte[] byArray2 = new byte[rGBQuadArray.length];
        byte[] byArray3 = new byte[rGBQuadArray.length];
        int n = 0;
        while (n < rGBQuadArray.length) {
            byArray[n] = (byte)rGBQuadArray[n].getRed();
            byArray2[n] = (byte)rGBQuadArray[n].getGreen();
            byArray3[n] = (byte)rGBQuadArray[n].getBlue();
            ++n;
        }
        this.model_ = new IndexColorModel(8, byArray.length, byArray, byArray2, byArray3);
        this.ji_.setColorModel(this.model_);
        this.ji_.setPixels();
    }
}

