/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.ico;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.ico.IconDir;
import com.sun.jimi.core.decoder.ico.IconImage;
import com.sun.jimi.core.decoder.ico.RGBQuad;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ICODecoder
extends JimiDecoderBase {
    protected static final int STREAM_BUFFER_SIZE = 10240;
    private AdaptiveRasterImage ji_;
    private InputStream in_;
    private LEDataInputStream din_;
    private int state;
    private int numberOfImages_ = -1;
    private int currentImage_;
    private IconDir iconDir_;
    private byte[] byteScanLine;
    private ColorModel model_;
    private IconImage[] ii_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.state = 8;
        this.in_ = inputStream;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 2048);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[10240];
        try {
            while (bufferedInputStream.read(byArray) != -1) {
                byteArrayOutputStream.write(byArray);
            }
        }
        catch (IOException iOException) {
        }
        this.din_ = new LEDataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        this.din_.mark(byArray.length);
        this.ji_ = adaptiveRasterImage;
        try {
            this.iconDir_ = new IconDir(this.din_);
            this.numberOfImages_ = this.iconDir_.getCount();
            this.ii_ = new IconImage[this.numberOfImages_];
            this.state |= 2;
            this.currentImage_ = 0;
            if (this.numberOfImages_ <= 0) return;
            this.state |= 8;
            return;
        }
        catch (IOException iOException) {
        }
    }

    public int getNumberOfImages() {
        return this.numberOfImages_;
    }

    public int getCapabilities() {
        return 1;
    }

    public void setJimiImage(AdaptiveRasterImage adaptiveRasterImage) {
        this.ji_ = adaptiveRasterImage;
    }

    public void skipImage() throws JimiException {
        ++this.currentImage_;
        if (this.currentImage_ >= this.numberOfImages_) {
            this.state ^= 8;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadImage() throws JimiException {
        try {
            if (this.ii_[this.currentImage_] == null) {
                try {
                    this.din_.reset();
                    this.din_.skip(this.iconDir_.getEntry(this.currentImage_).getImageOffset());
                    this.ii_[this.currentImage_] = new IconImage(this.din_);
                }
                catch (IOException iOException) {
                }
            }
            this.initJimiImage(this.ii_[this.currentImage_]);
            this.ji_.setChannel(0L);
            int n = 0;
            while (true) {
                if (n >= this.ii_[this.currentImage_].getHeight()) {
                    this.state |= 4;
                    ++this.currentImage_;
                    if (this.currentImage_ < this.numberOfImages_) return;
                    this.state ^= 8;
                    return;
                }
                this.ji_.setChannel(0, this.ii_[this.currentImage_].getHeight() - 1 - n, this.ii_[this.currentImage_].getXORMap(), n * this.ii_[this.currentImage_].getWidth(), this.ii_[this.currentImage_].getWidth());
                this.setProgress(n * 100 / this.ii_[this.currentImage_].getHeight());
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.state |= 1;
            throw new JimiException("No more images");
        }
        catch (JimiException jimiException) {
            this.state |= 1;
            throw jimiException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean driveDecoder() throws JimiException {
        try {
            this.loadImage();
            this.ji_.addFullCoverage();
            this.state |= 6;
            return false;
        }
        catch (JimiException jimiException) {
            this.state |= 1;
            throw jimiException;
        }
    }

    public void freeDecoder() throws JimiException {
        this.in_ = null;
        this.din_ = null;
        this.ji_ = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji_;
    }

    private void initJimiImage(IconImage iconImage) throws JimiException {
        this.ji_.setSize(iconImage.getWidth(), iconImage.getHeight());
        RGBQuad[] rGBQuadArray = iconImage.getColors();
        byte[] byArray = new byte[rGBQuadArray.length];
        byte[] byArray2 = new byte[rGBQuadArray.length];
        byte[] byArray3 = new byte[rGBQuadArray.length];
        int n = 0;
        while (n < rGBQuadArray.length) {
            byArray[n] = (byte)rGBQuadArray[n].getRed();
            byArray2[n] = (byte)rGBQuadArray[n].getGreen();
            byArray3[n] = (byte)rGBQuadArray[n].getBlue();
            ++n;
        }
        this.model_ = new IndexColorModel(8, byArray.length, byArray, byArray2, byArray3);
        this.ji_.setColorModel(this.model_);
        this.ji_.setPixels();
    }
}

