/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pcx;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.pcx.PCXHeader;
import com.sun.jimi.core.decoder.pcx.PCXImage;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PCXDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage ji_;
    private InputStream in_;
    private LEDataInputStream din_;
    private int state;
    private int fileLength;
    private PCXHeader header_;
    private byte[] byteScanLine;
    private ColorModel model_;
    private PCXImage pi;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.in_ = inputStream;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 2048);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            int n2;
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                n += n2;
                byteArrayOutputStream.write(byArray);
            }
        }
        catch (IOException iOException) {
        }
        this.din_ = new LEDataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        this.fileLength = n;
        this.ji_ = adaptiveRasterImage;
        this.state = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadImage() throws JimiException {
        try {
            this.initJimiImage(this.pi);
            this.ji_.setChannel(0L);
            int n = 0;
            while (true) {
                if (n >= this.pi.getHeight()) {
                    this.state |= 4;
                    return;
                }
                int n2 = n * this.pi.getWidth();
                this.ji_.setChannel(0, n, this.pi.getImageData(), n2, this.pi.getWidth());
                this.setProgress(n * 100 / this.pi.getHeight());
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.state |= 1;
            throw new JimiException("No more images");
        }
        catch (JimiException jimiException) {
            this.state |= 1;
            throw jimiException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean driveDecoder() throws JimiException {
        try {
            this.header_ = new PCXHeader(this.din_, this.fileLength);
            this.state |= 2;
            this.pi = new PCXImage(this.din_, this.header_);
            this.loadImage();
            this.ji_.addFullCoverage();
            return false;
        }
        catch (IOException iOException) {
            this.state |= 1;
            throw new JimiException("IO error reading PCX file");
        }
        catch (JimiException jimiException) {
            this.state |= 1;
            throw jimiException;
        }
    }

    public void freeDecoder() throws JimiException {
        this.in_ = null;
        this.din_ = null;
        this.ji_ = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji_;
    }

    private void initJimiImage(PCXImage pCXImage) throws JimiException {
        this.ji_.setSize(pCXImage.getWidth(), pCXImage.getHeight());
        this.ji_.setColorModel(this.header_.getColorModel());
        this.ji_.setPixels();
    }
}

