/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pcx;

import com.sun.jimi.core.decoder.pcx.PCXHeader;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

public class PCXImage {
    private PCXHeader header_;
    private byte[] imageData_;
    private int bytesPerLine_;
    private int bitCount_;
    private int planes_;
    private int count = 0;
    private int c = 0;

    public void get16ColorPCX(LEDataInputStream lEDataInputStream) throws IOException {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.bytesPerLine_ * 8 / this.bitCount_;
        if (n > n3) {
            n = n3;
        }
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[this.planes_ * this.bytesPerLine_];
        int n4 = 0;
        while (n4 < n2) {
            this.getPCXRow(lEDataInputStream, byArray2, this.planes_ * this.bytesPerLine_);
            if (this.planes_ == 1) {
                this.pcxUnpackPixels(byArray, byArray2);
            } else {
                this.pcxPlanesToPixels(byArray, byArray2);
            }
            int n5 = 0;
            while (n5 < n) {
                this.imageData_[n4 * this.getWidth() + n5] = byArray[n5];
                ++n5;
            }
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getPCXRow(LEDataInputStream lEDataInputStream, byte[] byArray, int n) {
        try {
            this.count = 0;
            int n2 = 0;
            boolean bl = false;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                if (this.count > 0) {
                    byArray[n2++] = (byte)this.c;
                    --this.count;
                    continue;
                }
                this.c = lEDataInputStream.readByte();
                if ((this.c & 0xC0) != 192) {
                    byArray[n2++] = (byte)this.c;
                    continue;
                }
                this.count = this.c & 0x3F;
                this.c = lEDataInputStream.readByte();
            }
        }
        catch (Exception exception) {
        }
    }

    public void pcxUnpackPixels(byte[] byArray, byte[] byArray2) {
        block5: {
            int n;
            int n2;
            block7: {
                block6: {
                    block4: {
                        n2 = this.bytesPerLine_;
                        int n3 = 0;
                        n = 0;
                        if (this.bitCount_ != 8) break block4;
                        while (--n2 >= 0) {
                            byArray[n3++] = byArray2[n++];
                        }
                        break block5;
                    }
                    if (this.bitCount_ != 4) break block6;
                    while (--n2 >= 0) {
                        byte by = byArray2[n++];
                        byArray[n3++] = (byte)(by >> 4 & 0xF);
                        byArray[n3++] = (byte)(by & 0xF);
                    }
                    break block5;
                }
                if (this.bitCount_ != 2) break block7;
                while (--n2 >= 0) {
                    byte by = byArray2[n++];
                    byArray[n3++] = (byte)(by >> 6 & 3);
                    byArray[n3++] = (byte)(by >> 4 & 3);
                    byArray[n3++] = (byte)(by >> 2 & 3);
                    byArray[n3++] = (byte)(by & 3);
                }
                break block5;
            }
            if (this.bitCount_ != 1) break block5;
            while (--n2 >= 0) {
                byte by = byArray2[n++];
                byArray[n3++] = (byte)(by >> 7 & 1);
                byArray[n3++] = (byte)(by >> 6 & 1);
                byArray[n3++] = (byte)(by >> 5 & 1);
                byArray[n3++] = (byte)(by >> 4 & 1);
                byArray[n3++] = (byte)(by >> 3 & 1);
                byArray[n3++] = (byte)(by >> 2 & 1);
                byArray[n3++] = (byte)(by >> 1 & 1);
                byArray[n3++] = (byte)(by & 1);
            }
        }
    }

    public void pcxPlanesToPixels(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.planes_) {
            n = 0;
            int n4 = 1 << n3;
            int n5 = 0;
            while (n5 < this.bytesPerLine_) {
                byte by = byArray2[n2++];
                int n6 = 128;
                while (n6 != 0) {
                    if ((by & n6) > 0) {
                        int n7 = n;
                        byArray[n7] = (byte)(byArray[n7] | n4);
                    }
                    n6 >>= 1;
                    ++n;
                }
                ++n5;
            }
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void get256ColorPCX(LEDataInputStream var1_1) {
        try {
            var3_2 = 0;
            block2: while (true) {
                if (var3_2 >= this.getHeight()) {
                    return;
                }
                var2_4 = 0;
lbl7:
                // 2 sources

                while (true) {
                    block7: {
                        if (var2_4 >= this.bytesPerLine_) {
                            ++var3_2;
                            continue block2;
                        }
                        var4_5 = var1_1.readByte();
                        var5_6 = 0;
                        if ((var4_5 & 192) != 192) break block7;
                        var6_7 = var1_1.readByte();
                        var5_6 = var4_5 & 63;
                        var7_8 = 0;
                        if (true) ** GOTO lbl29
                    }
                    this.imageData_[var2_4 + var3_2 * this.bytesPerLine_] = var4_5;
                    ++var2_4;
                    continue;
                    break;
                }
                break;
            }
        }
        catch (IOException var3_3) {
        }
        return;
        do {
            this.imageData_[var2_4 + var3_2 * this.bytesPerLine_] = var6_7;
            ++var2_4;
            ++var7_8;
lbl29:
            // 2 sources

        } while (var7_8 < var5_6);
        ** while (true)
    }

    public void getTrueColorPCX(LEDataInputStream lEDataInputStream) {
    }

    public int getBytesPerLine() {
        return this.bytesPerLine_;
    }

    public byte[] getImageData() {
        return this.imageData_;
    }

    public int getBitCount() {
        return this.header_.getDepth();
    }

    public int getWidth() {
        return this.header_.getWidth();
    }

    public int getHeight() {
        return this.header_.getHeight();
    }

    public PCXImage(LEDataInputStream lEDataInputStream, PCXHeader pCXHeader) throws IOException {
        this.header_ = pCXHeader;
        this.planes_ = pCXHeader.getPlanes();
        this.bytesPerLine_ = pCXHeader.getBytesPerLine();
        this.bitCount_ = this.getBitCount();
        this.imageData_ = new byte[this.getHeight() * this.getWidth()];
        boolean bl = false;
        block0 : switch (this.bitCount_) {
            case 1: {
                if (this.planes_ < 1 || this.planes_ > 4) break;
                this.get16ColorPCX(lEDataInputStream);
                break;
            }
            case 2: 
            case 4: {
                if (this.planes_ == 1) {
                    this.get16ColorPCX(lEDataInputStream);
                }
            }
            case 8: {
                switch (this.planes_) {
                    case 1: {
                        this.get256ColorPCX(lEDataInputStream);
                        break block0;
                    }
                    case 3: 
                    case 4: {
                        this.getTrueColorPCX(lEDataInputStream);
                        break block0;
                    }
                }
            }
        }
    }
}

