/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pict;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.pict.PICTPixmap;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.IOException;

class PICTColorTable {
    int id;
    short flags;
    short count;
    short[] red;
    short[] blue;
    short[] green;

    ColorModel createColorModel(PICTPixmap pICTPixmap) throws JimiException {
        if (this.count < 2) {
            throw new JimiException("color count < 2");
        }
        byte[] byArray = new byte[this.count];
        byte[] byArray2 = new byte[this.count];
        byte[] byArray3 = new byte[this.count];
        int n = 0;
        while (n < this.count) {
            byArray[n] = (byte)(this.red[n] >> 8);
            byArray2[n] = (byte)(this.green[n] >> 8);
            byArray3[n] = (byte)(this.blue[n] >> 8);
            ++n;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, (int)this.count, byArray, byArray2, byArray3);
        return indexColorModel;
    }

    PICTColorTable(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readInt();
        this.flags = dataInputStream.readShort();
        this.count = dataInputStream.readShort();
        this.count = (short)(this.count + 1);
        this.red = new short[this.count];
        this.green = new short[this.count];
        this.blue = new short[this.count];
        int n = 0;
        while (n < this.count) {
            int n2 = dataInputStream.readShort();
            if ((this.flags & 0x8000) != 0) {
                n2 = n;
            }
            this.red[n2] = dataInputStream.readShort();
            this.green[n2] = dataInputStream.readShort();
            this.blue[n2] = dataInputStream.readShort();
            ++n;
        }
    }
}

