/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pict;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.pict.PICTBitmap;
import com.sun.jimi.core.decoder.pict.PICTColorTable;
import com.sun.jimi.core.decoder.pict.PICTFileHeader;
import com.sun.jimi.core.decoder.pict.PICTPixmap;
import com.sun.jimi.core.decoder.pict.PICTPixmap9A;
import com.sun.jimi.core.decoder.pict.PICTRectangle;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.Packbits;
import com.sun.jimi.util.ByteCountInputStream;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PICTDecoder
extends JimiDecoderBase {
    public static final int PICT_CLIP_RGN = 1;
    public static final int PICT_BITSRECT = 144;
    public static final int PICT_BITSRGN = 145;
    public static final int PICT_PACKBITSRECT = 152;
    public static final int PICT_PACKBITSRGN = 153;
    public static final int PICT_9A = 154;
    public static final int PICT_HEADER = 3072;
    public static final int PICT_END = 255;
    public static final int PICT_LONGCOMMENT = 161;
    static final int INITIAL = 1;
    static final int STATE2 = 2;
    private AdaptiveRasterImage ji;
    private InputStream in;
    private ByteCountInputStream bcis;
    private DataInputStream dIn;
    private int state;
    PICTFileHeader pictFH;
    int rowBytes;
    int pictState;

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.in = inputStream;
        this.bcis = new ByteCountInputStream(new BufferedInputStream(inputStream));
        this.dIn = new DataInputStream(this.bcis);
        this.ji = adaptiveRasterImage;
        this.state = 0;
        this.pictState = 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean driveDecoder() throws JimiException {
        switch (this.pictState) {
            case 1: {
                try {
                    this.pictFH = new PICTFileHeader(this.dIn);
                }
                catch (IOException iOException) {
                    throw new JimiException("IO error reading PICT file");
                }
                this.pictState = 2;
                this.state |= 2;
                return true;
            }
            case 2: {
                try {
                    int n;
                    if (this.pictFH.ver1) {
                        n = this.dIn.readUnsignedByte();
                        return this.drivePictDecoder(n);
                    } else {
                        if ((this.bcis.getCount() & 1L) != 0L) {
                            this.dIn.readByte();
                        }
                        n = this.dIn.readUnsignedShort();
                    }
                    return this.drivePictDecoder(n);
                }
                catch (IOException iOException) {
                    this.state |= 1;
                    throw new JimiException("reading opcode/version");
                }
                catch (JimiException jimiException) {
                    this.state |= 1;
                    throw jimiException;
                }
            }
        }
        return true;
    }

    public void freeDecoder() throws JimiException {
        this.in = null;
        this.dIn = null;
        this.pictState = 1;
        this.ji = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji;
    }

    public boolean usesChanneledData() {
        return true;
    }

    boolean drivePictDecoder(int n) throws JimiException, IOException {
        boolean bl = false;
        switch (n) {
            case 145: {
                this.handlePackBits(n);
                break;
            }
            case 153: {
                this.handlePackBits(n);
                break;
            }
            case 1: {
                this.skip_01();
                break;
            }
            case 144: {
                this.handlePackBits(n);
                break;
            }
            case 152: {
                this.handlePackBits(n);
                break;
            }
            case 154: {
                this.handlePackBits(n);
                break;
            }
            case 161: {
                this.skip_06();
                break;
            }
            case 255: {
                this.state |= 4;
                return false;
            }
        }
        if (bl) {
            this.skipPictOpcode(n);
        }
        return true;
    }

    void handlePackBits(int n) throws IOException, JimiException {
        if (n == 154) {
            this.handlePixmap(n);
        } else {
            this.rowBytes = this.dIn.readUnsignedShort();
            if (this.pictFH.ver1 || (this.rowBytes & 0x8000) == 0) {
                this.handleBitmap(n);
            } else {
                this.handlePixmap(n);
            }
        }
        this.ji.addFullCoverage();
    }

    void handleBitmap(int n) throws IOException, JimiException {
        this.rowBytes &= 0x3FFF;
        DirectColorModel directColorModel = new DirectColorModel(1, 1, 1, 1);
        PICTBitmap pICTBitmap = new PICTBitmap(this.dIn);
        int n2 = pICTBitmap.bounding.brX - pICTBitmap.bounding.tlX;
        int n3 = pICTBitmap.bounding.brY - pICTBitmap.bounding.tlY;
        this.ji.setSize(n2, n3);
        this.ji.setColorModel(directColorModel);
        this.ji.setPixels();
        byte[] byArray = new byte[this.rowBytes + 1 + this.rowBytes / 128];
        byte[] byArray2 = new byte[this.rowBytes];
        byte[] byArray3 = new byte[n2];
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            if (this.rowBytes < 8) {
                this.dIn.readFully(byArray, 0, this.rowBytes);
                n5 = byArray.length;
                while (--n5 >= 0) {
                    byArray[n5] = ~byArray[n5];
                }
                JimiUtil.expandPixels(1, byArray, byArray3, byArray3.length);
            } else {
                n5 = this.rowBytes > 250 ? this.dIn.readUnsignedShort() : this.dIn.readUnsignedByte();
                this.dIn.readFully(byArray, 0, n5);
                Packbits.unpackbits(byArray, byArray2);
                int n6 = byArray2.length;
                while (--n6 >= 0) {
                    byArray2[n6] = ~byArray2[n6];
                }
                JimiUtil.expandPixels(1, byArray2, byArray3, byArray3.length);
            }
            this.ji.setChannel(0, n4, byArray3);
            this.setProgress(n4 * 100 / (n3 - 1));
            ++n4;
        }
    }

    void handlePixmap(int n) throws IOException, JimiException {
        short s;
        short s2;
        int n2;
        int n3;
        PICTPixmap pICTPixmap = null;
        PICTPixmap9A pICTPixmap9A = null;
        PICTColorTable pICTColorTable = null;
        ColorModel colorModel = null;
        if (n == 154) {
            pICTPixmap9A = new PICTPixmap9A(this.dIn);
            n3 = pICTPixmap9A.bounding.brX - pICTPixmap9A.bounding.tlX;
            n2 = pICTPixmap9A.bounding.brY - pICTPixmap9A.bounding.tlY;
            s2 = pICTPixmap9A.pixelSize;
            s = pICTPixmap9A.compCount;
            switch (s2) {
                case 32: {
                    this.rowBytes = n3 * pICTPixmap9A.compCount;
                    colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                    break;
                }
                case 16: {
                    this.rowBytes = n3 * 2;
                    colorModel = new DirectColorModel(16, 31744, 992, 31);
                    break;
                }
                default: {
                    throw new JimiException("Opcode 9a has pixelSize of " + s2);
                }
            }
        } else {
            this.rowBytes &= 0x3FFF;
            pICTPixmap = new PICTPixmap(this.dIn);
            pICTColorTable = new PICTColorTable(this.dIn);
            colorModel = pICTColorTable.createColorModel(pICTPixmap);
            n3 = pICTPixmap.bounding.brX - pICTPixmap.bounding.tlX;
            n2 = pICTPixmap.bounding.brY - pICTPixmap.bounding.tlY;
            s2 = pICTPixmap.pixelSize;
            s = pICTPixmap.compCount;
        }
        PICTRectangle pICTRectangle = new PICTRectangle(this.dIn);
        PICTRectangle pICTRectangle2 = new PICTRectangle(this.dIn);
        short s3 = this.dIn.readShort();
        if (n == 145 || n == 153) {
            this.skip_01();
        }
        this.ji.setSize(n3, n2);
        this.ji.setColorModel(colorModel);
        this.ji.setPixels();
        this.handlePixmap(this.ji, this.rowBytes, s2, s);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handlePixmap(AdaptiveRasterImage var1_1, int var2_2, int var3_3, short var4_4) throws IOException, JimiException {
        block25: {
            var13_5 = var2_2 >= 8 || var3_3 == 32;
            var10_6 = var2_2;
            var8_7 = null;
            var12_8 = null;
            var9_9 = null;
            var14_10 = var1_1.getWidth();
            var15_11 = var1_1.getHeight();
            var11_12 = var14_10;
            switch (var3_3) {
                case 32: {
                    if (!var13_5) {
                        var9_9 = new int[var14_10];
                        break;
                    }
                    var8_7 = new byte[var10_6];
                    break;
                }
                case 16: {
                    var9_9 = new int[var14_10];
                    break;
                }
                case 8: {
                    var8_7 = new byte[var10_6];
                    break;
                }
                default: {
                    var12_8 = new byte[var11_12];
                    var8_7 = new byte[var10_6];
                    break;
                }
            }
            if (var13_5) break block25;
            var7_13 = new byte[var10_6];
            var5_15 = 0;
            if (true) ** GOTO lbl55
        }
        var7_14 = new byte[var10_6 + 1 + var10_6 / 128];
        var5_16 = 0;
        if (true) ** GOTO lbl86
        do {
            this.dIn.readFully(var7_13, 0, var2_2);
            block6 : switch (var3_3) {
                case 16: {
                    var16_17 = 0;
                    while (true) {
                        if (var16_17 >= var14_10) {
                            var1_1.setChannel(var5_15, var9_9);
                            break block6;
                        }
                        var9_9[var16_17] = ((var7_13[var16_17 * 2] & 255) << 8) + (var7_13[var16_17 * 2 + 1] & 255);
                        ++var16_17;
                    }
                }
                case 8: {
                    var1_1.setChannel(0, var5_15, var7_13);
                    break;
                }
                default: {
                    JimiUtil.expandPixels(var3_3, var7_13, var12_8, var12_8.length);
                    var1_1.setChannel(0, var5_15, var12_8);
                    break;
                }
            }
            this.setProgress(var5_15 * 100 / var15_11);
            ++var5_15;
lbl55:
            // 2 sources

        } while (var5_15 < var15_11);
        return;
        do {
            if ((var6_20 = var2_2 > 250 ? this.dIn.readUnsignedShort() : this.dIn.readUnsignedByte()) > var10_6 + 1 + var10_6 / 128) {
                throw new JimiException("**** rawLen " + var6_20 + " bufSize " + var10_6);
            }
            this.dIn.readFully(var7_14, 0, var6_20);
            if (var3_3 == 16) {
                Packbits.unpackbits(var7_14, var9_9);
                var1_1.setChannel(var5_16, var9_9);
            } else {
                try {
                    Packbits.unpackbitsLimit(var7_14, var6_20, var8_7);
                }
                catch (ArrayIndexOutOfBoundsException var16_19) {
                    throw new JimiException("Error unpacking data");
                }
                if (var3_3 < 8) {
                    JimiUtil.expandPixels(var3_3, var8_7, var12_8, var12_8.length);
                    var1_1.setChannel(0, var5_16, var12_8);
                } else if (var3_3 == 8) {
                    var1_1.setChannel(0, var5_16, var8_7);
                } else if (var3_3 == 24 || var3_3 == 32) {
                    var16_18 = 0;
                    if (var4_4 == 4) {
                        var1_1.setChannel(24, var5_16, var8_7, var16_18, var14_10);
                        var16_18 += var14_10;
                    }
                    var1_1.setChannel(16, var5_16, var8_7, var16_18, var14_10);
                    var1_1.setChannel(8, var5_16, var8_7, var16_18 += var14_10, var14_10);
                    var1_1.setChannel(0, var5_16, var8_7, var16_18 += var14_10, var14_10);
                }
            }
            ++var5_16;
lbl86:
            // 2 sources

        } while (var5_16 < var15_11);
        this.setProgress(var5_16 * 100 / var15_11);
    }

    void skipPictOpcode(int n) {
    }

    void skip_01() throws IOException {
        short s = this.dIn.readShort();
        this.dIn.skip(s - 2);
    }

    void skip_02() throws IOException {
        this.dIn.skip(4L);
        this.skip_03();
    }

    void skip_03() throws IOException {
        int n = this.dIn.readUnsignedByte();
        this.dIn.skip(n);
    }

    void skip_04() throws IOException {
        this.dIn.skip(1L);
        this.skip_03();
    }

    void skip_05() throws IOException {
    }

    void skip_06() throws IOException {
        this.dIn.skip(2L);
        int n = this.dIn.readUnsignedShort();
        this.dIn.skip(n);
    }
}

