/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pict;

import com.sun.jimi.core.decoder.pict.PICT2Header;
import com.sun.jimi.core.decoder.pict.PICTRectangle;
import java.io.DataInputStream;
import java.io.IOException;

public class PICTFileHeader {
    short fileSize;
    PICTRectangle frame;
    byte verOpcode;
    byte verNumber;
    short verOpcode2;
    short verNumber2;
    PICT2Header pict2Header;
    boolean ver1;

    public String toString() {
        String string = "PICT Header ";
        string = this.ver1 ? string + "v1" : string + "v2";
        return string + this.pict2Header.toString();
    }

    public PICTFileHeader(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skip(512L);
        this.fileSize = dataInputStream.readShort();
        this.frame = new PICTRectangle(dataInputStream);
        this.verOpcode = dataInputStream.readByte();
        this.verNumber = dataInputStream.readByte();
        if (this.verOpcode == 17 && this.verNumber == 1) {
            this.ver1 = true;
        } else if (this.verOpcode == 0 && this.verNumber == 17) {
            this.ver1 = false;
            this.verOpcode2 = (short)17;
            this.verNumber2 = dataInputStream.readShort();
            if (this.verNumber2 != 767) {
                throw new IOException("Invalid PICT file format");
            }
            this.pict2Header = new PICT2Header(dataInputStream);
        } else {
            throw new IOException("Invalid PICT file format");
        }
    }
}

