/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pict;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.pict.PICTRectangle;
import java.io.DataInputStream;
import java.io.IOException;

class PICTPixmap {
    PICTRectangle bounding;
    short version;
    short packType;
    int packSize;
    int hRes;
    int vRes;
    short pixelType;
    short pixelSize;
    short compCount;
    short compSize;
    int planeBytes;
    int pmTable;
    int reserved;

    public String toString() {
        return " bounding " + this.bounding.toString() + " version " + this.version + " packType " + this.packType + " packSize " + this.packSize + " hRes " + this.hRes + " vRes " + this.vRes + " pixelType " + this.pixelType + " pixelSize " + this.pixelSize + " compCount " + this.compCount + " compSize " + this.compSize + " planeBytes " + this.planeBytes;
    }

    PICTPixmap(DataInputStream dataInputStream) throws IOException, JimiException {
        this.bounding = new PICTRectangle(dataInputStream);
        this.version = dataInputStream.readShort();
        this.packType = dataInputStream.readShort();
        this.packSize = dataInputStream.readInt();
        this.hRes = dataInputStream.readInt();
        this.vRes = dataInputStream.readInt();
        this.pixelType = dataInputStream.readShort();
        this.pixelSize = dataInputStream.readShort();
        this.compCount = dataInputStream.readShort();
        this.compSize = dataInputStream.readShort();
        this.planeBytes = dataInputStream.readInt();
        this.pmTable = dataInputStream.readInt();
        this.reserved = dataInputStream.readInt();
        if (this.pixelType != 0) {
            throw new JimiException("not a chunky format pixmap");
        }
        if (this.compCount != 1) {
            throw new JimiException("invalid component count");
        }
        if (this.pixelSize != this.compSize) {
            throw new JimiException("pixel size != component size");
        }
    }
}

