/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pict;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.pict.PICTRectangle;
import java.io.DataInputStream;
import java.io.IOException;

class PICTPixmap9A {
    short version;
    PICTRectangle bounding;
    short packType;
    int packSize;
    int hRes;
    int vRes;
    short pixelType;
    short pixelSize;
    short compCount;
    short compSize;
    int planeBytes;
    int pmTable;
    int reserved;

    public String toString() {
        return " 9A bounding " + this.bounding.toString() + " version " + this.version + " packType " + this.packType + " packSize " + this.packSize + " hRes " + this.hRes + " vRes " + this.vRes + " pixelType " + this.pixelType + " pixelSize " + this.pixelSize + " compCount " + this.compCount + " compSize " + this.compSize + " planeBytes " + this.planeBytes;
    }

    PICTPixmap9A(DataInputStream dataInputStream) throws IOException, JimiException {
        dataInputStream.skip(4L);
        this.version = dataInputStream.readShort();
        this.bounding = new PICTRectangle(dataInputStream);
        short s = dataInputStream.readShort();
        this.packType = dataInputStream.readShort();
        this.packSize = dataInputStream.readInt();
        this.hRes = dataInputStream.readInt();
        this.vRes = dataInputStream.readInt();
        this.pixelType = dataInputStream.readShort();
        this.pixelSize = dataInputStream.readShort();
        this.compCount = dataInputStream.readShort();
        this.compSize = dataInputStream.readShort();
        this.planeBytes = dataInputStream.readInt();
        this.pmTable = dataInputStream.readInt();
        this.reserved = dataInputStream.readInt();
        if (this.pixelType != 16) {
            throw new JimiException("not RGBDirect pixmap");
        }
        if (this.compCount != 3 && this.compCount != 4) {
            throw new JimiException("RGBDirect requires 3 or 4 components");
        }
        if (this.pixelSize == 16) {
            if (this.compSize != 5) {
                throw new JimiException("16 bit pixels compSize is not 5 its " + this.compSize);
            }
        } else if (this.pixelSize == 32) {
            if (this.compSize != 8) {
                throw new JimiException("32 bit pixels compSize is not 8 its " + this.compSize);
            }
        } else {
            throw new JimiException("Pixmap 9A requires 16 or 32 bit pixels");
        }
    }
}

