/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.decoder.png.IDATEnumeration;
import com.sun.jimi.core.util.JimiUtil;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class PNGReader {
    static final int CHUNK_bKGD = 1649100612;
    static final int CHUNK_cHRM = 1665684045;
    static final int CHUNK_gAMA = 1732332865;
    static final int CHUNK_hIST = 1749635924;
    static final int CHUNK_IDAT = 1229209940;
    static final int CHUNK_IEND = 1229278788;
    static final int CHUNK_IHDR = 1229472850;
    static final int CHUNK_PLTE = 1347179589;
    static final int CHUNK_pHYs = 1883789683;
    static final int CHUNK_sBIT = 1933723988;
    static final int CHUNK_tEXt = 1950701684;
    static final int CHUNK_tIME = 1950960965;
    static final int CHUNK_tRNS = 1951551059;
    static final int CHUNK_zTXt = 2052348020;
    static final int[] startingRow = new int[]{0, 0, 0, 4, 0, 2, 0, 1};
    static final int[] startingCol = new int[]{0, 0, 4, 0, 2, 0, 1, 0};
    static final int[] rowInc = new int[]{1, 8, 8, 8, 4, 4, 2, 2};
    static final int[] colInc = new int[]{1, 8, 8, 4, 4, 2, 2, 1};
    static final int[] blockHeight = new int[]{1, 8, 8, 4, 4, 2, 2, 1};
    static final int[] blockWidth = new int[]{1, 8, 4, 4, 2, 2, 1, 1};
    static final int CT_PALETTE = 1;
    static final int CT_COLOR = 2;
    static final int CT_ALPHA = 4;
    static final int IT_GRAYSCALE = 0;
    static final int IT_RGB = 2;
    static final int IT_PALETTE = 3;
    static final int IT_GRAYALPHA = 4;
    static final int IT_RGBA = 6;
    private int dataWidth;
    private int dataHeight;
    private int width = -1;
    private int height = -1;
    private int sigmask = 65535;
    private ColorModel model;
    private Object pixels;
    private int[] ipixels;
    private byte[] bpixels;
    private Hashtable properties;
    private Vector theConsumers;
    private boolean multipass;
    private boolean complete;
    private boolean error;
    InputStream underlyingStream_;
    DataInputStream inputStream;
    private Thread controlThread;
    private boolean infoAvailable = false;
    private boolean completePasses = false;
    private int updateDelay = 750;
    private boolean headerFound = false;
    private int compressionMethod = -1;
    private int depth = -1;
    private int colorType = -1;
    private int filterMethod = -1;
    private int interlaceMethod = -1;
    private int pass;
    private byte[] palette;
    private boolean transparency;
    int chunkLength;
    int chunkType;
    boolean needChunkInfo = true;
    AdaptiveRasterImage ji_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void decodeImage() throws JimiException {
        try {
            this.handleSignature();
            while (!this.complete) {
                if (this.error) {
                    return;
                }
                this.handleChunk();
            }
            return;
        }
        catch (IOException iOException) {
            throw new JimiException("IO Error");
        }
    }

    private void handleSignature() throws JimiException, IOException {
        if (this.inputStream.read() != 137 || this.inputStream.read() != 80 || this.inputStream.read() != 78 || this.inputStream.read() != 71 || this.inputStream.read() != 13 || this.inputStream.read() != 10 || this.inputStream.read() != 26 || this.inputStream.read() != 10) {
            throw new JimiException("Not a PNG File");
        }
    }

    private void handleChunk() throws JimiException, IOException {
        if (this.needChunkInfo) {
            this.chunkLength = this.inputStream.readInt();
            this.chunkType = this.inputStream.readInt();
            this.needChunkInfo = false;
        }
        switch (this.chunkType) {
            case 1649100612: {
                this.handlebKGD();
                break;
            }
            case 1665684045: {
                this.handlecHRM();
                break;
            }
            case 1732332865: {
                this.handlegAMA();
                break;
            }
            case 1749635924: {
                this.handlehIST();
                break;
            }
            case 1229209940: {
                this.handleIDAT();
                break;
            }
            case 1229278788: {
                this.handleIEND();
                break;
            }
            case 1229472850: {
                this.handleIHDR();
                break;
            }
            case 1883789683: {
                this.handlepHYs();
                break;
            }
            case 1347179589: {
                this.handlePLTE();
                break;
            }
            case 1933723988: {
                this.handlesBIT();
                break;
            }
            case 1950701684: {
                this.handletEXt();
                break;
            }
            case 1950960965: {
                this.handletIME();
                break;
            }
            case 1951551059: {
                this.handletRNS();
                break;
            }
            case 2052348020: {
                this.handlezTXt();
                break;
            }
            default: {
                this.inputStream.skip(this.chunkLength);
            }
        }
        int n = this.inputStream.readInt();
        this.needChunkInfo = true;
    }

    private void handleIHDR() throws JimiException, IOException {
        if (this.headerFound) {
            throw new JimiException("Extraneous IHDR chunk encountered.");
        }
        if (this.chunkLength != 13) {
            throw new JimiException("IHDR chunk length wrong: " + this.chunkLength);
        }
        this.dataWidth = this.inputStream.readInt();
        this.dataHeight = this.inputStream.readInt();
        this.depth = this.inputStream.read();
        this.colorType = this.inputStream.read();
        this.compressionMethod = this.inputStream.read();
        this.filterMethod = this.inputStream.read();
        this.interlaceMethod = this.inputStream.read();
        this.headerFound = true;
    }

    private void handlePLTE() throws IOException {
        if (this.colorType == 3) {
            this.palette = new byte[this.chunkLength];
            this.inputStream.readFully(this.palette);
        } else {
            this.inputStream.skip(this.chunkLength);
        }
    }

    private void handletRNS() throws JimiException, IOException {
        int n = this.chunkLength;
        switch (this.colorType) {
            case 3: {
                if (this.palette == null) {
                    throw new JimiException("tRNS chunk encountered before pLTE");
                }
                int n2 = this.palette.length;
                this.transparency = true;
                int n3 = n2 / 3;
                byte[] byArray = new byte[n3];
                this.inputStream.readFully(byArray, 0, this.chunkLength);
                int n4 = this.chunkLength;
                while (n4 < n3) {
                    byArray[n4] = -1;
                    ++n4;
                }
                byte[] byArray2 = new byte[n2 + n3];
                int n5 = byArray2.length;
                while (n5 > 0) {
                    byArray2[--n5] = byArray[--n3];
                    byArray2[--n5] = this.palette[--n2];
                    byArray2[--n5] = this.palette[--n2];
                    byArray2[--n5] = this.palette[--n2];
                }
                this.palette = byArray2;
                break;
            }
            default: {
                this.inputStream.skip(this.chunkLength);
            }
        }
    }

    private void handlezTXt() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlebKGD() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlecHRM() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlegAMA() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlehIST() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handleIEND() throws IOException {
        this.complete = true;
    }

    private void handlepHYs() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlesBIT() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handletEXt() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handletIME() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handleIDAT() throws JimiException, IOException {
        if (!this.infoAvailable) {
            if (this.height != -1 && this.width != -1) {
                throw new JimiException("IDAT before IHDR");
            }
            this.width = this.dataWidth;
            this.height = this.dataHeight;
            this.createColorModel();
            this.ji_.setSize(this.width, this.height);
            this.ji_.setColorModel(this.model);
            this.ji_.setPixels();
            if (this.interlaceMethod != 0) {
                this.multipass = true;
            }
            this.infoAvailable = true;
        }
        this.readImageData();
    }

    private void readImageData() throws JimiException, IOException {
        SequenceInputStream sequenceInputStream = new SequenceInputStream(new IDATEnumeration(this));
        DataInputStream dataInputStream = new DataInputStream(new InflaterInputStream(sequenceInputStream, new Inflater()));
        int n = 0;
        switch (this.colorType) {
            case 0: 
            case 3: {
                n = this.depth;
                break;
            }
            case 2: {
                n = 3 * this.depth;
                break;
            }
            case 4: {
                n = this.depth << 1;
                break;
            }
            case 6: {
                n = this.depth << 2;
                break;
            }
        }
        int n2 = n + 7 >> 3;
        this.pass = this.multipass ? 1 : 0;
        while (this.pass < 8) {
            int n3 = this.pass;
            int n4 = rowInc[n3];
            int n5 = colInc[n3];
            int n6 = startingCol[n3];
            int n7 = (this.dataWidth - n6 + n5 - 1) / n5;
            int n8 = n7 * n2;
            int n9 = n7 * n + 7 >> 3;
            int n10 = startingRow[n3];
            if (this.dataHeight > n10 && n9 != 0) {
                int n11 = n4 * this.dataWidth;
                byte[] byArray = new byte[n9];
                int[] nArray = new int[n9];
                int[] nArray2 = null;
                int[] nArray3 = new int[n9];
                int n12 = n10;
                boolean bl = false;
                int n13 = n10;
                while (n13 < this.dataHeight) {
                    int n14 = dataInputStream.read();
                    dataInputStream.readFully(byArray);
                    if (!this.filterRow(byArray, nArray, nArray2, n14, n2)) {
                        throw new JimiException("Unknown filter type: " + n14);
                    }
                    this.insertJimiPixels(nArray, n8, n6, n13);
                    nArray2 = nArray;
                    nArray = nArray3;
                    nArray3 = nArray2;
                    n13 += n4;
                }
                if (!this.multipass) break;
            }
            ++this.pass;
        }
        while (dataInputStream.read() != -1) {
        }
    }

    private void insertJimiPixels(int[] nArray, int n, int n2, int n3) throws JimiException {
        if (startingCol[this.pass] == 0 && colInc[this.pass] == 1) {
            switch (this.colorType) {
                case 0: {
                    if (this.depth == 16) {
                        byte[] byArray = new byte[this.width];
                        int n4 = nArray.length;
                        int n5 = this.width;
                        while (--n5 >= 0) {
                            byArray[n5] = (byte)nArray[n4 -= 2];
                        }
                        this.ji_.setChannel(3, n3, byArray);
                        break;
                    }
                    byte[] byArray = new byte[nArray.length];
                    int n6 = nArray.length;
                    while (--n6 >= 0) {
                        byArray[n6] = (byte)nArray[n6];
                    }
                    if (this.depth == 8) {
                        this.ji_.setChannel(3, n3, byArray);
                        break;
                    }
                    byte[] byArray2 = new byte[this.width];
                    JimiUtil.expandPixels(this.depth, byArray, byArray2, byArray2.length);
                    this.ji_.setChannel(3, n3, byArray2);
                    break;
                }
                case 4: {
                    int[] nArray2 = new int[this.width];
                    if (this.depth == 16) {
                        int n7 = nArray.length;
                        int n8 = this.width;
                        while (--n8 >= 0) {
                            n7 = n7 - 2;
                            nArray2[n8] = nArray[n7] | nArray[n7 -= 2] << 8;
                        }
                        this.ji_.setChannel(n3, nArray2);
                        break;
                    }
                    int n9 = nArray.length;
                    int n10 = this.width;
                    while (--n10 >= 0) {
                        nArray2[n10] = nArray[--n9] | nArray[--n9] << 8;
                    }
                    this.ji_.setChannel(n3, nArray2);
                    break;
                }
                case 2: {
                    int[] nArray3 = new int[this.width];
                    if (this.depth == 8) {
                        int n11 = nArray.length;
                        int n12 = this.width;
                        while (--n12 >= 0) {
                            nArray3[n12] = nArray[--n11] | nArray[--n11] << 8 | nArray[--n11] << 16;
                        }
                        this.ji_.setChannel(n3, nArray3);
                        break;
                    }
                    int n13 = nArray.length;
                    int n14 = this.width;
                    while (--n14 >= 0) {
                        int n15 = n13 - 2;
                        n13 = n15;
                        n13 = n13 - 2;
                        nArray3[n14] = nArray[n15] | nArray[n13] << 8 | nArray[n13 -= 2] << 16;
                    }
                    this.ji_.setChannel(n3, nArray3);
                    break;
                }
                case 3: {
                    byte[] byArray = new byte[nArray.length];
                    int n16 = nArray.length;
                    while (--n16 >= 0) {
                        byArray[n16] = (byte)nArray[n16];
                    }
                    if (this.depth == 8) {
                        this.ji_.setChannel(0, n3, byArray);
                        break;
                    }
                    byte[] byArray3 = new byte[this.width];
                    JimiUtil.expandPixels(this.depth, byArray, byArray3, byArray3.length);
                    this.ji_.setChannel(0, n3, byArray3);
                    break;
                }
                case 6: {
                    if (this.depth == 8) {
                        int[] nArray4 = new int[this.width];
                        int n17 = nArray.length;
                        int n18 = this.width;
                        while (--n18 >= 0) {
                            nArray4[n18] = nArray[--n17] << 24 | nArray[--n17] | nArray[--n17] << 8 | nArray[--n17] << 16;
                        }
                        this.ji_.setChannel(n3, nArray4);
                        break;
                    }
                    int[] nArray5 = new int[this.width];
                    int n19 = nArray.length;
                    int n20 = this.width;
                    while (--n20 >= 0) {
                        int n21 = n19 - 2;
                        n19 = n21;
                        int n22 = n19 - 2;
                        n19 = n22;
                        n19 = n19 - 2;
                        nArray5[n20] = nArray[n21] << 24 | nArray[n22] | nArray[n19] << 8 | nArray[n19 -= 2] << 16;
                    }
                    this.ji_.setChannel(n3, nArray5);
                    break;
                }
            }
        } else {
            this.insertPixels(nArray, n, n2, n3);
        }
    }

    private void insertPixels(int[] nArray, int n, int n2, int n3) throws JimiException {
        switch (this.colorType) {
            case 0: 
            case 4: {
                this.insertGreyPixels(nArray, n, n2, n3);
                break;
            }
            case 2: {
                int n4 = 0;
                int n5 = colInc[this.pass];
                if (this.depth == 8) {
                    n4 = 0;
                    while (n4 < n) {
                        this.ji_.setChannel(n2, n3, nArray[n4++] << 16 | nArray[n4++] << 8 | nArray[n4++]);
                        n2 += n5;
                    }
                } else {
                    n4 = 0;
                    while (n4 < n) {
                        int n6 = nArray[n4] << 16;
                        n4 = n4 + 2;
                        this.ji_.setChannel(n2, n3, n6 | nArray[n4] << 8 | nArray[n4 += 2]);
                        n4 += 2;
                        n2 += n5;
                    }
                }
                break;
            }
            case 3: {
                this.insertPalettedPixels(nArray, n, n2, n3);
                break;
            }
            case 6: {
                int n7 = 0;
                int[] nArray2 = this.ipixels;
                int n8 = colInc[this.pass];
                if (this.depth == 8) {
                    n7 = 0;
                    while (n7 < n) {
                        this.ji_.setChannel(n2, n3, nArray[n7++] << 16 | nArray[n7++] << 8 | nArray[n7++] | nArray[n7++] << 24);
                        n2 += n8;
                    }
                } else {
                    n7 = 0;
                    while (n7 < n) {
                        int n9 = nArray[n7] << 16;
                        int n10 = n7 + 2;
                        n7 = n10;
                        n7 = n7 + 2;
                        this.ji_.setChannel(n2, n3, n9 | nArray[n10] << 8 | nArray[n7] | nArray[n7 += 2] << 24);
                        n7 += 2;
                        n2 += n8;
                    }
                }
                break;
            }
        }
    }

    private void insertGreyPixels(int[] nArray, int n, int n2, int n3) throws JimiException {
        int n4 = nArray[0];
        int n5 = colInc[this.pass];
        int n6 = 0;
        block0 : switch (this.colorType) {
            case 0: {
                switch (this.depth) {
                    case 1: {
                        int n7 = 0;
                        while (n7 < n) {
                            if (n6 != 0) {
                                --n6;
                            } else {
                                n6 = 7;
                                n4 = nArray[n7 >> 3];
                            }
                            this.ji_.setChannel(n2, n3, n4 >> n6 & 1);
                            ++n7;
                            n2 += n5;
                        }
                        break block0;
                    }
                    case 2: {
                        int n8 = 0;
                        while (n8 < n) {
                            if (n6 != 0) {
                                n6 -= 2;
                            } else {
                                n6 = 6;
                                n4 = nArray[n8 >> 2];
                            }
                            this.ji_.setChannel(n2, n3, n4 >> n6 & 3);
                            ++n8;
                            n2 += n5;
                        }
                        break block0;
                    }
                    case 4: {
                        int n9 = 0;
                        while (n9 < n) {
                            if (n6 != 0) {
                                n6 = 0;
                            } else {
                                n6 = 4;
                                n4 = nArray[n9 >> 1];
                            }
                            this.ji_.setChannel(n2, n3, n4 >> n6 & 0xF);
                            ++n9;
                            n2 += n5;
                        }
                        break block0;
                    }
                    case 8: {
                        int n10 = 0;
                        while (n10 < n) {
                            this.ji_.setChannel(n2, n3, nArray[n10]);
                            ++n10;
                            n2 += n5;
                        }
                        break block0;
                    }
                    case 16: {
                        int n11 = 0;
                        while (n11 < n) {
                            this.ji_.setChannel(n2, n3, nArray[n11]);
                            n11 += 2;
                            n2 += n5;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                if (this.depth == 8) {
                    int n12 = 0;
                    while (n12 < n) {
                        this.ji_.setChannel(n2, n3, nArray[n12++] << 8 | nArray[n12++]);
                        n2 += n5;
                    }
                } else {
                    int n13 = 0;
                    while (n13 < n) {
                        this.ji_.setChannel(n2, n3, nArray[n13] << 8 | nArray[n13 += 2]);
                        n13 += 2;
                        n2 += n5;
                    }
                }
                break;
            }
        }
    }

    private void insertPalettedPixels(int[] nArray, int n, int n2, int n3) throws JimiException {
        int n4 = 0;
        int n5 = nArray[0];
        byte[] byArray = this.bpixels;
        int n6 = colInc[this.pass];
        switch (this.depth) {
            case 1: {
                int n7 = 0;
                while (n7 < n) {
                    if (n4 != 0) {
                        --n4;
                    } else {
                        n4 = 7;
                        n5 = nArray[n7 >> 3];
                    }
                    this.ji_.setChannel(n2, n3, n5 >> n4 & 1);
                    ++n7;
                    n2 += n6;
                }
                break;
            }
            case 2: {
                int n8 = 0;
                while (n8 < n) {
                    if (n4 != 0) {
                        n4 -= 2;
                    } else {
                        n4 = 6;
                        n5 = nArray[n8 >> 2];
                    }
                    this.ji_.setChannel(n2, n3, n5 >> n4 & 3);
                    ++n8;
                    n2 += n6;
                }
                break;
            }
            case 4: {
                int n9 = 0;
                while (n9 < n) {
                    if (n4 != 0) {
                        n4 = 0;
                    } else {
                        n4 = 4;
                        n5 = nArray[n9 >> 1];
                    }
                    this.ji_.setChannel(n2, n3, n5 >> n4 & 0xF);
                    ++n9;
                    n2 += n6;
                }
                break;
            }
            case 8: {
                int n10 = 0;
                while (n10 < n) {
                    this.ji_.setChannel(n2, n3, nArray[n10]);
                    ++n10;
                    n2 += n6;
                }
                break;
            }
        }
    }

    private boolean filterRow(byte[] byArray, int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = nArray.length;
        switch (n) {
            case 0: {
                int n4 = 0;
                while (n4 < n3) {
                    nArray[n4] = 0xFF & byArray[n4];
                    ++n4;
                }
                break;
            }
            case 1: {
                int n5 = 0;
                while (n5 < n2) {
                    nArray[n5] = 0xFF & byArray[n5];
                    ++n5;
                }
                while (n5 < n3) {
                    nArray[n5] = 0xFF & byArray[n5] + nArray[n5 - n2];
                    ++n5;
                }
                break;
            }
            case 2: {
                if (nArray2 != null) {
                    int n6 = 0;
                    while (n6 < n3) {
                        nArray[n6] = 0xFF & nArray2[n6] + byArray[n6];
                        ++n6;
                    }
                } else {
                    int n7 = 0;
                    while (n7 < n3) {
                        nArray[n7] = 0xFF & byArray[n7];
                        ++n7;
                    }
                }
                break;
            }
            case 3: {
                if (nArray2 != null) {
                    int n8;
                    int n9 = 0;
                    while (n9 < n2) {
                        n8 = nArray2[n9];
                        nArray[n9] = 0xFF & (n8 >> 1) + byArray[n9];
                        ++n9;
                    }
                    while (n9 < n3) {
                        n8 = nArray2[n9] + nArray[n9 - n2];
                        nArray[n9] = 0xFF & (n8 >> 1) + byArray[n9];
                        ++n9;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < n2) {
                        nArray[n10] = 0xFF & byArray[n10];
                        ++n10;
                    }
                    while (n10 < n3) {
                        int n11 = nArray[n10 - n2];
                        nArray[n10] = 0xFF & (n11 >> 1) + byArray[n10];
                        ++n10;
                    }
                }
                break;
            }
            case 4: {
                if (nArray2 != null) {
                    int n12 = 0;
                    while (n12 < n2) {
                        nArray[n12] = 0xFF & nArray2[n12] + byArray[n12];
                        ++n12;
                    }
                    while (n12 < n3) {
                        int n13;
                        int n14 = nArray[n12 - n2];
                        int n15 = nArray2[n12];
                        int n16 = nArray2[n12 - n2];
                        int n17 = n14 + n15 - n16;
                        int n18 = n17 > n14 ? n17 - n14 : n14 - n17;
                        int n19 = n17 > n15 ? n17 - n15 : n15 - n17;
                        int n20 = n13 = n17 > n16 ? n17 - n16 : n16 - n17;
                        int n21 = n18 <= n19 && n18 <= n13 ? n14 : (n19 <= n13 ? n15 : n16);
                        nArray[n12] = 0xFF & n21 + byArray[n12];
                        ++n12;
                    }
                } else {
                    int n22 = 0;
                    while (n22 < n2) {
                        nArray[n22] = 0xFF & byArray[n22];
                        ++n22;
                    }
                    while (n22 < n3) {
                        int n23 = nArray[n22 - n2];
                        nArray[n22] = 0xFF & n23 + byArray[n22];
                        ++n22;
                    }
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void createColorModel() throws JimiException, IOException {
        int n = 0;
        n = this.depth == 16 ? 255 : (1 << this.depth) - 1;
        switch (this.colorType) {
            case 3: {
                if (this.palette == null) {
                    throw new JimiException("No palette located");
                }
                if (this.transparency) {
                    this.model = new IndexColorModel(8, this.palette.length / 4, this.palette, 0, true);
                    break;
                }
                this.model = new IndexColorModel(8, this.palette.length / 3, this.palette, 0, false);
                break;
            }
            case 0: {
                if (this.depth == 16) {
                    this.model = new DirectColorModel(8, n, n, n);
                    break;
                }
                this.model = new DirectColorModel(this.depth, n, n, n);
                break;
            }
            case 2: {
                this.model = new DirectColorModel(24, 0xFF0000, 65280, 255);
                break;
            }
            case 4: {
                int n2 = n << 8;
                this.model = new DirectColorModel(16, n2, n2, n2, n);
                break;
            }
            case 6: {
                this.model = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
                break;
            }
            default: {
                throw new JimiException("Image has unknown color type " + this.colorType);
            }
        }
    }

    PNGReader(DataInputStream dataInputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.underlyingStream_ = dataInputStream;
        this.inputStream = dataInputStream;
        this.ji_ = adaptiveRasterImage;
    }
}

