/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.sunraster;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.sunraster.RLEInputStream;
import com.sun.jimi.core.decoder.sunraster.SunRasterColorMap;
import com.sun.jimi.core.decoder.sunraster.SunRasterHeader;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SunRasterDecoder
extends JimiDecoderBase {
    private static final int RLE_ESCAPE = 128;
    DataInputStream lin;
    AdaptiveRasterImage sinkImage;
    SunRasterHeader header;
    SunRasterColorMap colormap;
    int state;

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        if (inputStream == null || adaptiveRasterImage == null) {
            throw new IllegalArgumentException("Null values to constructor.");
        }
        this.lin = new DataInputStream(inputStream);
        this.sinkImage = adaptiveRasterImage;
        this.state = 0;
    }

    public void freeDecoder() throws JimiException {
        this.lin = null;
        this.sinkImage = null;
        this.header = null;
        this.colormap = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean driveDecoder() throws JimiException {
        try {
            this.sinkImage = this.getJimiImage();
            if (this.state == 0) {
                this.header = new SunRasterHeader(this.lin);
                if (this.header.ColorMapType != 0) {
                    this.colormap = new SunRasterColorMap(this.lin, this.header);
                } else if (this.header.ColorMapType == 2) {
                    throw new JimiException("Unsupported Format Subtype");
                }
                this.initJimiImage();
                this.state |= 2;
                return true;
            }
            if (this.decodeImage()) {
                this.state |= 4;
            }
            this.sinkImage.addFullCoverage();
            return false;
        }
        catch (JimiException jimiException) {
            this.state |= 1;
            throw jimiException;
        }
        catch (IOException iOException) {
            this.state |= 1;
            throw new JimiException("IOException while reading file : " + iOException.toString());
        }
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.sinkImage;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initJimiImage() throws JimiException {
        this.sinkImage.setSize(this.header.Width, this.header.Height);
        if (this.colormap != null) {
            if (this.colormap.RGBType) {
                this.sinkImage.setColorModel(new IndexColorModel(8, this.colormap.tableLength, this.colormap.r, this.colormap.g, this.colormap.b));
            } else {
                this.sinkImage.setColorModel(new IndexColorModel(8, this.colormap.tableLength, this.colormap.raw, 0, false));
            }
lbl8:
            // 3 sources

            while (true) {
                this.sinkImage.setPixels();
                return;
            }
        }
        var4_1 = 0;
        var5_2 = this.header.Depth / 3;
        if (true) ** GOTO lbl20
        do {
            var4_1 <<= 1;
            ++var4_1;
            --var5_2;
lbl20:
            // 2 sources

        } while (var5_2 > 0);
        this.sinkImage.setColorModel(new DirectColorModel(24, 0xFF0000, 65280, 255));
        ** while (true)
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean decodeImage() throws IOException, JimiException {
        block17: {
            block16: {
                try {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    if (this.header.Type == 2) {
                                        this.RLEDecodeImage();
                                        break block16;
                                    }
                                    var1_1 = this.header.Width * this.header.Depth;
                                    if (var1_1 % 16 != 0) {
                                        var1_1 += 16 - var1_1 % 16;
                                    }
                                    var1_1 /= 8;
                                    if (this.header.Depth != 8) break block18;
                                    var2_4 = new byte[this.header.Width];
                                    var3_9 = 0;
                                    if (true) ** GOTO lbl62
                                }
                                if (this.header.Depth != 4) break block19;
                                var2_5 = new byte[this.header.Width];
                                var3_10 = 0;
                                if (true) ** GOTO lbl77
                            }
                            if (this.header.Depth < 8) break block16;
                            if (this.header.Depth != 16) break block20;
                            var2_6 = new int[this.header.Width];
                            var3_11 = 0;
                            if (true) ** GOTO lbl90
                        }
                        if (this.header.Depth < 16) break block16;
                        if (this.header.Depth != 24) break block21;
                        var2_7 = new int[this.header.Width];
                        var3_12 = 0;
                        if (true) ** GOTO lbl120
                    }
                    if (this.header.Depth != 32) break block16;
                    var2_8 = new int[this.header.Width];
                    var3_13 = 0;
lbl34:
                    // 2 sources

                    while (true) {
                        block22: {
                            if (var3_13 >= this.header.Height) break block16;
                            if (this.header.Type != 3) break block22;
                            var4_17 = 0;
                            if (true) ** GOTO lbl132
                        }
                        var4_17 = 0;
                        while (var4_17 < var2_8.length) {
                            this.lin.readByte();
                            var5_20 = this.lin.readUnsignedByte();
                            var6_22 = this.lin.readUnsignedByte();
                            var7_24 = this.lin.readUnsignedByte();
                            var2_8[var4_17] = var7_24 << 16 | var6_22 << 8 | var5_20;
                            ++var4_17;
                        }
                        break block17;
                        break;
                    }
                }
                catch (JimiException var1_2) {
                    throw var1_2;
                }
                catch (IOException var1_3) {
                    throw var1_3;
                }
                do {
                    this.lin.readFully(var2_4, 0, this.header.Width);
                    this.lin.skipBytes(var1_1 - var2_4.length);
                    this.sinkImage.setChannel(0, var3_9, var2_4);
                    this.setProgress(var3_9 * 100 / this.header.Height);
                    ++var3_9;
lbl62:
                    // 2 sources

                } while (var3_9 < this.header.Height);
                break block16;
                do {
                    var4_14 = 0;
                    while (var4_14 < var2_5.length) {
                        var5_18 = this.lin.readByte();
                        var2_5[var4_14] = (byte)(var5_18 >> 4);
                        var2_5[var4_14 + 1] = (byte)(var5_18 & 15);
                        var4_14 += 2;
                    }
                    this.lin.skipBytes(var1_1 - var2_5.length / 2);
                    this.sinkImage.setChannel(0, var3_10, var2_5);
                    this.setProgress(var3_10 * 100 / this.header.Height);
                    ++var3_10;
lbl77:
                    // 2 sources

                } while (var3_10 < this.header.Height);
                break block16;
                do {
                    var4_15 = 0;
                    while (var4_15 < var2_6.length) {
                        var2_6[var4_15] = this.lin.readInt();
                        ++var4_15;
                    }
                    this.lin.skipBytes(var1_1 - var2_6.length * 2);
                    this.sinkImage.setChannel(var3_11, var2_6);
                    this.setProgress(var3_11 * 100 / this.header.Height);
                    ++var3_11;
lbl90:
                    // 2 sources

                } while (var3_11 < this.header.Height);
                break block16;
                do {
                    block24: {
                        block23: {
                            if (this.header.Type != 3) break block23;
                            var4_16 = 0;
                            if (true) ** GOTO lbl105
                        }
                        var4_16 = 0;
                        if (true) ** GOTO lbl113
                        do {
                            var5_19 = this.lin.readUnsignedByte();
                            var6_21 = this.lin.readUnsignedByte();
                            var7_23 = this.lin.readUnsignedByte();
                            var2_7[var4_16] = var5_19 << 16 | var6_21 << 8 | var7_23;
                            ++var4_16;
lbl105:
                            // 2 sources

                        } while (var4_16 < var2_7.length);
                        break block24;
                        do {
                            var5_19 = this.lin.readUnsignedByte();
                            var6_21 = this.lin.readUnsignedByte();
                            var7_23 = this.lin.readUnsignedByte();
                            var2_7[var4_16] = var7_23 << 16 | var6_21 << 8 | var5_19;
                            ++var4_16;
lbl113:
                            // 2 sources

                        } while (var4_16 < var2_7.length);
                    }
                    this.lin.skipBytes(var1_1 - var2_7.length * 3);
                    this.sinkImage.setChannel(var3_12, var2_7);
                    this.setProgress(var3_12 * 100 / this.header.Height);
                    ++var3_12;
lbl120:
                    // 2 sources

                } while (var3_12 < this.header.Height);
            }
            this.state |= 4;
            return true;
            do {
                this.lin.readByte();
                var5_20 = this.lin.readUnsignedByte();
                var6_22 = this.lin.readUnsignedByte();
                var7_24 = this.lin.readUnsignedByte();
                var2_8[var4_17] = var5_20 << 16 | var6_22 << 8 | var7_24;
                ++var4_17;
lbl132:
                // 2 sources

            } while (var4_17 < var2_8.length);
        }
        this.lin.skipBytes(var1_1 - var2_8.length * 4);
        this.sinkImage.setChannel(var3_13, var2_8);
        this.setProgress(var3_13 * 100 / this.header.Height);
        ++var3_13;
        ** while (true)
    }

    protected void RLEDecodeImage() throws IOException, JimiException {
        RLEInputStream rLEInputStream = new RLEInputStream(this.lin);
        byte[] byArray = new byte[this.header.Width];
        boolean bl = byArray.length % 2 != 0;
        int n = this.header.Height;
        int n2 = 0;
        while (n2 < n) {
            ((InputStream)rLEInputStream).read(byArray);
            if (bl) {
                ((InputStream)rLEInputStream).read();
            }
            SunRasterDecoder.flushOut(byArray, this.sinkImage, n2);
            ++n2;
        }
    }

    private static void flushOut(byte[] byArray, AdaptiveRasterImage adaptiveRasterImage, int n) throws JimiException {
        adaptiveRasterImage.setChannel(0, n, byArray);
    }

    public boolean usesChanneledData() {
        return true;
    }
}

