/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tga;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.tga.TGAColorMap;
import com.sun.jimi.core.decoder.tga.TGAFileHeader;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TGADecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage ji;
    private InputStream in;
    private LEDataInputStream dIn;
    private int state;
    TGAFileHeader tgaFH;
    TGAColorMap tgaCM;

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.in = inputStream;
        this.dIn = new LEDataInputStream(new BufferedInputStream(inputStream));
        this.ji = adaptiveRasterImage;
        this.state = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean driveDecoder() throws JimiException {
        try {
            this.tgaFH = new TGAFileHeader(this.dIn);
            this.tgaCM = new TGAColorMap(this.dIn, this.tgaFH);
            this.initJimiImage();
            this.state |= 2;
            this.decodeImage(this.dIn);
            this.state |= 4;
            this.ji.addFullCoverage();
            return false;
        }
        catch (IOException iOException) {
            throw new JimiException("IO error reading TGA file");
        }
    }

    public void freeDecoder() throws JimiException {
        this.in = null;
        this.dIn = null;
        this.ji = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji;
    }

    private void initJimiImage() throws JimiException {
        block0 : switch (this.tgaFH.imageType) {
            case 0: {
                throw new JimiException("TGADecoder no image found.");
            }
            case 1: 
            case 9: {
                if (this.tgaFH.colorMapType == 0) {
                    throw new JimiException("TGADecoder color mapped images require a color map.");
                }
                this.ji.setColorModel(new IndexColorModel(8, this.tgaCM.cmap.length / 3, this.tgaCM.cmap, 0, this.tgaFH.colorMapEntrySize == 32));
                break;
            }
            case 3: 
            case 11: {
                if (this.tgaFH.colorMapType != 0) {
                    throw new JimiException("TGADecoder gray scale should not have color map.");
                }
                this.ji.setColorModel(new DirectColorModel(8, 255, 255, 255));
                break;
            }
            case 2: 
            case 10: {
                switch (this.tgaFH.pixelDepth) {
                    case 16: {
                        this.ji.setColorModel(new DirectColorModel(16, 31744, 992, 31));
                        break block0;
                    }
                    case 24: 
                    case 32: {
                        this.ji.setColorModel(new DirectColorModel(24, 0xFF0000, 65280, 255));
                        break block0;
                    }
                }
                break;
            }
        }
        this.ji.setSize(this.tgaFH.width, this.tgaFH.height);
        this.ji.setPixels();
    }

    private void decodeImage(LEDataInputStream lEDataInputStream) throws JimiException, IOException {
        block0 : switch (this.tgaFH.imageType) {
            case 1: {
                this.decodeImageU8(lEDataInputStream);
                break;
            }
            case 2: {
                switch (this.tgaFH.pixelDepth) {
                    case 16: {
                        this.decodeRGBImageU16(lEDataInputStream);
                        break block0;
                    }
                    case 24: 
                    case 32: {
                        this.decodeRGBImageU24_32(lEDataInputStream);
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                this.decodeImageU8(lEDataInputStream);
                break;
            }
            case 9: {
                throw new JimiException("TGADecoder Compressed Colormapped images not supported");
            }
            case 10: {
                throw new IOException("TGADecoder Compressed True Color images not supported");
            }
            case 11: {
                throw new IOException("TGADecoder Compressed Grayscale images not supported");
            }
        }
    }

    private void decodeImageU8(LEDataInputStream lEDataInputStream) throws IOException, JimiException {
        byte[] byArray = new byte[this.tgaFH.width];
        int n = 0;
        while (n < this.tgaFH.height) {
            lEDataInputStream.readFully(byArray, 0, this.tgaFH.width);
            int n2 = this.tgaFH.topToBottom ? n : this.tgaFH.height - n - 1;
            this.ji.setChannel(0, n2, byArray);
            this.setProgress(n * 100 / this.tgaFH.height);
            ++n;
        }
    }

    private void decodeRGBImageU24_32(LEDataInputStream lEDataInputStream) throws IOException, JimiException {
        int n = this.tgaFH.width * (this.tgaFH.pixelDepth / 8);
        byte[] byArray = new byte[n];
        int[] nArray = new int[this.tgaFH.width];
        int n2 = 0;
        while (n2 < this.tgaFH.height) {
            int n3;
            int n4;
            lEDataInputStream.readFully(byArray, 0, n);
            if (this.tgaFH.pixelDepth == 24) {
                n4 = 0;
                n3 = 0;
                while (n3 < this.tgaFH.width) {
                    nArray[n3] = -16777216 + ((byArray[n4 + 2] & 0xFF) << 16) + ((byArray[n4 + 1] & 0xFF) << 8) + (byArray[n4] & 0xFF);
                    n4 += 3;
                    ++n3;
                }
            } else if (this.tgaFH.pixelDepth == 32) {
                n4 = 0;
                n3 = 0;
                while (n3 < this.tgaFH.width) {
                    nArray[n3] = ((byArray[n4 + 3] & 0xFF) << 24) + ((byArray[n4 + 2] & 0xFF) << 16) + ((byArray[n4 + 1] & 0xFF) << 8) + (byArray[n4] & 0xFF);
                    n4 += 4;
                    ++n3;
                }
            } else {
                throw new JimiException("TGADecoder pixelDepth not 24 or 32");
            }
            int n5 = this.tgaFH.topToBottom ? n2 : this.tgaFH.height - n2 - 1;
            this.ji.setChannel(n5, nArray);
            this.setProgress(n2 * 100 / this.tgaFH.height);
            ++n2;
        }
    }

    private void decodeRGBImageU16(LEDataInputStream lEDataInputStream) throws IOException, JimiException {
        int[] nArray = new int[this.tgaFH.width];
        int n = 0;
        while (n < this.tgaFH.height) {
            int n2 = 0;
            while (n2 < this.tgaFH.width) {
                nArray[n2] = lEDataInputStream.readUnsignedShort() & Short.MAX_VALUE;
                ++n2;
            }
            int n3 = this.tgaFH.topToBottom ? n : this.tgaFH.height - n - 1;
            this.ji.setChannel(n3, nArray);
            this.setProgress(n * 100 / this.tgaFH.height);
            ++n;
        }
    }
}

