/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tga;

import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

public class TGAFileHeader {
    static final int TYPE_NEW = 0;
    static final int TYPE_OLD = 1;
    static final int TYPE_UNK = 2;
    static final int NO_IMAGE = 0;
    static final int UCOLORMAPPED = 1;
    static final int UTRUECOLOR = 2;
    static final int UBLACKWHITE = 3;
    static final int COLORMAPPED = 9;
    static final int TRUECOLOR = 10;
    static final int BLACKWHITE = 11;
    static final int ID_ATTRIBPERPIXEL = 15;
    static final int ID_LEFTTORIGHT = 16;
    static final int ID_TOPTOBOTTOM = 32;
    static final int ID_INTERLEAVE = 192;
    static final int I_NOTINTERLEAVED = 0;
    static final int I_TWOWAY = 1;
    static final int I_FOURWAY = 2;
    int tgaType = 1;
    int idLength;
    int colorMapType;
    int imageType;
    int firstEntryIndex;
    int colorMapLength;
    byte colorMapEntrySize;
    int xOrigin;
    int yOrigin;
    int width;
    int height;
    byte pixelDepth;
    byte imageDescriptor;
    byte attribPerPixel;
    boolean leftToRight;
    boolean topToBottom;
    byte interleave;
    byte[] imageIDbuf;
    String imageID;

    public String toString() {
        return "TGA Header " + " id length: " + this.idLength + " color map type: " + this.colorMapType + " image type: " + this.imageType + " first entry index: " + this.firstEntryIndex + " color map length: " + this.colorMapLength + " color map entry size: " + this.colorMapEntrySize + " x Origin: " + this.xOrigin + " y Origin: " + this.yOrigin + " width: " + this.width + " height: " + this.height + " pixel depth: " + this.pixelDepth + " image descriptor: " + this.imageDescriptor + (this.imageIDbuf == null ? "" : " ID String: " + this.imageID);
    }

    public TGAFileHeader(LEDataInputStream lEDataInputStream) throws IOException {
        this.idLength = lEDataInputStream.readUnsignedByte();
        this.colorMapType = lEDataInputStream.readUnsignedByte();
        this.imageType = lEDataInputStream.readUnsignedByte();
        this.firstEntryIndex = lEDataInputStream.readUnsignedShort();
        this.colorMapLength = lEDataInputStream.readUnsignedShort();
        this.colorMapEntrySize = lEDataInputStream.readByte();
        this.xOrigin = lEDataInputStream.readUnsignedShort();
        this.yOrigin = lEDataInputStream.readUnsignedShort();
        this.width = lEDataInputStream.readUnsignedShort();
        this.height = lEDataInputStream.readUnsignedShort();
        this.pixelDepth = lEDataInputStream.readByte();
        this.imageDescriptor = lEDataInputStream.readByte();
        this.attribPerPixel = (byte)(this.imageDescriptor & 0xF);
        this.leftToRight = (this.imageDescriptor & 0x10) != 0;
        this.topToBottom = (this.imageDescriptor & 0x20) != 0;
        this.interleave = (byte)((this.imageDescriptor & 0xC0) >> 6);
        if (this.idLength > 0) {
            this.imageIDbuf = new byte[this.idLength];
            lEDataInputStream.read(this.imageIDbuf, 0, this.idLength);
            this.imageID = new String(this.imageIDbuf, 0);
        }
    }
}

