/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.tiff.Decompressor;
import com.sun.jimi.core.decoder.tiff.TiffNumberReader;

class CCITT3d1Decomp
extends Decompressor {
    static final int[] trailMask = new int[]{0, 128, 192, 224, 240, 248, 252, 254, 255};
    static final int[] leadMask = new int[]{0, 127, 63, 31, 15, 7, 3, 1};
    static int[][] Dim1Dict = new int[][]{{135169, 134402, 131849, 132132, 139269, 132683, 167175, 133253, 0, 133671, 133942, 134196, 1, 134689, 135049, 2, 136721, 136210, 138259, 3, 136478, 4, 137495, 141848, 5, 138010, 6, 7, 138631, 8, 142879, 9, 10, 147746, 143651, 11, 145701, 149286, 12, 141372, 141631, 13, 165419, 142636, 14, 15, 143407, 16, 17, 143945, 144302, 18, 151861, 19, 153399, 152632, 20, 146014, 146277, 21, 146765, 147048, 22, 158528, 23, 161602, 148803, 159300, 24, 149105, 25, 149620, 26, 163658, 27, 164428, 28, 151222, 151631, 29, 30, 152402, 31, 32, 153173, 33, 34, 154456, 154201, 35, 36, 154972, 37, 38, 156255, 156000, 39, 40, 156771, 41, 42, 157542, 43, 44, 158313, 45, 46, 159084, 47, 48, 159855, 49, 50, 160626, 51, 52, 161397, 53, 54, 166008, 162937, 162682, 55, 56, 163453, 57, 58, 164224, 59, 60, 164995, 61, 62, 63, 65600, 65664, 65728, 166544, 166805, 167079, 65792, 167822, 65856, 65920, 168372, 170130, 169107, 65984, 66048, 172182, 171415, 66112, 170394, 66176, 171163, 66240, 66304, 171934, 66368, 66432, 173217, 172962, 66496, 66560, 173733, 66624, 66688, 175016, 174761, 66752, 66816, 175532, 66880, 66944, 176815, 176560, 67008, 67072, 177587, 67136, 67200, 67264, 178128, 179128, 180921, 180154, 67328, 182716, 179901, 67392, 67456, 180672, 67520, 67584, 181955, 181700, 67648, 67712, 182471, 67776, 67840, 183754, 183499, 67904, 67968, 184270, 68032, 68096, 131281, 131282, 131283, 185344, 65536}, {134401, 133890, 135427, 136196, 132381, 132633, 138247, 133155, 133427, 133686, 0, 135180, 1, 134671, 2, 3, 4, 135699, 5, 6, 136470, 7, 136984, 8, 9, 138010, 10, 11, 12, 138795, 139551, 140576, 13, 139816, 14, 143396, 15, 140859, 141184, 16, 145449, 158250, 17, 142518, 147757, 146990, 160047, 18, 143685, 143945, 19, 153140, 152373, 20, 155703, 21, 145740, 146013, 22, 156476, 159293, 23, 147325, 147590, 24, 161602, 160835, 168516, 25, 149134, 149575, 26, 27, 150346, 28, 29, 151629, 151374, 30, 31, 152145, 32, 33, 152916, 34, 35, 154199, 153944, 36, 37, 154715, 38, 39, 155486, 40, 41, 156257, 42, 43, 157540, 157285, 44, 45, 158056, 46, 47, 166507, 159084, 48, 49, 159855, 50, 51, 162674, 170611, 52, 161172, 161431, 53, 167288, 172921, 172154, 54, 162973, 55, 164990, 174719, 56, 166017, 164738, 57, 58, 165293, 59, 176263, 60, 168329, 61, 167051, 62, 63, 65600, 168079, 65664, 65728, 65792, 168883, 65856, 169621, 65920, 65984, 170392, 66048, 66112, 171163, 66176, 66240, 171934, 66304, 66368, 172705, 66432, 66496, 173988, 173733, 66560, 66624, 174504, 66688, 66752, 175275, 66816, 66880, 176046, 66944, 67008, 176817, 67072, 67136, 177588, 67200, 67264, 178128, 179128, 180921, 180154, 67328, 182716, 179901, 67392, 67456, 180672, 67520, 67584, 181955, 181700, 67648, 67712, 182471, 67776, 67840, 183754, 183499, 67904, 67968, 184270, 68032, 68096, 131281, 131282, 131283, 65536}};
    static final int ABYTECOUNT = 128;
    static final byte[] zeroBytes_ = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] ffBytes_ = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    protected byte byteSource;
    protected int bitOffset;

    public void outputBitRun(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        int n3 = n >> 3;
        int n4 = n & 7;
        if (n4 != 0) {
            if (n2 < 8 - n4) {
                int n5 = n3;
                byArray[n5] = (byte)(byArray[n5] | trailMask[n2] >> n4);
                return;
            }
            n2 -= 8 - n4;
            int n6 = n3++;
            byArray[n6] = (byte)(byArray[n6] | leadMask[n4]);
        }
        while (n2 >= 8) {
            byArray[n3++] = -1;
            n2 -= 8;
        }
        if (n2 != 0) {
            int n7 = n3;
            byArray[n7] = (byte)(byArray[n7] | trailMask[n2]);
        }
    }

    public int decode1DWord(byte by) throws JimiException {
        int[] nArray = Dim1Dict[by];
        int n = 0;
        int n2 = nArray[0];
        do {
            this.byteSource = (this.bitOffset++ & 7) == 0 ? this.readByte() : (byte)(this.byteSource << 1);
            n = (this.byteSource & 0x80) != 0 ? (n2 & 0xFF00) >>> 8 : n2 & 0xFF;
            if (n != 0) continue;
            throw new JimiException("Code Not Found In Dict");
        } while (((n2 = nArray[n]) & 0x20000) != 0);
        return n2;
    }

    public int getRunLength(byte by) throws JimiException {
        int n;
        int n2 = 0;
        do {
            n = this.decode1DWord(by);
            n2 += n & 0xFFFF;
        } while ((n & 0x10000) != 0);
        return n2;
    }

    public void begOfStrip() {
        this.bitOffset = 0;
    }

    public void endOfLine() {
        if ((this.bitOffset & 7) != 0) {
            this.bitOffset = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void decodeLine(byte[] var1_1, int var2_2) throws JimiException {
        block4: {
            var3_3 = 0;
            var5_4 = 0;
            CCITT3d1Decomp.setArrayZero(var1_1);
            if (!this.invertOut_) ** GOTO lbl18
            while (var5_4 < var2_2) {
                var4_5 = this.getRunLength(var3_3);
                if (var3_3 == 0) {
                    this.outputBitRun(var1_1, var5_4, var4_5);
                }
                var5_4 += var4_5;
                var3_3 = (byte)(var3_3 ^ 1);
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                var4_6 = this.getRunLength(var3_3);
                if (var3_3 != 0) {
                    this.outputBitRun(var1_1, var5_4, var4_6);
                }
                var5_4 += var4_6;
                var3_3 = (byte)(var3_3 ^ 1);
lbl18:
                // 2 sources

                ** while (var5_4 < var2_2)
            }
        }
        this.endOfLine();
    }

    static final void setArrayZero(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n >= 128) {
            System.arraycopy(zeroBytes_, 0, byArray, n2, 128);
            n2 += 128;
            n -= 128;
        }
        if (n > 0) {
            System.arraycopy(zeroBytes_, 0, byArray, n2, n);
        }
    }

    static final void setArrayFF(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n >= 128) {
            System.arraycopy(ffBytes_, 0, byArray, n2, 128);
            n2 += 128;
            n -= 128;
        }
        if (n > 0) {
            System.arraycopy(ffBytes_, 0, byArray, n2, n);
        }
    }

    CCITT3d1Decomp(TiffNumberReader tiffNumberReader, int n) {
        super(tiffNumberReader, n);
    }
}

