/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.decoder.tiff.CCITT3d1Decomp;
import com.sun.jimi.core.decoder.tiff.CCITT3d2Decomp;
import com.sun.jimi.core.decoder.tiff.CCITTClassFDecomp;
import com.sun.jimi.core.decoder.tiff.Decompressor;
import com.sun.jimi.core.decoder.tiff.IFD;
import com.sun.jimi.core.decoder.tiff.LZWDecomp;
import com.sun.jimi.core.decoder.tiff.Packbits;
import com.sun.jimi.core.decoder.tiff.TIFDecoder;
import com.sun.jimi.core.decoder.tiff.TIFField;
import com.sun.jimi.core.decoder.tiff.TiffNumberReader;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.SeekInputStream;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;

class IFDDecode {
    AdaptiveRasterImage ji;
    IFD ifd;
    SeekInputStream sis;
    int newsubfiletype;
    int imagewidth;
    int imagelength;
    short[] bitspersample;
    int compression;
    int photometricinterpretation;
    int[] stripoffsets;
    int samplesperpixel;
    int rowsperstrip;
    int[] stripbytecounts;
    float xres;
    float yres;
    int resolutionunit;
    short[] colormap;
    int planarconfiguration;
    int extrasamples;
    float ycbcrcoefficients;
    int ycbcrpositioning;
    int[] ycbcrsubsampling;
    int referenceblackwhite;
    int badfaxlines;
    int cleanfaxdata;
    int consecutivebadfaxlines;
    int tilewidth;
    int tilelength;
    int[] tilebytecounts;
    int[] tileoffsets;
    int fillorder;
    int orientation;
    int t4options;
    int t6options;
    int predictor;
    LZWDecomp lzwDecomp_;
    int stripsperimage;
    int tilesacross;
    int tilesdown;
    int tilesperimage;
    TIFDecoder decoder;
    byte[] spc_o_;

    void decodeTags(IFD iFD) throws IOException {
        Enumeration enumeration = iFD.getFields();
        while (enumeration.hasMoreElements()) {
            TIFField tIFField = (TIFField)enumeration.nextElement();
            this.decodeField(tIFField);
        }
    }

    void decodeField(TIFField tIFField) throws IOException {
        switch (tIFField.id) {
            case 254: {
                this.newsubfiletype = tIFField.getInt(this.sis);
                break;
            }
            case 256: {
                this.imagewidth = tIFField.getInt(this.sis);
                break;
            }
            case 257: {
                this.imagelength = tIFField.getInt(this.sis);
                break;
            }
            case 258: {
                this.bitspersample = tIFField.getShortArray(this.sis);
                break;
            }
            case 259: {
                this.compression = tIFField.getInt(this.sis);
                break;
            }
            case 262: {
                this.photometricinterpretation = tIFField.getInt(this.sis);
                break;
            }
            case 273: {
                this.stripoffsets = tIFField.getIntArray(this.sis);
                break;
            }
            case 277: {
                this.samplesperpixel = tIFField.getInt(this.sis);
                break;
            }
            case 278: {
                this.rowsperstrip = tIFField.getInt(this.sis);
                break;
            }
            case 279: {
                this.stripbytecounts = tIFField.getIntArray(this.sis);
                break;
            }
            case 282: {
                this.xres = tIFField.getRational(this.sis);
                break;
            }
            case 283: {
                this.yres = tIFField.getRational(this.sis);
                break;
            }
            case 296: {
                this.resolutionunit = tIFField.getInt(this.sis);
                break;
            }
            case 320: {
                this.colormap = tIFField.getShortArray(this.sis);
                break;
            }
            case 284: {
                this.planarconfiguration = tIFField.getInt(this.sis);
                break;
            }
            case 338: {
                this.extrasamples = tIFField.getInt(this.sis);
                break;
            }
            case 529: {
                this.ycbcrcoefficients = tIFField.getRational(this.sis);
                break;
            }
            case 530: {
                this.ycbcrsubsampling = tIFField.getIntArray(this.sis);
                break;
            }
            case 531: {
                this.ycbcrpositioning = tIFField.getInt(this.sis);
                break;
            }
            case 326: {
                this.badfaxlines = tIFField.getInt(this.sis);
                break;
            }
            case 327: {
                this.cleanfaxdata = tIFField.getInt(this.sis);
                break;
            }
            case 328: {
                this.consecutivebadfaxlines = tIFField.getInt(this.sis);
                break;
            }
            case 322: {
                this.tilewidth = tIFField.getInt(this.sis);
                break;
            }
            case 323: {
                this.tilelength = tIFField.getInt(this.sis);
                break;
            }
            case 324: {
                this.tileoffsets = tIFField.getIntArray(this.sis);
                break;
            }
            case 325: {
                this.tilebytecounts = tIFField.getIntArray(this.sis);
                break;
            }
            case 266: {
                this.fillorder = tIFField.getInt(this.sis);
                break;
            }
            case 274: {
                this.orientation = tIFField.getInt(this.sis);
                break;
            }
            case 292: {
                this.t4options = tIFField.getInt(this.sis);
                break;
            }
            case 293: {
                this.t6options = tIFField.getInt(this.sis);
                break;
            }
            case 317: {
                this.predictor = tIFField.getInt(this.sis);
                break;
            }
        }
    }

    void initDefaults() {
        this.newsubfiletype = 0;
        this.bitspersample = new short[1];
        this.bitspersample[0] = 1;
        this.compression = 1;
        this.samplesperpixel = 1;
        this.rowsperstrip = -1;
        this.resolutionunit = 2;
        this.planarconfiguration = 1;
        this.tilewidth = 0;
        this.tilelength = 0;
        this.fillorder = 1;
        this.orientation = 1;
        this.t6options = 0;
        this.t4options = 0;
        this.predictor = 1;
    }

    ColorModel createPaleteColorModel() throws JimiException {
        int n = this.colormap.length / 3;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(this.colormap[n2] >> 8);
            byArray2[n2] = (byte)(this.colormap[n2 + n] >> 8);
            byArray3[n2] = (byte)(this.colormap[n2 + 2 * n] >> 8);
            ++n2;
        }
        return new IndexColorModel(8, n, byArray, byArray2, byArray3);
    }

    ColorModel createColorModel() throws JimiException {
        switch (this.photometricinterpretation) {
            case 0: {
                int n = (1 << this.bitspersample[0]) - 1;
                return new DirectColorModel(this.bitspersample[0], n, n, n);
            }
            case 1: {
                int n = (1 << this.bitspersample[0]) - 1;
                return new DirectColorModel(this.bitspersample[0], n, n, n);
            }
            case 3: {
                return this.createPaleteColorModel();
            }
            case 2: {
                if (this.samplesperpixel != 3 || this.bitspersample[0] != 8 || this.bitspersample[1] != 8 || this.bitspersample[2] != 8) {
                    throw new JimiException("RGB image not 3 x 8 bits");
                }
                return ColorModel.getRGBdefault();
            }
        }
        return null;
    }

    void decodeImage() throws JimiException, IOException {
        if (this.planarconfiguration == 2) {
            throw new JimiException("Seperate planar config not supported");
        }
        if (this.compression == 6 || this.compression == 7) {
            throw new JimiException("TIFF JPG format not supported");
        }
        if ((this.rowsperstrip & Integer.MIN_VALUE) != 0) {
            this.rowsperstrip = this.imagelength;
        }
        if (this.tilewidth == 0) {
            this.stripsperimage = (this.imagelength + this.rowsperstrip - 1) / this.rowsperstrip;
        } else {
            this.tilesacross = (this.imagewidth + this.tilewidth - 1) / this.tilewidth;
            this.tilesdown = (this.imagelength + this.tilelength - 1) / this.tilelength;
            this.tilesperimage = this.tilesacross * this.tilesdown;
            if (this.tileoffsets == null) {
                this.tileoffsets = this.stripoffsets;
                this.tilebytecounts = this.stripbytecounts;
            }
        }
        switch (this.photometricinterpretation) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                throw new JimiException("photometric MASK unsupported");
            }
            case 5: {
                throw new JimiException("photometric SEPERATED unsupported");
            }
            case 6: {
                throw new JimiException("photometric YCBCR unsupported");
            }
            case 8: {
                throw new JimiException("photometric CIELAB unsupported");
            }
            default: {
                throw new JimiException("Photometric Interpretation invalid " + this.photometricinterpretation);
            }
        }
        switch (this.orientation) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.ji.setSize(this.imagewidth, this.imagelength);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.ji.setSize(this.imagelength, this.imagewidth);
                this.ji.setHints(1);
                this.ji.setProperty("fixedaspect", Boolean.TRUE);
                break;
            }
        }
        this.ji.setProperty("xres", new Float(this.xres));
        this.ji.setProperty("yres", new Float(this.yres));
        ColorModel colorModel = this.createColorModel();
        this.ji.setColorModel(colorModel);
        this.ji.setPixels();
        if ((this.photometricinterpretation == 1 || this.photometricinterpretation == 0 || this.photometricinterpretation == 3) && this.samplesperpixel == 1) {
            if (this.tilewidth == 0) {
                this.decodeStrips();
            } else {
                this.decodeTiles();
            }
        } else if (this.compression == 1 || this.compression == 32773 || this.compression == 5) {
            if (this.tilewidth == 0) {
                this.decodeStrips();
            } else {
                this.decodeTiles();
            }
        } else {
            throw new JimiException("Unsupported compression " + this.compression);
        }
    }

    void decodeJPG() throws JimiException, IOException {
        short s = this.bitspersample[0];
        int n = 0;
        int n2 = this.stripsperimage;
        while (--n2 >= 0) {
            n += this.stripbytecounts[0];
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        n2 = 0;
        while (n2 < this.stripsperimage) {
            byte[] byArray2 = new byte[this.stripbytecounts[n2]];
            this.sis.seek(this.stripoffsets[n2]);
            this.sis.readFully(byArray2, 0, this.stripbytecounts[n2]);
            System.arraycopy(byArray2, 0, byArray, n3, this.stripbytecounts[n2]);
            n3 += this.stripbytecounts[n2];
            ++n2;
        }
    }

    int numRows(int n) {
        if (n == this.stripsperimage - 1) {
            int n2 = this.imagelength % this.rowsperstrip;
            return n2 != 0 ? n2 : this.rowsperstrip;
        }
        return this.rowsperstrip;
    }

    public int rowSize() {
        int n = this.bitspersample[0] * this.imagewidth;
        if (this.planarconfiguration == 1) {
            n *= this.samplesperpixel;
        }
        return (n + 7) / 8;
    }

    Decompressor createDecompressor(byte[] byArray) throws JimiException {
        Decompressor decompressor = null;
        TiffNumberReader tiffNumberReader = new TiffNumberReader(byArray);
        switch (this.compression) {
            case 1: {
                decompressor = new Decompressor(tiffNumberReader, this.fillorder, this.bitspersample[0]);
                break;
            }
            case 2: {
                decompressor = new CCITT3d1Decomp(tiffNumberReader, this.fillorder);
                break;
            }
            case 3: {
                decompressor = new CCITTClassFDecomp(tiffNumberReader, this.fillorder, (this.t4options & 4) != 0);
                break;
            }
            case 4: {
                decompressor = new CCITT3d2Decomp(tiffNumberReader, this.fillorder);
                break;
            }
            case 32773: {
                decompressor = new Packbits(tiffNumberReader, this.fillorder, this.bitspersample[0]);
                break;
            }
            case 5: {
                if (this.predictor == 2 && this.bitspersample[0] != 8) {
                    throw new JimiException("horizontal difference only supported for 8 bits currently");
                }
                if (this.lzwDecomp_ == null) {
                    this.lzwDecomp_ = new LZWDecomp(new ByteArrayInputStream(byArray, 0, byArray.length - 2), this.fillorder, this.bitspersample[0], this.predictor);
                } else {
                    this.lzwDecomp_.setInputStream(new ByteArrayInputStream(byArray, 0, byArray.length - 2));
                }
                decompressor = this.lzwDecomp_;
                break;
            }
        }
        return decompressor;
    }

    void decodeStrips() throws JimiException, IOException {
        int[] nArray = null;
        byte[] byArray = null;
        boolean bl = true;
        short s = this.bitspersample[0];
        int n = 0;
        if (this.samplesperpixel != 1) {
            nArray = new int[this.imagewidth];
            byArray = new byte[this.imagewidth * this.samplesperpixel];
        } else {
            byArray = s == 1 ? new byte[(this.imagewidth + 7) / 8] : new byte[this.imagewidth];
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.stripsperimage) {
            if (this.stripbytecounts[n3] > n2) {
                n2 = this.stripbytecounts[n3];
            }
            ++n3;
        }
        byte[] byArray2 = new byte[n2 + 2];
        n3 = 0;
        while (n3 < this.stripsperimage) {
            int n4;
            int n5;
            this.sis.seek(this.stripoffsets[n3]);
            this.sis.readFully(byArray2, 0, this.stripbytecounts[n3]);
            Decompressor decompressor = this.createDecompressor(byArray2);
            decompressor.setRowsPerStrip(this.rowsperstrip);
            if (this.photometricinterpretation == 0 && this.samplesperpixel == 1) {
                decompressor.setInvert(true);
            }
            decompressor.begOfStrip();
            if (bl) {
                decompressor.begOfPage();
            }
            bl = false;
            if (this.samplesperpixel == 1) {
                if (s == 1) {
                    n5 = this.numRows(n3);
                    while (--n5 >= 0) {
                        decompressor.decodeLine(byArray, this.imagewidth);
                        this.setPackedChannel_Oriented(n, byArray);
                        this.decoder.setProgress(++n * 100 / this.imagelength);
                    }
                } else {
                    n5 = this.numRows(n3);
                    while (--n5 >= 0) {
                        decompressor.decodeLine(byArray, byArray.length);
                        if (this.compression == 5 && this.predictor == 2) {
                            n4 = 0;
                            while (n4 < byArray.length - 1) {
                                int n6 = n4 + 1;
                                byArray[n6] = (byte)(byArray[n6] + byArray[n4]);
                                ++n4;
                            }
                        }
                        this.setChannel_Oriented(0, n, byArray);
                        this.decoder.setProgress(++n * 100 / this.imagelength);
                    }
                }
            } else {
                n5 = this.numRows(n3);
                while (--n5 >= 0) {
                    decompressor.decodeLine(byArray, byArray.length);
                    if (this.compression == 5 && this.predictor == 2) {
                        n4 = 0;
                        while (n4 < (byArray.length - 1) / 3) {
                            int n7 = (n4 + 1) * 3;
                            byArray[n7] = (byte)(byArray[n7] + byArray[n4 * 3]);
                            int n8 = (n4 + 1) * 3 + 1;
                            byArray[n8] = (byte)(byArray[n8] + byArray[n4 * 3 + 1]);
                            int n9 = (n4 + 1) * 3 + 2;
                            byArray[n9] = (byte)(byArray[n9] + byArray[n4 * 3 + 2]);
                            ++n4;
                        }
                    }
                    n4 = 0;
                    while (n4 < this.imagewidth) {
                        nArray[n4] = 0xFF000000 | (byArray[n4 * 3] & 0xFF) << 16 | (byArray[n4 * 3 + 1] & 0xFF) << 8 | byArray[n4 * 3 + 2] & 0xFF;
                        ++n4;
                    }
                    this.setChannel_Oriented(n, nArray);
                    this.decoder.setProgress(++n * 100 / this.imagelength);
                }
            }
            ++n3;
        }
    }

    void decodeTiles() throws JimiException, IOException {
        short s = this.bitspersample[0];
        byte[] byArray = null;
        int[] nArray = null;
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        if (this.samplesperpixel != 1) {
            nArray = new int[this.tilewidth];
            byArray = new byte[this.tilewidth * this.samplesperpixel];
        } else {
            byArray = s == 1 ? new byte[(this.tilewidth + 7) / 8] : new byte[this.tilewidth];
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.tilesperimage) {
            if (this.tilebytecounts[n4] > n3) {
                n3 = this.tilebytecounts[n4];
            }
            ++n4;
        }
        byte[] byArray2 = new byte[n3 + 2];
        n4 = 0;
        while (n4 < this.tilesperimage) {
            this.sis.seek(this.tileoffsets[n4]);
            this.sis.readFully(byArray2, 0, this.tilebytecounts[n4]);
            Decompressor decompressor = this.createDecompressor(byArray2);
            if (this.photometricinterpretation == 0) {
                decompressor.setInvert(true);
            }
            decompressor.begOfStrip();
            if (bl) {
                decompressor.begOfPage();
            }
            bl = false;
            int n5 = n2;
            int n6 = this.tilelength;
            while (--n6 >= 0) {
                decompressor.decodeLine(byArray, byArray.length);
                int n7 = n + this.tilewidth > this.imagewidth ? this.imagewidth - n : this.tilewidth;
                if (n5 < this.imagelength) {
                    int n8;
                    if (this.samplesperpixel == 1) {
                        if (s == 1) {
                            this.setPackedChannel_Oriented(n, n5, n7, byArray);
                        } else {
                            if (this.compression == 5 && this.predictor == 2) {
                                n8 = 0;
                                while (n8 < byArray.length - 1) {
                                    int n9 = n8 + 1;
                                    byArray[n9] = (byte)(byArray[n9] + byArray[n8]);
                                    ++n8;
                                }
                            }
                            this.setChannel_Oriented(n, n5, n7, byArray);
                        }
                    } else {
                        if (this.compression == 5 && this.predictor == 2) {
                            n8 = 0;
                            while (n8 < (byArray.length - 1) / 3) {
                                int n10 = (n8 + 1) * 3;
                                byArray[n10] = (byte)(byArray[n10] + byArray[n8 * 3]);
                                int n11 = (n8 + 1) * 3 + 1;
                                byArray[n11] = (byte)(byArray[n11] + byArray[n8 * 3 + 1]);
                                int n12 = (n8 + 1) * 3 + 2;
                                byArray[n12] = (byte)(byArray[n12] + byArray[n8 * 3 + 2]);
                                ++n8;
                            }
                        }
                        n8 = 0;
                        while (n8 < this.imagewidth) {
                            nArray[n8] = 0xFF000000 | (byArray[n8 * 3] & 0xFF) << 16 | (byArray[n8 * 3 + 1] & 0xFF) << 8 | byArray[n8 * 3 + 2] & 0xFF;
                            ++n8;
                        }
                        this.setChannel_Oriented(n, n5, n7, nArray);
                    }
                    ++n5;
                    continue;
                }
                n6 = 0;
            }
            if ((n += this.tilewidth) > (this.tilesacross - 1) * this.tilewidth) {
                n = 0;
                n2 += this.tilelength;
            }
            ++n4;
        }
    }

    void setPackedChannel_Oriented(int n, int n2, int n3, byte[] byArray) throws JimiException {
        if (this.spc_o_ == null) {
            this.spc_o_ = new byte[byArray.length * 8];
        }
        JimiUtil.expandOneBitPixels(byArray, this.spc_o_, this.imagewidth);
        this.setChannel_Oriented(n, n2, n3, this.spc_o_);
    }

    void setPackedChannel_Oriented(int n, byte[] byArray) throws JimiException {
        if (this.orientation == 1) {
            this.ji.setPackedChannel(n, byArray);
        } else {
            if (this.spc_o_ == null) {
                this.spc_o_ = new byte[byArray.length * 8];
            }
            JimiUtil.expandOneBitPixels(byArray, this.spc_o_, this.imagewidth);
            this.setChannel_Oriented(0, n, this.spc_o_);
        }
    }

    void setChannel_Oriented(int n, int n2, int n3, byte[] byArray) throws JimiException {
        switch (this.orientation) {
            case 1: {
                this.ji.setChannel(0, n, n2, n3, 1, byArray, 0, 0);
                break;
            }
            case 2: {
                int n4 = this.ji.getWidth();
                int n5 = 0;
                byte[] byArray2 = new byte[n3];
                int n6 = n3;
                while (--n6 >= 0) {
                    byArray2[n6] = byArray[n5++];
                }
                n = n4 - n - n3;
                this.ji.setChannel(0, n, n2, n3, 1, byArray2, 0, 0);
                break;
            }
            case 3: {
                int n7 = this.ji.getHeight();
                n2 = n7 - n2 - 1;
                int n8 = this.ji.getWidth();
                byte[] byArray3 = new byte[n3];
                int n9 = n3;
                int n10 = 0;
                while (n10 < n3) {
                    byArray3[n10] = byArray[--n9];
                    ++n10;
                }
                n = n8 - n - n3;
                this.ji.setChannel(0, n, n2, n3, 1, byArray3, 0, 0);
                break;
            }
            case 4: {
                int n11 = this.ji.getHeight();
                n2 = n11 - n2 - 1;
                this.ji.setChannel(0, n, n2, n3, 1, byArray, 0, 0);
                break;
            }
            case 5: {
                int n12 = this.ji.getWidth();
                n2 = n12 - n2 - 1;
                this.setChannel_RotateCW90(n, n2, n3, byArray);
                break;
            }
            case 6: {
                this.setChannel_RotateCW90(n, n2, n3, byArray);
                break;
            }
            case 7: {
                int n13 = this.ji.getHeight();
                int n14 = 0;
                byte[] byArray4 = new byte[n3];
                int n15 = n3;
                while (--n15 >= 0) {
                    byArray4[n15] = byArray[n14++];
                }
                n = n13 - n - n3;
                this.setChannel_RotateCW90(n, n2, n3, byArray4);
                break;
            }
            case 8: {
                int n16 = this.ji.getWidth();
                n2 = n16 - n2 - 1;
                int n17 = this.ji.getHeight();
                byte[] byArray5 = new byte[n3];
                int n18 = n3;
                int n19 = 0;
                while (n19 < n3) {
                    byArray5[n19] = byArray[--n18];
                    ++n19;
                }
                n = n17 - n - n3;
                this.setChannel_RotateCW90(n, n2, n3, byArray5);
                break;
            }
        }
    }

    final void setChannel_RotateCW90(int n, int n2, int n3, byte[] byArray) throws JimiException {
        this.ji.setChannel(0, this.ji.getWidth() - n2 - 1, n, 1, n3, byArray, 0, 1);
    }

    void setChannel_Oriented(int n, int n2, byte[] byArray) throws JimiException {
        switch (this.orientation) {
            case 1: {
                this.ji.setChannel(n, n2, byArray);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.setChannel_Oriented(0, n2, this.ji.getWidth(), byArray);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.setChannel_Oriented(0, n2, this.ji.getHeight(), byArray);
                break;
            }
        }
    }

    void setChannel_Oriented(int n, int n2, int n3, int[] nArray) throws JimiException {
        switch (this.orientation) {
            case 1: {
                this.ji.setChannel(n, n2, n3, 1, nArray, 0, 0);
                break;
            }
            case 2: {
                int n4 = this.ji.getWidth();
                int n5 = 0;
                int[] nArray2 = new int[n3];
                int n6 = n3;
                while (--n6 >= 0) {
                    nArray2[n6] = nArray[n5++];
                }
                n = n4 - n - n3;
                this.ji.setChannel(n, n2, n3, 1, nArray2, 0, 0);
                break;
            }
            case 3: {
                int n7 = this.ji.getHeight();
                n2 = n7 - n2 - 1;
                int n8 = this.ji.getWidth();
                int[] nArray3 = new int[n3];
                int n9 = n3;
                int n10 = 0;
                while (n10 < n3) {
                    nArray3[n10] = nArray[--n9];
                    ++n10;
                }
                n = n8 - n - n3;
                this.ji.setChannel(n, n2, n3, 1, nArray3, 0, 0);
                break;
            }
            case 4: {
                int n11 = this.ji.getHeight();
                n2 = n11 - n2 - 1;
                this.ji.setChannel(n, n2, n3, 1, nArray, 0, 0);
                break;
            }
            case 5: {
                int n12 = this.ji.getWidth();
                n2 = n12 - n2 - 1;
                this.setChannel_RotateCW90(n, n2, n3, nArray);
                break;
            }
            case 6: {
                this.setChannel_RotateCW90(n, n2, n3, nArray);
                break;
            }
            case 7: {
                int n13 = this.ji.getHeight();
                int n14 = 0;
                int[] nArray4 = new int[n3];
                int n15 = n3;
                while (--n15 >= 0) {
                    nArray4[n15] = nArray[n14++];
                }
                n = n13 - n - n3;
                this.setChannel_RotateCW90(n, n2, n3, nArray4);
                break;
            }
            case 8: {
                int n16 = this.ji.getWidth();
                n2 = n16 - n2 - 1;
                int n17 = this.ji.getHeight();
                int[] nArray5 = new int[n3];
                int n18 = n3;
                int n19 = 0;
                while (n19 < n3) {
                    nArray5[n19] = nArray[--n18];
                    ++n19;
                }
                n = n17 - n - n3;
                this.setChannel_RotateCW90(n, n2, n3, nArray5);
                break;
            }
        }
    }

    final void setChannel_RotateCW90(int n, int n2, int n3, int[] nArray) throws JimiException {
        this.ji.setChannel(this.ji.getWidth() - n2 - 1, n, 1, n3, nArray, 0, 1);
    }

    void setChannel_Oriented(int n, int[] nArray) throws JimiException {
        switch (this.orientation) {
            case 1: {
                this.ji.setChannel(n, nArray);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.setChannel_Oriented(0, n, this.ji.getWidth(), nArray);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.setChannel_Oriented(0, n, this.ji.getHeight(), nArray);
                break;
            }
        }
    }

    IFDDecode(TIFDecoder tIFDecoder, AdaptiveRasterImage adaptiveRasterImage, SeekInputStream seekInputStream) throws IOException {
        this.initDefaults();
        this.ji = adaptiveRasterImage;
        this.sis = seekInputStream;
        this.decoder = tIFDecoder;
    }
}

