/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.util.SeekInputStream;
import java.io.IOException;

class TIFField {
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINE = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int FLOAT = 11;
    public static final int DOUBLE = 12;
    public static final int[] dataWidths = new int[]{1, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    public static final String[] typeNames = new String[]{"no value", "BYTE", "ASCII", "SHORT", "LONG", "RATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "FLOAT", "DOUBLE"};
    short id;
    short type;
    int count;
    int offset;

    public final void read(SeekInputStream seekInputStream) throws IOException {
        this.id = seekInputStream.readShort();
        this.type = seekInputStream.readShort();
        this.count = seekInputStream.readInt();
        if (this.count * dataWidths[this.type] > 4) {
            this.offset = seekInputStream.readInt();
        } else {
            switch (this.type) {
                case 1: 
                case 2: 
                case 6: 
                case 7: {
                    this.offset = seekInputStream.readUnsignedByte() << 24;
                    this.offset += seekInputStream.readUnsignedByte() << 16;
                    this.offset += seekInputStream.readUnsignedByte() << 8;
                    this.offset += seekInputStream.readUnsignedByte();
                    break;
                }
                case 3: 
                case 8: {
                    this.offset = seekInputStream.readUnsignedShort() << 16;
                    this.offset += seekInputStream.readUnsignedShort();
                    break;
                }
                default: {
                    this.offset = seekInputStream.readInt();
                    break;
                }
            }
        }
    }

    public final boolean equals(int n) {
        return this.id == n;
    }

    public int getInt(SeekInputStream seekInputStream) throws IOException {
        int n = 0;
        boolean bl = false;
        if (this.count == 1) {
            switch (this.type) {
                case 1: {
                    n = this.offset >> 24 & 0xFF;
                    break;
                }
                case 6: {
                    n = (byte)(this.offset >> 24 & 0xFF);
                    break;
                }
                case 3: {
                    n = this.offset >> 16 & 0xFFFF;
                    break;
                }
                case 8: {
                    n = (short)(this.offset >> 16 & 0xFFFF);
                    break;
                }
                case 4: {
                    n = this.offset;
                    break;
                }
                case 9: {
                    n = this.offset;
                    break;
                }
                default: {
                    bl = true;
                    break;
                }
            }
        } else {
            bl = true;
        }
        if (bl) {
            throw new RuntimeException("wrong method " + this.toString());
        }
        return n;
    }

    public float getRational(SeekInputStream seekInputStream) throws IOException {
        long l;
        long l2;
        seekInputStream.seek(this.offset);
        if (this.type == 5) {
            l2 = seekInputStream.readInt();
            if (l2 < 0L) {
                l2 &= 0xFFFFFFFFL;
            }
            if ((l = (long)seekInputStream.readInt()) < 0L) {
                l &= 0xFFFFFFFFL;
            }
        } else {
            l2 = seekInputStream.readInt();
            l = seekInputStream.readInt();
        }
        return l2 / l;
    }

    public float[] getRationalArray(SeekInputStream seekInputStream) throws IOException {
        float[] fArray = new float[this.count];
        seekInputStream.seek(this.offset);
        int n = 0;
        while (n < this.count) {
            long l;
            long l2;
            if (this.type == 5) {
                l2 = seekInputStream.readInt();
                if (l2 < 0L) {
                    l2 &= 0xFFFFFFFFL;
                }
                if ((l = (long)seekInputStream.readInt()) < 0L) {
                    l &= 0xFFFFFFFFL;
                }
            } else {
                l2 = seekInputStream.readInt();
                l = seekInputStream.readInt();
            }
            fArray[n] = l2 / l;
            ++n;
        }
        return fArray;
    }

    public int[] getIntArray(SeekInputStream seekInputStream) throws IOException {
        int[] nArray = new int[this.count];
        if (this.type == 1 || this.type == 6 || this.type == 3 || this.type == 8) {
            short[] sArray = this.getShortArray(seekInputStream);
            int n = 0;
            while (n < this.count) {
                nArray[n] = sArray[n];
                ++n;
            }
        } else if (this.type == 4 || this.type == 9) {
            if (this.count == 1) {
                nArray[0] = this.offset;
            } else {
                seekInputStream.seek(this.offset);
                int n = 0;
                while (n < this.count) {
                    nArray[n] = seekInputStream.readInt();
                    ++n;
                }
            }
        } else {
            throw new RuntimeException("wrong method " + this.toString());
        }
        return nArray;
    }

    public short[] getShortArray(SeekInputStream seekInputStream) throws IOException {
        short[] sArray = new short[this.count];
        if (this.type == 1 || this.type == 6) {
            byte[] byArray = this.getByteArray(seekInputStream);
            int n = 0;
            while (n < this.count) {
                sArray[n] = byArray[n];
                ++n;
            }
        } else if (this.type == 3 || this.type == 8) {
            if (this.count <= 2) {
                if (this.count >= 1) {
                    sArray[0] = (short)(this.offset >> 16 & 0xFFFF);
                }
                if (this.count >= 2) {
                    sArray[1] = (short)(this.offset & 0xFFFF);
                }
            } else {
                seekInputStream.seek(this.offset);
                int n = 0;
                while (n < this.count) {
                    sArray[n] = seekInputStream.readShort();
                    ++n;
                }
            }
        } else {
            throw new RuntimeException("wrong method " + this.toString());
        }
        return sArray;
    }

    public byte[] getByteArray(SeekInputStream seekInputStream) throws IOException {
        byte[] byArray = new byte[this.count];
        if (this.type == 1 || this.type == 6) {
            if (this.count <= 4) {
                if (this.count >= 1) {
                    byArray[0] = (byte)(this.offset >> 24 & 0xFF);
                }
                if (this.count >= 2) {
                    byArray[1] = (byte)(this.offset >> 16 & 0xFF);
                }
                if (this.count >= 3) {
                    byArray[2] = (byte)(this.offset >> 8 & 0xFF);
                }
                if (this.count == 4) {
                    byArray[3] = (byte)(this.offset & 0xFF);
                }
            } else {
                seekInputStream.seek(this.offset);
                int n = 0;
                while (n < this.count) {
                    byArray[n] = seekInputStream.readByte();
                    ++n;
                }
            }
        } else {
            throw new RuntimeException("wrong method " + this.toString());
        }
        return byArray;
    }

    String getString(SeekInputStream seekInputStream) throws IOException {
        byte[] byArray = this.getByteArray(seekInputStream);
        return new String(byArray, 0, 0, byArray.length - 1);
    }

    public String toString() {
        return " id " + this.id + " count " + this.count + " type (" + typeNames[this.type] + ") " + this.type + " offset " + this.offset;
    }

    TIFField() {
    }
}

