/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.bmp;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.bmp.BMPEncoder;
import com.sun.jimi.core.encoder.bmp.BMPEncoderIfc;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.IndexColorModel;
import java.io.IOException;

public class BMP8Encoder
implements BMPEncoderIfc {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encodeBMP(BMPEncoder bMPEncoder, AdaptiveRasterImage adaptiveRasterImage, LEDataOutputStream lEDataOutputStream) throws JimiException {
        try {
            IndexColorModel indexColorModel;
            int n = 19778;
            int n2 = (adaptiveRasterImage.getWidth() * 8 + 31) / 32 * 4;
            int n3 = 1078;
            int n4 = n2 * adaptiveRasterImage.getHeight() + n3;
            lEDataOutputStream.writeShort(n);
            lEDataOutputStream.writeInt(n4);
            lEDataOutputStream.writeShort(0);
            lEDataOutputStream.writeShort(0);
            lEDataOutputStream.writeInt(n3);
            lEDataOutputStream.writeInt(40);
            lEDataOutputStream.writeInt(adaptiveRasterImage.getWidth());
            lEDataOutputStream.writeInt(adaptiveRasterImage.getHeight());
            lEDataOutputStream.writeShort(1);
            lEDataOutputStream.writeShort(8);
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(n2 * adaptiveRasterImage.getHeight());
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(0);
            try {
                indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
            }
            catch (ClassCastException classCastException) {
                throw new JimiException("BMP8 encoding requires an IndexColorModel.");
            }
            int n5 = Math.max(256, indexColorModel.getMapSize());
            byte[] byArray = new byte[n5];
            byte[] byArray2 = new byte[n5];
            byte[] byArray3 = new byte[n5];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            int n6 = 0;
            while (n6 < 256) {
                if (n6 < n5) {
                    lEDataOutputStream.writeByte(byArray3[n6]);
                    lEDataOutputStream.writeByte(byArray2[n6]);
                    lEDataOutputStream.writeByte(byArray[n6]);
                    lEDataOutputStream.writeByte(0);
                } else {
                    lEDataOutputStream.writeInt(0);
                }
                ++n6;
            }
            n6 = adaptiveRasterImage.getWidth();
            int n7 = adaptiveRasterImage.getHeight() - 1;
            byte[] byArray4 = new byte[n6];
            int n8 = n2 - n6;
            int n9 = n7;
            while (n9 > -1) {
                adaptiveRasterImage.getChannel(0, n9, byArray4, 0);
                lEDataOutputStream.write(byArray4);
                int n10 = 0;
                while (n10 < n8) {
                    lEDataOutputStream.write(0);
                    ++n10;
                }
                bMPEncoder.setProgress((n7 - n9) * 100 / n7);
                --n9;
            }
            return;
        }
        catch (IOException iOException) {
            throw new JimiException("BMP8Encoder encodeBMP() IOException encountered");
        }
    }
}

