/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.bmp;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.bmp.BMP24Encoder;
import com.sun.jimi.core.encoder.bmp.BMP8Encoder;
import com.sun.jimi.core.encoder.bmp.BMPEncoderIfc;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class BMPEncoder
extends JimiEncoderBase
implements BMPEncoderIfc {
    private OutputStream out;
    private LEDataOutputStream LEbOut;
    private int state;

    public void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.out = outputStream;
        this.LEbOut = new LEDataOutputStream(outputStream);
        this.state = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        this.encodeBMP(this, adaptiveRasterImage, this.LEbOut);
        this.state |= 2;
        try {
            this.LEbOut.flush();
            this.LEbOut.close();
            return false;
        }
        catch (IOException iOException) {
            throw new JimiException("BMPEncoder driveEncoder() IO Exception encountered");
        }
    }

    public void freeEncoder() throws JimiException {
        this.out = null;
        this.LEbOut = null;
        super.freeEncoder();
    }

    public int getState() {
        return this.state;
    }

    public void encodeBMP(BMPEncoder bMPEncoder, AdaptiveRasterImage adaptiveRasterImage, LEDataOutputStream lEDataOutputStream) throws JimiException {
        this.createEncoderForImage(adaptiveRasterImage).encodeBMP(this, adaptiveRasterImage, lEDataOutputStream);
    }

    protected BMPEncoderIfc createEncoderForImage(AdaptiveRasterImage adaptiveRasterImage) {
        ColorModel colorModel = adaptiveRasterImage.getColorModel();
        if (colorModel instanceof IndexColorModel && colorModel.getPixelSize() == 8) {
            return new BMP8Encoder();
        }
        return new BMP24Encoder();
    }
}

