/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.cur;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.ico.ICOEncoder;
import com.sun.jimi.core.util.LEDataOutputStream;
import com.sun.jimi.util.ArrayEnumeration;
import com.sun.jimi.util.IntegerRange;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Enumeration;

public class CUREncoder
extends ICOEncoder {
    static final String OPTION_XHOTSPOT = "hotspot location X";
    static final String OPTION_YHOTSPOT = "hotpost location Y";
    static final String[] OPTION_NAMES = new String[]{"hotspot location X", "hotpost location Y"};
    static final IntegerRange POSSIBLE_XHOTSPOT_VALUES;
    static final IntegerRange POSSIBLE_YHOTSPOT_VALUES;
    private short xHotspot = 0;
    private short yHotspot = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeICOCURDIREntry(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException, IOException {
        IndexColorModel indexColorModel;
        try {
            indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
        }
        catch (ClassCastException classCastException) {
            throw new JimiException("image/x-cur formats can only be created from palette images");
        }
        int n = indexColorModel.getMapSize();
        if (n > 256) {
            throw new JimiException("image/x-cur formats can only support palette with up to 256 colors");
        }
        int n2 = this.computeBitCount(n);
        int n3 = adaptiveRasterImage.getWidth();
        int n4 = adaptiveRasterImage.getHeight();
        if (n3 <= 256 && n4 <= 256) {
            int n5 = this.computeImageSize(n, n2, n3, n4);
            lEDataOutputStream.writeByte((byte)n3);
            lEDataOutputStream.writeByte((byte)n4);
            lEDataOutputStream.writeByte((byte)n);
            lEDataOutputStream.writeByte(0);
            lEDataOutputStream.writeShort(this.xHotspot);
            lEDataOutputStream.writeShort(this.yHotspot);
            int n6 = 40 + n5 * n2 / 8 + (int)Math.pow(2.0, n2);
            lEDataOutputStream.writeInt(n6);
            lEDataOutputStream.writeInt(this.currentOffset);
            this.currentOffset += n5;
            return;
        }
        throw new JimiException("image/x-cur formats can only encode images up to 256 x 256 pixels");
    }

    public void setHotspot(short s, short s2) {
        this.xHotspot = s;
        this.yHotspot = s2;
    }

    public Enumeration getPropertyNames() {
        return new ArrayEnumeration(OPTION_NAMES);
    }

    public Object getPossibleValuesForProperty(String string) {
        if (string.equalsIgnoreCase(OPTION_XHOTSPOT)) {
            return POSSIBLE_XHOTSPOT_VALUES;
        }
        if (string.equalsIgnoreCase(OPTION_YHOTSPOT)) {
            return POSSIBLE_YHOTSPOT_VALUES;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setProperty(String string, Object object) throws InvalidOptionException {
        short s = 0;
        try {
            s = (short)((Integer)object).intValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidOptionException("Must specify a java.lang.Integer value");
        }
        if (string.equalsIgnoreCase(OPTION_XHOTSPOT)) {
            if (!POSSIBLE_XHOTSPOT_VALUES.isInRange(object)) {
                throw new InvalidOptionException("Value is out of range");
            }
            this.setHotspot(s, this.yHotspot);
            return;
        }
        if (!string.equalsIgnoreCase(OPTION_YHOTSPOT)) throw new InvalidOptionException("No such Option");
        if (!POSSIBLE_YHOTSPOT_VALUES.isInRange(object)) {
            throw new InvalidOptionException("Value is out of range");
        }
        this.setHotspot(this.xHotspot, s);
    }

    public void clearProperties() {
        this.setHotspot((short)0, (short)0);
    }

    public String getPropertyDescription(String string) throws InvalidOptionException {
        if (string.equalsIgnoreCase(OPTION_XHOTSPOT)) {
            return "The location of the cursor's pointer along the X-axis";
        }
        if (string.equalsIgnoreCase(OPTION_YHOTSPOT)) {
            return "The location of the cursor's pointer along the Y-axis";
        }
        throw new InvalidOptionException("No such option");
    }

    public CUREncoder() {
        this.TYPE_FLAG = (short)2;
    }

    static {
        POSSIBLE_YHOTSPOT_VALUES = POSSIBLE_XHOTSPOT_VALUES = new IntegerRange(0, 65536);
    }
}

