/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.ico;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class ICOEncoder
extends JimiEncoderBase {
    protected static final int BMPINFOHEADER_SIZE = 40;
    private boolean isEncodingFirstImage = true;
    protected LEDataOutputStream destination;
    protected short TYPE_FLAG = 1;
    protected int stateFlag = 4;
    protected int currentOffset = 0;

    public void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.destination = new LEDataOutputStream(outputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        try {
            AdaptiveRasterImage[] adaptiveRasterImageArray = new AdaptiveRasterImage[]{adaptiveRasterImage};
            this.writeICOCURDirectory(this.destination, adaptiveRasterImageArray);
            this.writeDIBImage(this.destination, adaptiveRasterImage);
        }
        catch (IOException iOException) {
            this.stateFlag = 1;
            throw new JimiException(iOException.toString());
        }
        catch (JimiException jimiException) {
            this.stateFlag = 1;
            throw jimiException;
        }
        this.stateFlag = 2;
        return false;
    }

    public int getState() {
        return this.stateFlag;
    }

    public void freeEncoder() throws JimiException {
    }

    protected void writeICOCURDirectory(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage[] adaptiveRasterImageArray) throws JimiException, IOException {
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(1);
        lEDataOutputStream.writeShort((short)adaptiveRasterImageArray.length);
        this.currentOffset = 6;
        this.currentOffset += adaptiveRasterImageArray.length * 16;
        int n = 0;
        while (n < adaptiveRasterImageArray.length) {
            this.writeICOCURDIREntry(lEDataOutputStream, adaptiveRasterImageArray[n]);
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeICOCURDIREntry(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException, IOException {
        IndexColorModel indexColorModel;
        try {
            indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
        }
        catch (ClassCastException classCastException) {
            throw new JimiException("image/x-ico formats can only be created from palette images");
        }
        int n = indexColorModel.getMapSize();
        if (n > 256) {
            throw new JimiException("image/x-ico formats can only support palette with up to 256 colors");
        }
        int n2 = this.computeBitCount(n);
        int n3 = adaptiveRasterImage.getWidth();
        int n4 = adaptiveRasterImage.getHeight();
        if (n3 <= 256 && n4 <= 256) {
            int n5 = this.computeImageSize(n, n2, n3, n4);
            lEDataOutputStream.writeByte((byte)n3);
            lEDataOutputStream.writeByte((byte)n4);
            lEDataOutputStream.writeByte((byte)n);
            lEDataOutputStream.writeByte(0);
            lEDataOutputStream.writeShort(0);
            lEDataOutputStream.writeShort((short)n2);
            int n6 = 40 + n5 * n2 / 8 + (int)Math.pow(2.0, n2);
            lEDataOutputStream.writeInt(n6);
            lEDataOutputStream.writeInt(this.currentOffset);
            this.currentOffset += n5;
            return;
        }
        throw new JimiException("image/x-ico formats can only encode images up to 256 x 256 pixels");
    }

    protected void writeDIBImage(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException, IOException {
        IndexColorModel indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
        int n = indexColorModel.getMapSize();
        int n2 = this.computeBitCount(n);
        this.writeBitmapInfoHeader(lEDataOutputStream, n2, n, adaptiveRasterImage, indexColorModel);
        this.writeRGBQuads(lEDataOutputStream, indexColorModel);
        this.writePixels(lEDataOutputStream, n2, adaptiveRasterImage);
    }

    protected void writeBitmapInfoHeader(LEDataOutputStream lEDataOutputStream, int n, int n2, AdaptiveRasterImage adaptiveRasterImage, IndexColorModel indexColorModel) throws JimiException, IOException {
        int n3 = adaptiveRasterImage.getWidth();
        int n4 = adaptiveRasterImage.getHeight() * 2;
        int n5 = this.computeImageSize(n2, n, n3, n4);
        lEDataOutputStream.writeInt(40);
        lEDataOutputStream.writeInt(n3);
        lEDataOutputStream.writeInt(n4);
        lEDataOutputStream.writeShort(1);
        lEDataOutputStream.writeShort((short)n);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt(n5);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt(0);
    }

    protected void writeRGBQuads(LEDataOutputStream lEDataOutputStream, IndexColorModel indexColorModel) throws JimiException, IOException {
        int n = indexColorModel.getMapSize();
        int n2 = this.computeBitCount(n);
        int n3 = (int)Math.pow(2.0, n2) - n;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getBlues(byArray2);
        indexColorModel.getGreens(byArray3);
        int n4 = 0;
        while (n4 < n) {
            lEDataOutputStream.writeByte(byArray2[n4]);
            lEDataOutputStream.writeByte(byArray3[n4]);
            lEDataOutputStream.writeByte(byArray[n4]);
            lEDataOutputStream.writeByte(0);
            ++n4;
        }
        byte[] byArray4 = new byte[4];
        int n5 = 0;
        while (n5 < n3) {
            lEDataOutputStream.write(byArray4);
            ++n5;
        }
    }

    protected void writePixels(LEDataOutputStream lEDataOutputStream, int n, AdaptiveRasterImage adaptiveRasterImage) throws JimiException, IOException {
        block10: {
            int n2;
            int[] nArray;
            int n3;
            int n4;
            block11: {
                int n5;
                block9: {
                    int n6;
                    adaptiveRasterImage.setRGBDefault(false);
                    n4 = adaptiveRasterImage.getHeight();
                    n3 = adaptiveRasterImage.getWidth();
                    nArray = new int[n3];
                    if (n != 2) break block9;
                    int n7 = n4 - 1;
                    while (n7 > -1) {
                        adaptiveRasterImage.getChannel(n7, nArray, 0);
                        n6 = 0;
                        while (n6 < n3) {
                            byte by = (byte)(nArray[n6] << 6);
                            by = (byte)(by | (byte)(nArray[++n6] << 4));
                            by = (byte)(by | (byte)(nArray[++n6] << 2));
                            by = (byte)(by | (byte)nArray[++n6]);
                            ++n6;
                        }
                        --n7;
                    }
                    byte[] byArray = new byte[n3 / 4];
                    n6 = 0;
                    while (n6 < n4) {
                        lEDataOutputStream.write(byArray);
                        ++n6;
                    }
                    break block10;
                }
                if (n != 4) break block11;
                int n8 = n4 - 1;
                while (n8 > -1) {
                    adaptiveRasterImage.getChannel(n8, nArray, 0);
                    n5 = 0;
                    while (n5 < n3) {
                        byte by = (byte)(nArray[n5] << 4);
                        by = (byte)(by | (byte)nArray[++n5]);
                        lEDataOutputStream.writeByte(by);
                        ++n5;
                    }
                    --n8;
                }
                byte[] byArray = new byte[n3 / 2];
                n5 = 0;
                while (n5 < n4) {
                    lEDataOutputStream.write(byArray);
                    ++n5;
                }
                break block10;
            }
            if (n != 8) break block10;
            int n9 = n4 - 1;
            while (n9 > -1) {
                adaptiveRasterImage.getChannel(n9, nArray, 0);
                n2 = 0;
                while (n2 < n3) {
                    lEDataOutputStream.writeByte((byte)nArray[n2]);
                    ++n2;
                }
                --n9;
            }
            byte[] byArray = new byte[n3];
            n2 = 0;
            while (n2 < n4) {
                lEDataOutputStream.write(byArray);
                ++n2;
            }
        }
    }

    protected int computeImageSize(int n, int n2, int n3, int n4) {
        return n3 * n4;
    }

    protected int computeBitCount(int n) {
        if (n <= 4) {
            return 2;
        }
        if (n <= 16) {
            return 4;
        }
        return 8;
    }
}

