/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.jpg;

import com.sun.jimi.core.encoder.jpg.CompressInfo;
import com.sun.jimi.core.encoder.jpg.JpegComponentInfo;
import com.sun.jimi.core.encoder.jpg.util;

public class CompressSetup {
    public static final short MAX_COMPS_IN_SCAN = 4;
    public static final short DCTSIZE = 8;
    public static final short MAX_BLOCKS_IN_MCU = 10;
    public static final short BITS_IN_SAMPLE = 8;
    public static final short MAX_SAMP_FACTOR = 4;
    public static final byte CS_UNKNOWN = 0;
    public static final byte CS_GRAYSCALE = 1;
    public static final byte CS_RGB = 2;
    public static final byte CS_YCbCr = 3;

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static void interleaved_scan_setup(CompressInfo compressInfo) {
        if (compressInfo.comps_in_scan > 4) {
            util.errexit("Too many components for interleaved scan");
        }
        compressInfo.MCUs_per_row = (compressInfo.image_width + compressInfo.max_h_samp_factor * 8 - 1) / (compressInfo.max_h_samp_factor * 8);
        compressInfo.MCU_rows_in_scan = (compressInfo.image_height + compressInfo.max_v_samp_factor * 8 - 1) / (compressInfo.max_v_samp_factor * 8);
        compressInfo.blocks_in_MCU = 0;
        short s = 0;
        while (s < compressInfo.comps_in_scan) {
            block6: {
                short s2;
                short s3;
                block5: {
                    block4: {
                        JpegComponentInfo jpegComponentInfo = compressInfo.cur_comp_info[s];
                        jpegComponentInfo.MCU_width = jpegComponentInfo.h_samp_factor;
                        jpegComponentInfo.MCU_height = jpegComponentInfo.v_samp_factor;
                        jpegComponentInfo.MCU_blocks = (short)(jpegComponentInfo.MCU_width * jpegComponentInfo.MCU_height);
                        jpegComponentInfo.downsampled_width = util.roundUp(jpegComponentInfo.true_comp_width, jpegComponentInfo.MCU_width * 8);
                        jpegComponentInfo.downsampled_height = util.roundUp(jpegComponentInfo.true_comp_height, jpegComponentInfo.MCU_height * 8);
                        s3 = jpegComponentInfo.MCU_blocks;
                        if (compressInfo.blocks_in_MCU + s3 > 10) break block4;
                        s2 = s3;
                        s3 = (short)(s2 - 1);
                        if (s2 > 0) break block5;
                        break block6;
                    }
                    util.errexit("Sampling factors too large for interleaved scan");
                    if (!true) break block5;
                    s2 = s3;
                    s3 = (short)(s2 - 1);
                    if (s2 <= 0) break block6;
                }
                do {
                    short s4 = compressInfo.blocks_in_MCU;
                    compressInfo.blocks_in_MCU = (short)(s4 + 1);
                    compressInfo.MCU_membership[s4] = s;
                    s2 = s3;
                    s3 = (short)(s2 - 1);
                } while (s2 > 0);
            }
            s = (short)(s + 1);
        }
    }

    static void noninterleaved_scan_setup(CompressInfo compressInfo) {
        JpegComponentInfo jpegComponentInfo = compressInfo.cur_comp_info[0];
        jpegComponentInfo.MCU_width = 1;
        jpegComponentInfo.MCU_height = 1;
        jpegComponentInfo.MCU_blocks = 1;
        jpegComponentInfo.downsampled_width = util.roundUp(jpegComponentInfo.true_comp_width, 8);
        jpegComponentInfo.downsampled_height = util.roundUp(jpegComponentInfo.true_comp_height, 8);
        compressInfo.MCUs_per_row = jpegComponentInfo.downsampled_width / 8;
        compressInfo.MCU_rows_in_scan = jpegComponentInfo.downsampled_height / 8;
        compressInfo.blocks_in_MCU = 1;
        compressInfo.MCU_membership[0] = 0;
    }

    public static void setCDefaults(CompressInfo compressInfo) {
        compressInfo.comp_info = null;
        compressInfo.data_precision = (short)8;
        compressInfo.jpeg_color_space = (short)3;
        compressInfo.num_components = (short)3;
        compressInfo.comps_in_scan = (short)3;
        compressInfo.comp_info = new JpegComponentInfo[3];
        compressInfo.comp_info[0] = new JpegComponentInfo();
        compressInfo.comp_info[0].component_index = 0;
        compressInfo.comp_info[0].component_id = 1;
        compressInfo.comp_info[0].h_samp_factor = (short)2;
        compressInfo.comp_info[0].v_samp_factor = (short)2;
        compressInfo.comp_info[0].quant_tbl_no = 0;
        compressInfo.comp_info[0].dc_tbl_no = 0;
        compressInfo.comp_info[0].ac_tbl_no = 0;
        compressInfo.comp_info[1] = new JpegComponentInfo();
        compressInfo.comp_info[1].component_index = 1;
        compressInfo.comp_info[1].component_id = (short)2;
        compressInfo.comp_info[1].h_samp_factor = 1;
        compressInfo.comp_info[1].v_samp_factor = 1;
        compressInfo.comp_info[1].quant_tbl_no = 1;
        compressInfo.comp_info[1].dc_tbl_no = 1;
        compressInfo.comp_info[1].ac_tbl_no = 1;
        compressInfo.comp_info[2] = new JpegComponentInfo();
        compressInfo.comp_info[2].component_index = (short)2;
        compressInfo.comp_info[2].component_id = (short)3;
        compressInfo.comp_info[2].h_samp_factor = 1;
        compressInfo.comp_info[2].v_samp_factor = 1;
        compressInfo.comp_info[2].quant_tbl_no = 1;
        compressInfo.comp_info[2].dc_tbl_no = 1;
        compressInfo.comp_info[2].ac_tbl_no = 1;
        compressInfo.cur_comp_info = new JpegComponentInfo[4];
        compressInfo.cur_comp_info[0] = compressInfo.comp_info[0];
        compressInfo.cur_comp_info[1] = compressInfo.comp_info[1];
        compressInfo.cur_comp_info[2] = compressInfo.comp_info[2];
        compressInfo.interleave = true;
    }

    public static void setMDefaults(CompressInfo compressInfo) {
        compressInfo.jpeg_color_space = 1;
        compressInfo.num_components = 1;
        compressInfo.comp_info[0].h_samp_factor = 1;
        compressInfo.comp_info[0].v_samp_factor = 1;
        compressInfo.comps_in_scan = 1;
        compressInfo.interleave = false;
    }

    public static void initial_setup(CompressInfo compressInfo) {
        JpegComponentInfo jpegComponentInfo;
        compressInfo.max_h_samp_factor = 1;
        compressInfo.max_v_samp_factor = 1;
        short s = 0;
        while (s < compressInfo.num_components) {
            jpegComponentInfo = compressInfo.comp_info[s];
            if (jpegComponentInfo.h_samp_factor <= 0 || jpegComponentInfo.h_samp_factor > 4 || jpegComponentInfo.v_samp_factor <= 0 || jpegComponentInfo.v_samp_factor > 4) {
                util.errexit("Bogus sampling factors");
            }
            compressInfo.max_h_samp_factor = (short)Math.max(compressInfo.max_h_samp_factor, jpegComponentInfo.h_samp_factor);
            compressInfo.max_v_samp_factor = (short)Math.max(compressInfo.max_v_samp_factor, jpegComponentInfo.v_samp_factor);
            s = (short)(s + 1);
        }
        s = 0;
        while (s < compressInfo.num_components) {
            jpegComponentInfo = compressInfo.comp_info[s];
            jpegComponentInfo.true_comp_width = (compressInfo.image_width * jpegComponentInfo.h_samp_factor + compressInfo.max_h_samp_factor - 1) / compressInfo.max_h_samp_factor;
            jpegComponentInfo.true_comp_height = (compressInfo.image_height * jpegComponentInfo.v_samp_factor + compressInfo.max_v_samp_factor - 1) / compressInfo.max_v_samp_factor;
            s = (short)(s + 1);
        }
    }
}

