/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.jpg;

import com.sun.jimi.core.encoder.jpg.CompressInfo;
import com.sun.jimi.core.encoder.jpg.HuffTbl;
import com.sun.jimi.core.encoder.jpg.util;
import java.io.IOException;

public class Write {
    static final short NUM_QUANT_TBLS = 4;
    static final short DCTSIZE = 8;
    static final short NUM_ARITH_TBLS = 4;
    public static final byte SOF0 = -64;
    public static final byte SOF1 = -63;
    public static final byte SOF2 = -62;
    public static final byte SOF3 = -61;
    public static final byte SOF5 = -59;
    public static final byte SOF6 = -58;
    public static final byte SOF7 = -57;
    public static final byte JPG = -56;
    public static final byte SOF9 = -55;
    public static final byte SOF10 = -54;
    public static final byte SOF11 = -53;
    public static final byte SOF13 = -51;
    public static final byte SOF14 = -50;
    public static final byte SOF15 = -49;
    public static final byte DHT = -60;
    public static final byte DAC = -52;
    public static final byte RST0 = -48;
    public static final byte RST1 = -47;
    public static final byte RST2 = -46;
    public static final byte RST3 = -45;
    public static final byte RST4 = -44;
    public static final byte RST5 = -43;
    public static final byte RST6 = -42;
    public static final byte RST7 = -41;
    public static final byte SOI = -40;
    public static final byte EOI = -39;
    public static final byte SOS = -38;
    public static final byte DQT = -37;
    public static final byte DNL = -36;
    public static final byte DRI = -35;
    public static final byte DHP = -34;
    public static final byte EXP = -33;
    public static final byte APP0 = -32;
    public static final byte APP15 = -17;
    public static final byte JPG0 = -16;
    public static final byte JPG13 = -3;
    public static final byte COM = -2;
    public static final byte TEM = 1;
    public static final byte ERROR = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void write_byte(CompressInfo compressInfo, int n) {
        try {
            compressInfo.output_file.writeByte(n);
            return;
        }
        catch (IOException iOException) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void write_bytes(CompressInfo compressInfo, byte[] byArray, int n) {
        try {
            compressInfo.output_file.write(byArray, 0, n);
            return;
        }
        catch (IOException iOException) {
        }
    }

    static void write_marker(CompressInfo compressInfo, byte by) {
        Write.write_byte(compressInfo, 255);
        Write.write_byte(compressInfo, by);
    }

    static void write_2bytes(CompressInfo compressInfo, int n) {
        Write.write_byte(compressInfo, n >> 8 & 0xFF);
        Write.write_byte(compressInfo, n & 0xFF);
    }

    static void write_dqt(CompressInfo compressInfo, int n) {
        Write.write_marker(compressInfo, (byte)-37);
        Write.write_2bytes(compressInfo, 67);
        Write.write_byte(compressInfo, n);
        int n2 = 0;
        while (n2 < 64) {
            Write.write_byte(compressInfo, compressInfo.quant_tbl[n][n2]);
            ++n2;
        }
    }

    static void write_dht(CompressInfo compressInfo, int n, boolean bl) {
        HuffTbl huffTbl;
        if (bl) {
            huffTbl = compressInfo.ac_huff_tbl[n];
            n += 16;
        } else {
            huffTbl = compressInfo.dc_huff_tbl[n];
        }
        if (huffTbl == null) {
            util.errexit("Huffman table " + n + " was not defined");
        }
        if (!huffTbl.sent_table) {
            Write.write_marker(compressInfo, (byte)-60);
            int n2 = 0;
            int n3 = 1;
            while (n3 <= 16) {
                n2 += huffTbl.bits[n3];
                ++n3;
            }
            Write.write_2bytes(compressInfo, n2 + 2 + 1 + 16);
            Write.write_byte(compressInfo, n);
            n3 = 1;
            while (n3 <= 16) {
                Write.write_byte(compressInfo, huffTbl.bits[n3]);
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                Write.write_byte(compressInfo, huffTbl.huffval[n3]);
                ++n3;
            }
            huffTbl.sent_table = true;
        }
    }

    static void write_sof(CompressInfo compressInfo, byte by) {
        Write.write_marker(compressInfo, by);
        Write.write_2bytes(compressInfo, 3 * compressInfo.num_components + 2 + 5 + 1);
        Write.write_byte(compressInfo, compressInfo.data_precision);
        Write.write_2bytes(compressInfo, compressInfo.image_height);
        Write.write_2bytes(compressInfo, compressInfo.image_width);
        Write.write_byte(compressInfo, compressInfo.num_components);
        int n = 0;
        while (n < compressInfo.num_components) {
            Write.write_byte(compressInfo, compressInfo.comp_info[n].component_id);
            Write.write_byte(compressInfo, (compressInfo.comp_info[n].h_samp_factor << 4) + compressInfo.comp_info[n].v_samp_factor);
            Write.write_byte(compressInfo, compressInfo.comp_info[n].quant_tbl_no);
            ++n;
        }
    }

    static void write_sos(CompressInfo compressInfo) {
        Write.write_marker(compressInfo, (byte)-38);
        Write.write_2bytes(compressInfo, 2 * compressInfo.comps_in_scan + 2 + 1 + 3);
        Write.write_byte(compressInfo, compressInfo.comps_in_scan);
        int n = 0;
        while (n < compressInfo.comps_in_scan) {
            Write.write_byte(compressInfo, compressInfo.cur_comp_info[n].component_id);
            Write.write_byte(compressInfo, (compressInfo.cur_comp_info[n].dc_tbl_no << 4) + compressInfo.cur_comp_info[n].ac_tbl_no);
            ++n;
        }
        Write.write_byte(compressInfo, 0);
        Write.write_byte(compressInfo, 63);
        Write.write_byte(compressInfo, 0);
    }

    public static void write_file_header(CompressInfo compressInfo) {
        short[] sArray = new short[4];
        Write.write_marker(compressInfo, (byte)-40);
        int n = 0;
        while (n < 4) {
            sArray[n] = 0;
            ++n;
        }
        n = 0;
        while (n < compressInfo.num_components) {
            sArray[compressInfo.comp_info[n].quant_tbl_no] = 1;
            ++n;
        }
        boolean bl = false;
        n = 0;
        while (n < 4) {
            if (sArray[n] != 0) {
                Write.write_dqt(compressInfo, n);
            }
            ++n;
        }
        boolean bl2 = true;
        if (bl2) {
            Write.write_sof(compressInfo, (byte)-64);
        } else {
            Write.write_sof(compressInfo, (byte)-63);
        }
    }

    public static void write_scan_header(CompressInfo compressInfo) {
        int n = 0;
        while (n < compressInfo.comps_in_scan) {
            Write.write_dht(compressInfo, compressInfo.cur_comp_info[n].dc_tbl_no, false);
            Write.write_dht(compressInfo, compressInfo.cur_comp_info[n].ac_tbl_no, true);
            ++n;
        }
        Write.write_sos(compressInfo);
    }

    public static void write_jpeg_data(CompressInfo compressInfo, byte[] byArray, int n) {
        Write.write_bytes(compressInfo, byArray, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write_file_trailer(CompressInfo compressInfo) {
        Write.write_marker(compressInfo, (byte)-39);
        try {
            compressInfo.output_file.flush();
            return;
        }
        catch (IOException iOException) {
        }
    }
}

