/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.pcx;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.pcx.RLEOutputStreamForPCX;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.Toolkit;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PCXEncoder
extends JimiEncoderBase {
    OutputStream myOut;
    RLEOutputStreamForPCX dataOut;
    LEDataOutputStream LEDOut;
    private int nState;
    int nBitsPerPixel = 8;
    int nBitPlanes = 1;
    int nBytesPerLine = 0;
    int nPaletteType = 1;
    int nVersion = 5;
    AdaptiveRasterImage myJimiImage;
    protected int COLOR_MODEL = 0;

    public void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.nState = 0;
        this.myOut = outputStream;
        if (adaptiveRasterImage.getColorModel() instanceof DirectColorModel) {
            this.nBitPlanes = 3;
            this.COLOR_MODEL = 1;
        }
        this.LEDOut = new LEDataOutputStream(new BufferedOutputStream(this.myOut));
        this.dataOut = new RLEOutputStreamForPCX(this.LEDOut);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writePcxHeader(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage adaptiveRasterImage) {
        byte[] byArray = new byte[54];
        byte[] byArray2 = new byte[48];
        byte[] byArray3 = new byte[2];
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = adaptiveRasterImage.getWidth();
        int n5 = adaptiveRasterImage.getHeight();
        int n6 = n4;
        n2 = n + n4 - 1;
        n3 = n + n5 - 1;
        try {
            Object object;
            lEDataOutputStream.write(10);
            lEDataOutputStream.write((byte)this.nVersion);
            lEDataOutputStream.write(1);
            lEDataOutputStream.write((byte)this.nBitsPerPixel);
            lEDataOutputStream.writeShort(0);
            lEDataOutputStream.writeShort(0);
            lEDataOutputStream.writeShort(n2);
            lEDataOutputStream.writeShort(n3);
            lEDataOutputStream.writeShort(n4);
            lEDataOutputStream.writeShort(n5);
            if (this.COLOR_MODEL == 0) {
                object = (IndexColorModel)adaptiveRasterImage.getColorModel();
                byArray2 = this.makePalette((IndexColorModel)object, 16);
            }
            lEDataOutputStream.write(byArray2);
            lEDataOutputStream.write(0);
            lEDataOutputStream.write((byte)this.nBitPlanes);
            lEDataOutputStream.writeShort(n6);
            lEDataOutputStream.writeShort(this.nPaletteType);
            object = Toolkit.getDefaultToolkit();
            lEDataOutputStream.writeShort(((Toolkit)object).getScreenSize().width);
            lEDataOutputStream.writeShort(((Toolkit)object).getScreenSize().height);
            lEDataOutputStream.write(byArray);
            lEDataOutputStream.flush();
            return;
        }
        catch (IOException iOException) {
            this.nState = 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] makePalette(IndexColorModel indexColorModel, int n) {
        int n2 = n * 3;
        byte[] byArray = new byte[n2];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        int n3 = indexColorModel.getMapSize();
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        indexColorModel.getReds(byArray2);
        indexColorModel.getGreens(byArray3);
        indexColorModel.getBlues(byArray4);
        try {
            int n4 = n < n3 ? n : n3;
            int n5 = 0;
            while (n5 < n4) {
                byteArrayOutputStream.write(byArray2[n5]);
                byteArrayOutputStream.write(byArray3[n5]);
                byteArrayOutputStream.write(byArray4[n5]);
                ++n5;
            }
            if (n > n3) {
                n5 = 0;
                while (n5 < n - n4) {
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    ++n5;
                }
            }
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            this.nState = 1;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writePcxImage(RLEOutputStreamForPCX rLEOutputStreamForPCX, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        int n = adaptiveRasterImage.getWidth();
        int n2 = adaptiveRasterImage.getHeight();
        this.nBytesPerLine = n + 1;
        byte[] byArray = new byte[this.nBytesPerLine];
        try {
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return;
                }
                if (this.COLOR_MODEL == 0) {
                    adaptiveRasterImage.getChannel(0, n3, byArray, 0);
                    rLEOutputStreamForPCX.write(byArray);
                } else {
                    adaptiveRasterImage.setRGBDefault(true);
                    adaptiveRasterImage.getChannel(1, n3, byArray, 0);
                    rLEOutputStreamForPCX.write(byArray);
                    adaptiveRasterImage.getChannel(2, n3, byArray, 0);
                    rLEOutputStreamForPCX.write(byArray);
                    adaptiveRasterImage.getChannel(3, n3, byArray, 0);
                    rLEOutputStreamForPCX.write(byArray);
                }
                this.setProgress(n3 * 100 / n2);
                ++n3;
            }
        }
        catch (IOException iOException) {
            this.nState = 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writePcxFooter(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage adaptiveRasterImage) {
        byte[] byArray = new byte[768];
        IndexColorModel indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
        byArray = this.makePalette(indexColorModel, 256);
        try {
            lEDataOutputStream.write(12);
            lEDataOutputStream.write(byArray, 0, byArray.length);
            return;
        }
        catch (IOException iOException) {
            this.nState = 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        try {
            this.writePcxHeader(this.LEDOut, adaptiveRasterImage);
            this.writePcxImage(this.dataOut, adaptiveRasterImage);
            if (this.COLOR_MODEL == 0) {
                this.writePcxFooter(this.LEDOut, adaptiveRasterImage);
            }
            this.LEDOut.flush();
            this.dataOut.flush();
            this.myOut.flush();
            this.nState = 2;
            return false;
        }
        catch (IOException iOException) {
            this.nState = 1;
        }
        return false;
    }

    public void freeEncoder() throws JimiException {
        this.myOut = null;
        this.dataOut = null;
        this.LEDOut = null;
        super.freeEncoder();
    }

    public int getState() {
        return this.nState;
    }
}

