/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.pict;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.Packbits;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.IOException;

class PICTWriter {
    public static final int PICT_PACKBITSRECT = 152;
    public static final int PICT_9A = 154;
    public static final int PICT_END = 255;
    public static final int PICT_CLIP_RGN = 1;
    public static final int PICT_BITSRECT = 144;
    static final int GRAYSCALE = 1;
    static final int PALETTE = 2;
    static final int RGB = 3;
    AdaptiveRasterImage ji_;
    DataOutputStream out_;
    short width_;
    short height_;
    short pixelSize_;
    short rowBytes_;
    short packType_;
    boolean compress_;
    JimiEncoderBase encoder_;
    int outputCount_;
    byte[] bufC_;

    void writeHeaders() throws IOException {
        this.writeHeader();
        this.writeV2AdditionalHeader();
    }

    void writeImage() throws JimiException, IOException {
        int n = -1;
        ColorModel colorModel = this.ji_.getColorModel();
        int n2 = this.ji_.getWidth();
        int n3 = this.ji_.getHeight();
        if (n2 > Short.MAX_VALUE || n3 > Short.MAX_VALUE) {
            throw new JimiException("PICT only saves images < 32767 in width or height");
        }
        this.width_ = (short)n2;
        this.height_ = (short)n3;
        if (colorModel instanceof DirectColorModel) {
            int bl = colorModel.getPixelSize();
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            int n4 = directColorModel.getRedMask();
            int n5 = directColorModel.getGreenMask();
            int n6 = directColorModel.getBlueMask();
            if (bl <= 8 && n4 == n5 && n5 == n6) {
                n = 1;
                this.pixelSize_ = (short)bl;
            }
        } else if (colorModel instanceof IndexColorModel) {
            n = 2;
            this.pixelSize_ = (short)colorModel.getPixelSize();
        }
        if (n == -1) {
            n = 3;
            this.ji_.setRGBDefault(true);
            this.pixelSize_ = (short)32;
        }
        switch (n) {
            case 1: {
                if (this.pixelSize_ == 1) {
                    this.rowBytes_ = (short)(this.width_ / 8 + (n2 % 8 != 0 ? 1 : 0));
                    break;
                }
            }
            case 2: {
                this.rowBytes_ = (short)(this.width_ * 8 / this.pixelSize_ + (n2 * 8 % this.pixelSize_ != 0 ? 1 : 0));
                break;
            }
            case 3: {
                this.rowBytes_ = (short)(3 * this.width_);
                break;
            }
        }
        boolean bl = this.compress_ = this.rowBytes_ >= 8 || this.pixelSize_ == 32;
        if (n == 3) {
            this.out_.writeShort(154);
        } else if (this.compress_) {
            this.out_.writeShort(152);
        } else {
            this.out_.writeShort(144);
        }
        switch (n) {
            case 1: {
                if (this.pixelSize_ == 1) {
                    this.out_.writeShort(this.rowBytes_);
                    this.writeBitmap();
                    this.writeSrcDestMode();
                    boolean bl2 = false;
                    this.writeBitmapImageData(bl2);
                    break;
                }
            }
            case 2: {
                this.packType_ = 0;
                this.out_.writeShort(this.rowBytes_ | 0x8000);
                this.writePixmap();
                this.writeColorTable(colorModel);
                this.writeSrcDestMode();
                this.writeImageData();
                break;
            }
            case 3: {
                this.packType_ = (short)4;
                this.writePixmap9A();
                this.writeSrcDestMode();
                this.writeDirectImageData();
                break;
            }
        }
        this.out_.writeShort(255);
    }

    void writeBitmap() throws IOException {
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.height_);
        this.out_.writeShort(this.width_);
    }

    void writeSrcDestMode() throws IOException {
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.height_);
        this.out_.writeShort(this.width_);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.height_);
        this.out_.writeShort(this.width_);
        this.out_.writeShort(0);
    }

    void writeBitmapImageData(boolean bl) throws JimiException, IOException {
        byte[] byArray = new byte[this.width_];
        byte[] byArray2 = new byte[this.rowBytes_];
        boolean bl2 = false;
        int n = 0;
        while (n < this.height_) {
            this.ji_.getChannel(0, n, byArray, 0);
            int n2 = JimiUtil.packPixels(1, byArray, byArray2);
            if (!bl) {
                int n3 = byArray2.length;
                while (--n3 >= 0) {
                    byArray2[n3] = ~byArray2[n3];
                }
            }
            this.outputBufRow(byArray2);
            this.encoder_.setProgress(n * 100 / this.height_);
            ++n;
        }
        this.outputEvenByteFlush();
    }

    void writePixmap() throws IOException {
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.height_);
        this.out_.writeShort(this.width_);
        this.out_.writeShort(0);
        this.out_.writeShort(this.packType_);
        this.out_.writeInt(0);
        this.out_.writeShort(72);
        this.out_.writeShort(0);
        this.out_.writeShort(72);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.pixelSize_);
        this.out_.writeShort(1);
        this.out_.writeShort(this.pixelSize_);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
    }

    void writeImageData() throws JimiException, IOException {
        byte[] byArray = new byte[this.width_];
        byte[] byArray2 = new byte[this.rowBytes_];
        boolean bl = false;
        int n = 0;
        while (n < this.height_) {
            this.ji_.getChannel(0, n, byArray, 0);
            int n2 = JimiUtil.packPixels(this.pixelSize_, byArray, byArray2);
            this.outputBufRow(byArray2);
            this.encoder_.setProgress(n * 100 / this.height_);
            ++n;
        }
        this.outputEvenByteFlush();
    }

    void writePixmap9A() throws IOException {
        this.out_.writeInt(255);
        this.out_.writeShort(33568);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.height_);
        this.out_.writeShort(this.width_);
        this.out_.writeShort(0);
        this.out_.writeShort(this.packType_);
        this.out_.writeInt(0);
        this.out_.writeShort(72);
        this.out_.writeShort(0);
        this.out_.writeShort(72);
        this.out_.writeShort(0);
        this.out_.writeShort(16);
        this.out_.writeShort(this.pixelSize_);
        this.out_.writeShort(3);
        this.out_.writeShort(8);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
    }

    void writeDirectImageData() throws JimiException, IOException {
        byte[] byArray = new byte[this.rowBytes_];
        int n = 0;
        while (n < this.height_) {
            int n2 = 0;
            this.ji_.getChannel(16, n, byArray, n2);
            this.ji_.getChannel(8, n, byArray, n2 += this.width_);
            this.ji_.getChannel(0, n, byArray, n2 += this.width_);
            this.outputBufRow(byArray);
            this.encoder_.setProgress(n * 100 / this.height_);
            ++n;
        }
        this.outputEvenByteFlush();
    }

    void outputBufRow(byte[] byArray) throws IOException {
        if (this.compress_) {
            if (this.bufC_ == null) {
                this.bufC_ = new byte[byArray.length + 1 + byArray.length / 8];
            }
            int n = Packbits.packbits(byArray, this.bufC_);
            if (this.rowBytes_ > 250) {
                this.out_.writeShort(n);
            } else {
                this.out_.writeByte(n);
            }
            this.out_.write(this.bufC_, 0, n);
            this.outputCount_ += n;
        } else {
            this.out_.write(byArray);
            this.outputCount_ += byArray.length;
        }
    }

    void outputEvenByteFlush() throws IOException {
        if ((this.outputCount_ & 1) != 0) {
            this.out_.writeByte(0);
        }
    }

    void writeColorTable(ColorModel colorModel) throws IOException {
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n = indexColorModel.getMapSize();
            this.out_.writeInt(0);
            this.out_.writeShort(0);
            this.out_.writeShort((short)n - 1);
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            int n2 = 0;
            while (n2 < n) {
                this.out_.writeShort(n2);
                this.out_.writeShort((short)((byArray[n2] & 0xFF) << 8 | byArray[n2] & 0xFF));
                this.out_.writeShort((short)((byArray2[n2] & 0xFF) << 8 | byArray2[n2] & 0xFF));
                this.out_.writeShort((short)((byArray3[n2] & 0xFF) << 8 | byArray3[n2] & 0xFF));
                ++n2;
            }
        } else {
            int n = colorModel.getPixelSize();
            int n3 = 1 << n;
            this.out_.writeInt(0);
            this.out_.writeShort(0);
            this.out_.writeShort((short)n3 - 1);
            int n4 = 0;
            while (n4 < n3) {
                this.out_.writeShort(n4);
                int n5 = colorModel.getRed(n4);
                int n6 = colorModel.getGreen(n4);
                int n7 = colorModel.getBlue(n4);
                this.out_.writeShort((short)(n5 << 8 | n5));
                this.out_.writeShort((short)(n6 << 8 | n6));
                this.out_.writeShort((short)(n7 << 8 | n7));
                ++n4;
            }
        }
    }

    void writeHeader() throws IOException {
        byte[] byArray = new byte[64];
        int n = 8;
        while (--n >= 0) {
            this.out_.write(byArray);
        }
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.ji_.getHeight());
        this.out_.writeShort(this.ji_.getWidth());
        this.out_.writeShort(17);
        this.out_.writeShort(767);
    }

    void writeV2AdditionalHeader() throws IOException {
        this.out_.writeShort(3072);
        this.out_.writeShort(65535);
        this.out_.writeShort(0);
        this.out_.writeInt(0x480000);
        this.out_.writeInt(0x480000);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeInt(0);
    }

    PICTWriter(JimiEncoderBase jimiEncoderBase, AdaptiveRasterImage adaptiveRasterImage, DataOutputStream dataOutputStream) throws JimiException {
        this.ji_ = adaptiveRasterImage;
        this.out_ = dataOutputStream;
        this.encoder_ = jimiEncoderBase;
    }
}

