/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.OptionsObject;
import com.sun.jimi.core.encoder.png.PNGConstants;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import com.sun.jimi.util.ArrayEnumeration;
import java.util.Enumeration;

class PNGOptionsObject
implements OptionsObject,
PNGConstants {
    static final String ALPHA_OPTION_NAME = "alpha";
    static final String COMPRESSION_OPTION_NAME = "compression";
    static final String INTERLACE_OPTION_NAME = "interlace";
    static final String FILTER_OPTION_NAME = "filter";
    static final String[] OPTION_NAMES = new String[]{"alpha", "compression", "interlace", "filter"};
    static final Boolean[] POSSIBLE_ALPHA_OPTIONS = new Boolean[]{Boolean.TRUE, Boolean.FALSE, null};
    static final String COMPRESSION_NONE = "none";
    static final String COMPRESSION_DEFAULT = "default";
    static final String COMPRESSION_FAST = "fast";
    static final String COMPRESSION_MAX = "max";
    static final String[] POSSIBLE_COMPRESSION_OPTIONS = new String[]{"none", "fast", "default", "max"};
    static final String INTERLACE_NONE = "none";
    static final String INTERLACE_ADAM7 = "adam7";
    static final String[] POSSIBLE_INTERLACE_OPTIONS = new String[]{"none", "adam7"};
    static final String FILTER_NONE = "none";
    static final String FILTER_SUB = "sub";
    static final String FILTER_UP = "up";
    static final String FILTER_AVG = "average";
    static final String FILTER_PAETH = "paeth";
    static final String FILTER_ALL = "all";
    static final String[] POSSIBLE_FILTER_OPTIONS = new String[]{"none", "sub", "up", "average", "paeth", "all"};
    PNGEncoder encoder;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setProperty(String string, Object object) throws InvalidOptionException {
        if (string.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            String string2;
            try {
                string2 = (String)object;
            }
            catch (ClassCastException classCastException) {
                throw new InvalidOptionException("Not a valid option");
            }
            if (string2.equalsIgnoreCase("none")) {
                this.encoder.setCompression(0);
                return;
            }
            if (string2.equalsIgnoreCase(COMPRESSION_FAST)) {
                this.encoder.setCompression(1);
                return;
            }
            if (string2.equalsIgnoreCase(COMPRESSION_MAX)) {
                this.encoder.setCompression(9);
                return;
            }
            if (!string2.equalsIgnoreCase(COMPRESSION_DEFAULT)) throw new InvalidOptionException("Not a valid option");
            this.encoder.setCompression(-1);
            return;
        }
        if (string.equalsIgnoreCase(INTERLACE_OPTION_NAME)) {
            String string3 = object.toString();
            if (string3.equalsIgnoreCase("none")) {
                this.encoder.setInterlace((byte)0);
                return;
            }
            if (!string3.equalsIgnoreCase(INTERLACE_ADAM7)) throw new InvalidOptionException("Not a valid option");
            this.encoder.setInterlace((byte)1);
            return;
        }
        if (string.equalsIgnoreCase(ALPHA_OPTION_NAME)) {
            if (object == null) {
                this.encoder.setAlpha(null);
                return;
            }
            try {
                this.encoder.setAlpha((Boolean)object);
                return;
            }
            catch (ClassCastException classCastException) {
                throw new InvalidOptionException("Value must be a java.lang.Boolean");
            }
        }
        if (!string.equalsIgnoreCase(FILTER_OPTION_NAME)) throw new InvalidOptionException("No such property");
        String string4 = object.toString();
        if (string4.equalsIgnoreCase("none")) {
            this.encoder.setFilter((byte)0);
            return;
        }
        if (string4.equalsIgnoreCase(FILTER_SUB)) {
            this.encoder.setFilter((byte)1);
            return;
        }
        if (string4.equalsIgnoreCase(FILTER_AVG)) {
            this.encoder.setFilter((byte)3);
            return;
        }
        if (string4.equalsIgnoreCase(FILTER_UP)) {
            this.encoder.setFilter((byte)2);
            return;
        }
        if (string4.equalsIgnoreCase(FILTER_PAETH)) {
            this.encoder.setFilter((byte)4);
            return;
        }
        if (!string4.equalsIgnoreCase(FILTER_ALL)) throw new InvalidOptionException("No such option");
        this.encoder.setFilter((byte)5);
    }

    public Enumeration getPropertyNames() {
        return new ArrayEnumeration(OPTION_NAMES);
    }

    public Object getPossibleValuesForProperty(String string) throws InvalidOptionException {
        if (string.equalsIgnoreCase(ALPHA_OPTION_NAME)) {
            return POSSIBLE_ALPHA_OPTIONS;
        }
        if (string.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            return POSSIBLE_COMPRESSION_OPTIONS;
        }
        if (string.equalsIgnoreCase(INTERLACE_OPTION_NAME)) {
            return POSSIBLE_INTERLACE_OPTIONS;
        }
        if (string.equalsIgnoreCase(FILTER_OPTION_NAME)) {
            return POSSIBLE_FILTER_OPTIONS;
        }
        throw new InvalidOptionException("No such option");
    }

    public void clearProperties() {
        this.encoder.setInterlace((byte)0);
        this.encoder.setAlpha(null);
        this.encoder.setCompression(0);
        this.encoder.setFilter((byte)0);
    }

    public Object getProperty(String string) {
        if (string.equalsIgnoreCase(INTERLACE_OPTION_NAME)) {
            byte by = this.encoder.getInterlace();
            if (by == 0) {
                return "none";
            }
            return INTERLACE_ADAM7;
        }
        if (string.equalsIgnoreCase(ALPHA_OPTION_NAME)) {
            return this.encoder.getAlpha();
        }
        if (string.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            byte by = (byte)this.encoder.getCompression();
            if (by == 0) {
                return "none";
            }
            if (by == 1) {
                return COMPRESSION_FAST;
            }
            if (by == 9) {
                return COMPRESSION_MAX;
            }
            return COMPRESSION_DEFAULT;
        }
        if (string.equalsIgnoreCase(FILTER_OPTION_NAME)) {
            byte by = this.encoder.getFilter();
            if (by == 0) {
                return "none";
            }
            if (by == 1) {
                return FILTER_SUB;
            }
            if (by == 3) {
                return FILTER_AVG;
            }
            if (by == 2) {
                return FILTER_UP;
            }
            if (by == 4) {
                return FILTER_PAETH;
            }
            return FILTER_ALL;
        }
        return null;
    }

    public String getPropertyDescription(String string) throws InvalidOptionException {
        if (string.equalsIgnoreCase(ALPHA_OPTION_NAME)) {
            return "An alpha channel is optional, a null value will let JIMI decide";
        }
        if (string.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            return "This option has no affect";
        }
        if (string.equalsIgnoreCase(INTERLACE_OPTION_NAME)) {
            return "Not currently implemented";
        }
        if (string.equalsIgnoreCase(FILTER_OPTION_NAME)) {
            return "Not currently implemented";
        }
        throw new InvalidOptionException("No such option");
    }

    PNGOptionsObject(PNGEncoder pNGEncoder) {
        this.encoder = pNGEncoder;
    }
}

