/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.png.PNGChunkUtil;
import com.sun.jimi.core.encoder.png.PNGConstants;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.IOException;

class png_chunk_ihdr
implements PNGConstants {
    int width;
    int height;
    byte bitDepth;
    byte colorType;
    byte compressionType;
    byte filterMethod;
    byte interlaceMethod;
    PNGChunkUtil pcu;

    void process(AdaptiveRasterImage adaptiveRasterImage, PNGEncoder pNGEncoder) throws JimiException {
        Object object;
        ColorModel colorModel = adaptiveRasterImage.getColorModel();
        this.colorType = (byte)-1;
        if (colorModel instanceof DirectColorModel) {
            object = (DirectColorModel)colorModel;
            int n = ((DirectColorModel)object).getRedMask();
            int n2 = ((DirectColorModel)object).getGreenMask();
            int n3 = ((DirectColorModel)object).getBlueMask();
            int n4 = ((ColorModel)object).getPixelSize();
            int n5 = (1 << n4) - 1;
            if (n4 <= 8 && n == n5 && n2 == n5 && n3 == n5) {
                this.bitDepth = (byte)colorModel.getPixelSize();
                this.colorType = 0;
            }
        } else if (colorModel instanceof IndexColorModel) {
            this.bitDepth = (byte)colorModel.getPixelSize();
            this.colorType = (byte)3;
        }
        if (this.colorType == -1) {
            adaptiveRasterImage.setRGBDefault(true);
            this.bitDepth = (byte)8;
            object = pNGEncoder.getAlpha();
            this.colorType = object == null ? (adaptiveRasterImage.getAlphaStatus() == 1 ? (byte)6 : (byte)2) : (((Boolean)object).equals(Boolean.TRUE) ? (byte)6 : (byte)2);
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(13);
        dataOutputStream.write(PNGConstants.png_IHDR);
        dataOutputStream.writeInt(this.width);
        dataOutputStream.writeInt(this.height);
        dataOutputStream.writeByte(this.bitDepth);
        dataOutputStream.writeByte(this.colorType);
        dataOutputStream.writeByte(this.compressionType);
        dataOutputStream.writeByte(this.filterMethod);
        dataOutputStream.writeByte(this.interlaceMethod);
        this.pcu.resetCRC();
        this.pcu.updateCRC(PNGConstants.png_IHDR);
        this.pcu.updateCRC(this.width);
        this.pcu.updateCRC(this.height);
        this.pcu.updateCRC(this.bitDepth);
        this.pcu.updateCRC(this.colorType);
        this.pcu.updateCRC(this.compressionType);
        this.pcu.updateCRC(this.filterMethod);
        this.pcu.updateCRC(this.interlaceMethod);
        dataOutputStream.writeInt(this.pcu.getCRC());
    }

    png_chunk_ihdr(AdaptiveRasterImage adaptiveRasterImage, PNGChunkUtil pNGChunkUtil, PNGEncoder pNGEncoder) throws JimiException {
        this.width = adaptiveRasterImage.getWidth();
        this.height = adaptiveRasterImage.getHeight();
        this.process(adaptiveRasterImage, pNGEncoder);
        this.compressionType = 0;
        this.filterMethod = pNGEncoder.getFilter();
        this.interlaceMethod = pNGEncoder.getInterlace();
        this.pcu = pNGChunkUtil;
    }
}

