/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.png.PNGChunkUtil;
import com.sun.jimi.core.encoder.png.PNGConstants;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.IOException;

public class png_chunk_trns
implements PNGConstants {
    private static final int NO_TRANSPARENT_PIXELS = -1;
    protected byte[] alphaValues;
    protected int lastTransparentIndex = -1;
    protected PNGChunkUtil pngUtil;

    public void write(DataOutputStream dataOutputStream) throws IOException {
        if (this.lastTransparentIndex == -1) {
            return;
        }
        dataOutputStream.writeInt(this.lastTransparentIndex + 1);
        dataOutputStream.write(PNGConstants.png_tRNS);
        this.pngUtil.resetCRC();
        this.pngUtil.updateCRC(PNGConstants.png_tRNS);
        int n = 0;
        while (n <= this.lastTransparentIndex) {
            dataOutputStream.write(this.alphaValues[n]);
            this.pngUtil.updateCRC(this.alphaValues[n]);
            ++n;
        }
        dataOutputStream.writeInt(this.pngUtil.getCRC());
    }

    public png_chunk_trns(AdaptiveRasterImage adaptiveRasterImage, PNGChunkUtil pNGChunkUtil, PNGEncoder pNGEncoder) throws JimiException {
        this.pngUtil = pNGChunkUtil;
        if (!(adaptiveRasterImage.getColorModel() instanceof IndexColorModel)) {
            return;
        }
        IndexColorModel indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
        this.alphaValues = new byte[indexColorModel.getMapSize()];
        indexColorModel.getAlphas(this.alphaValues);
        int n = 0;
        while (n < this.alphaValues.length) {
            if (this.alphaValues[n] != 255) {
                this.lastTransparentIndex = n;
            }
            ++n;
        }
    }
}

