/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.sunraster;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.sunraster.RLEOutputStream;
import com.sun.jimi.core.encoder.sunraster.SpecificEncoder;
import com.sun.jimi.core.encoder.sunraster.SunRasterHeader;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class PaletteSunRasterEncoder
extends SpecificEncoder {
    protected boolean useRLE_ = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doImageEncode() throws JimiException {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        try {
            this.writeImage();
            return;
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.toString());
        }
    }

    public void setUseRLE(boolean bl) {
        this.useRLE_ = bl;
    }

    protected void writeImage() throws IOException, JimiException {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        SunRasterHeader sunRasterHeader = this.getHeader();
        sunRasterHeader.setDepth(8);
        if (this.useRLE_) {
            sunRasterHeader.setType(2);
        } else {
            sunRasterHeader.setType(1);
        }
        sunRasterHeader.setPalette((IndexColorModel)adaptiveRasterImage.getColorModel());
        this.writeHeader();
        OutputStream outputStream = this.getOutputStream();
        if (this.useRLE_) {
            outputStream = new RLEOutputStream(outputStream);
        }
        int n = adaptiveRasterImage.getHeight();
        int n2 = adaptiveRasterImage.getWidth();
        int n3 = n2;
        if (n3 % 2 != 0) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n) {
            adaptiveRasterImage.getChannel(0, n4, byArray, 0);
            outputStream.write(byArray);
            ++n4;
        }
        outputStream.flush();
    }
}

