/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.tga;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.tga.TGAEncoderIfc;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.IndexColorModel;
import java.io.IOException;

public class TGA8Encoder
implements TGAEncoderIfc {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encodeTGA(AdaptiveRasterImage adaptiveRasterImage, LEDataOutputStream lEDataOutputStream) throws JimiException {
        IndexColorModel indexColorModel;
        try {
            indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
        }
        catch (ClassCastException classCastException) {
            throw new JimiException("TGA8 requires an IndexColorModel.");
        }
        int n = indexColorModel.getMapSize();
        try {
            int n2 = adaptiveRasterImage.getWidth();
            int n3 = adaptiveRasterImage.getHeight();
            lEDataOutputStream.writeByte(0);
            lEDataOutputStream.writeByte(1);
            lEDataOutputStream.writeByte(1);
            lEDataOutputStream.writeShort(0);
            lEDataOutputStream.writeShort(n);
            lEDataOutputStream.writeByte(24);
            lEDataOutputStream.writeShort(0);
            lEDataOutputStream.writeShort(0);
            lEDataOutputStream.writeShort(n2);
            lEDataOutputStream.writeShort(n3);
            lEDataOutputStream.write(8);
            lEDataOutputStream.write(0);
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            int n4 = 0;
            while (n4 < n) {
                lEDataOutputStream.writeByte(byArray3[n4]);
                lEDataOutputStream.writeByte(byArray2[n4]);
                lEDataOutputStream.writeByte(byArray[n4]);
                ++n4;
            }
            byte[] byArray4 = new byte[n2];
            n4 = 0;
            while (n4 < n3) {
                int n5 = n3 - n4 - 1;
                adaptiveRasterImage.getChannel(0, n5, byArray4, 0);
                lEDataOutputStream.write(byArray4);
                ++n4;
            }
            return;
        }
        catch (IOException iOException) {
            throw new JimiException("TGA8Encoder encodeTGA() IOException encountered");
        }
    }
}

