/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.tga;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.tga.TGA24Encoder;
import com.sun.jimi.core.encoder.tga.TGA8Encoder;
import com.sun.jimi.core.encoder.tga.TGAEncoderIfc;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class TGAEncoder
extends JimiEncoderBase
implements TGAEncoderIfc {
    private OutputStream out;
    private LEDataOutputStream bOut;
    private int state;

    protected void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.out = outputStream;
        this.bOut = new LEDataOutputStream(outputStream);
        this.state = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        this.encodeTGA(adaptiveRasterImage, this.bOut);
        this.state |= 2;
        try {
            this.bOut.flush();
            this.bOut.close();
            return false;
        }
        catch (IOException iOException) {
            throw new JimiException("TGAEncoder driveEncoder() IO Exception encountered");
        }
    }

    public void freeEncoder() throws JimiException {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        this.out = null;
        this.bOut = null;
        super.freeEncoder();
    }

    public int getState() {
        return this.state;
    }

    public void encodeTGA(AdaptiveRasterImage adaptiveRasterImage, LEDataOutputStream lEDataOutputStream) throws JimiException {
        this.createEncoderForImage(adaptiveRasterImage).encodeTGA(adaptiveRasterImage, lEDataOutputStream);
    }

    protected TGAEncoderIfc createEncoderForImage(AdaptiveRasterImage adaptiveRasterImage) {
        ColorModel colorModel = adaptiveRasterImage.getColorModel();
        if (colorModel instanceof IndexColorModel && colorModel.getPixelSize() == 8) {
            return new TGA8Encoder();
        }
        return new TGA24Encoder();
    }
}

