/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.xbm;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.util.JimiImageColorReducer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class XBMEncoder
extends JimiEncoderBase {
    protected PrintStream output;
    protected AdaptiveRasterImage jimiImage;
    protected int state;

    public void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.output = new PrintStream(outputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean driveEncoder() throws JimiException {
        try {
            this.jimiImage = this.getJimiImage();
            this.doImageEncode();
        }
        catch (Exception exception) {
            this.state = 1;
            throw new JimiException(exception.getMessage());
        }
        this.state = 2;
        return false;
    }

    public int getState() {
        return this.state;
    }

    protected void doImageEncode() throws JimiException, IOException {
        this.jimiImage = this.getJimiImage();
        this.writeHeader();
        this.writeImageData();
        this.writeTrailer();
    }

    protected void writeHeader() {
        this.output.println("#define jimi_xbitmap_width " + this.jimiImage.getWidth());
        this.output.println("#define jimi_xbitmap_height " + this.jimiImage.getHeight());
        this.output.println("static char jimi_xbitmap_bits = {");
    }

    protected void writeImageData() throws JimiException {
        int n;
        JimiImageColorReducer jimiImageColorReducer = new JimiImageColorReducer(2);
        this.jimiImage = new AdaptiveRasterImage(jimiImageColorReducer.colorReduceFS(this.jimiImage.getBackend()));
        IndexColorModel indexColorModel = (IndexColorModel)this.jimiImage.getColorModel();
        int n2 = this.intensity(indexColorModel.getRGB(0));
        int n3 = n2 < (n = this.intensity(indexColorModel.getRGB(1))) ? n2 : n;
        int n4 = this.jimiImage.getWidth();
        int n5 = this.jimiImage.getHeight();
        int n6 = n4 % 8 == 0 ? n4 / 8 : n4 / 8 + 1;
        int[] nArray = new int[n6 * 8];
        int n7 = 0;
        while (n7 < n5) {
            int n8 = 0;
            this.jimiImage.getChannel(n7, nArray, 0);
            int n9 = 0;
            while (n9 < n6) {
                int n10 = 0;
                int n11 = 0;
                while (n11 < 8) {
                    if (nArray[n8++] != n3) {
                        n10 = (byte)(n10 | 1 << n11);
                    }
                    ++n11;
                }
                this.output.print("0x" + Integer.toHexString(n10 & 0xFF));
                if (n7 != n5 - 1 || n9 < n6 - 1) {
                    this.output.print(",");
                }
                ++n9;
            }
            this.output.println();
            ++n7;
        }
    }

    protected int intensity(int n) {
        return (n & 0xFF) + (n >> 8 & 0xFF) + (n >> 16 & 0xFF);
    }

    protected void writeTrailer() {
        this.output.println("};");
    }
}

