/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ReplicatingScaleFilter;
import java.awt.image.ColorModel;

public class AspectReplicateScaleFilter
extends ReplicatingScaleFilter {
    protected int fixedDimension;
    protected int maxWidth;
    protected int maxHeight;
    protected boolean noScaling;

    public AspectReplicateScaleFilter(int n, int n2) {
        super(n, n2);
        this.maxWidth = n;
        this.maxHeight = n2;
    }

    @Override
    public void setDimensions(int n, int n2) {
        this.srcWidth = n;
        this.srcHeight = n2;
        if (n <= this.maxWidth && n2 <= this.maxHeight) {
            this.destWidth = n;
            this.destHeight = n2;
            this.noScaling = true;
            this.consumer.setDimensions(n, n2);
        } else {
            int n3;
            int n4;
            double d = (double)n / (double)this.maxWidth;
            double d2 = (double)n2 / (double)this.maxHeight;
            if (d < d2) {
                n4 = this.maxHeight;
                n3 = (int)((double)n / d2);
            } else {
                n3 = this.maxWidth;
                n4 = (int)((double)n2 / d);
            }
            this.destWidth = n3;
            this.destHeight = n4;
            this.consumer.setDimensions(this.destWidth, this.destHeight);
        }
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (this.noScaling) {
            this.consumer.setPixels(n, n2, n3, n4, colorModel, byArray, n5, n6);
        } else {
            super.setPixels(n, n2, n3, n4, colorModel, byArray, n5, n6);
        }
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this.noScaling) {
            this.consumer.setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
        } else {
            super.setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
        }
    }
}

