/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.options.BasicFormatOptionSet;
import com.sun.jimi.core.options.FormatOption;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.raster.CroppedRasterImageProducer;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public abstract class JimiRasterImageSupport
implements MutableJimiRasterImage,
ImageProducer {
    private static final int HINTS_UNSET = -1;
    protected boolean error = false;
    protected boolean abort = false;
    protected boolean productionStarted = false;
    protected boolean modified = false;
    protected boolean productionAllowed = false;
    protected boolean finished = false;
    protected boolean newFrameData = false;
    protected ColorModel colorModel;
    protected Hashtable properties = new Hashtable();
    private boolean hasConsumer = false;
    private int width;
    private int height;
    private int state;
    private int DEFAULT_HINTS;
    private int hints = this.DEFAULT_HINTS = 30;
    private MulticastImageConsumer directConsumer = new MulticastImageConsumer();
    private MulticastImageConsumer waitingConsumer = new MulticastImageConsumer();
    private JimiDecodingController decodingController;
    private JimiImageFactory imageFactory = new MemoryJimiImageFactory();
    private FormatOptionSet options = new BasicFormatOptionSet(new FormatOption[0]);
    protected ColorModel sourceColorModel = null;
    protected boolean forceRGB = false;
    protected int[] rowBuf;
    protected boolean waitForOptions;

    protected JimiRasterImageSupport(int n, int n2, ColorModel colorModel) {
        this.width = n;
        this.height = n2;
        this.setColorModel(colorModel);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setColorModel(ColorModel colorModel) {
        if (!this.forceRGB) {
            this.colorModel = this.getAppropriateColorModel(colorModel);
            this.forceRGB |= colorModel != this.colorModel;
        }
        this.sourceColorModel = colorModel;
    }

    @Override
    public void setImageConsumerHints(int n) {
        this.hints = n |= 0x10;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public synchronized void setError() {
        this.error = true;
        this.directConsumer.imageComplete(1);
        this.waitingConsumer.imageComplete(1);
        this.notifyAll();
    }

    public void setFactory(JimiImageFactory jimiImageFactory) {
        this.imageFactory = jimiImageFactory;
    }

    @Override
    public JimiImageFactory getFactory() {
        return this.imageFactory;
    }

    @Override
    public void setOptions(FormatOptionSet formatOptionSet) {
        this.options = formatOptionSet;
    }

    @Override
    public FormatOptionSet getOptions() {
        if (this.waitForOptions) {
            this.waitFinished();
        }
        return this.options;
    }

    @Override
    public synchronized void setFinished() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.newFrameData = false;
        this.directConsumer.imageComplete(3);
        this.directConsumer.removeAll();
        if (!this.waitingConsumer.isEmpty()) {
            try {
                this.sendToConsumerFully(this.waitingConsumer);
            }
            catch (ImageAccessException imageAccessException) {
                this.setError();
                return;
            }
        }
        ImageConsumer[] imageConsumerArray = this.waitingConsumer.getConsumers();
        this.waitingConsumer.imageComplete(3);
        this.waitingConsumer.removeAll();
        this.notifyAll();
    }

    @Override
    public void waitInfoAvailable() {
    }

    @Override
    public synchronized void waitFinished() {
        this.productionStarted = true;
        if (this.decodingController != null) {
            this.decodingController.requestDecoding();
        }
        while (!this.finished && !this.error) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public synchronized void setDecodingController(JimiDecodingController jimiDecodingController) {
        this.decodingController = jimiDecodingController;
        if (this.hasConsumer || this.productionStarted) {
            jimiDecodingController.requestDecoding();
        }
    }

    @Override
    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.hasConsumer = true;
        this.initConsumer(imageConsumer);
        if (!this.productionStarted) {
            this.addDirectConsumer(imageConsumer);
            this.productionStarted = true;
            if (this.decodingController != null) {
                this.decodingController.requestDecoding();
            }
        } else if (this.finished) {
            this.addWaitingConsumer(imageConsumer);
        } else {
            boolean bl = this.catchupConsumer(imageConsumer);
            if (bl) {
                this.addDirectConsumer(imageConsumer);
            } else {
                this.addWaitingConsumer(imageConsumer);
            }
        }
    }

    protected void addDirectConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setDimensions(this.getWidth(), this.getHeight());
        this.directConsumer.addConsumer(imageConsumer);
        imageConsumer.setHints(this.hints);
    }

    protected synchronized void addWaitingConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setDimensions(this.getWidth(), this.getHeight());
        imageConsumer.setHints(this.DEFAULT_HINTS);
        if (this.finished) {
            try {
                this.sendToConsumerFully(imageConsumer);
                imageConsumer.imageComplete(3);
            }
            catch (ImageAccessException imageAccessException) {
                imageConsumer.imageComplete(1);
            }
        } else {
            this.waitingConsumer.addConsumer(imageConsumer);
        }
    }

    protected synchronized boolean catchupConsumer(ImageConsumer imageConsumer) {
        return false;
    }

    @Override
    public ImageProducer getImageProducer() {
        return this;
    }

    @Override
    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.directConsumer.contains(imageConsumer) || this.waitingConsumer.contains(imageConsumer);
    }

    @Override
    public void removeConsumer(ImageConsumer imageConsumer) {
        this.directConsumer.removeConsumer(imageConsumer);
        this.waitingConsumer.removeConsumer(imageConsumer);
    }

    @Override
    public void startProduction(ImageConsumer imageConsumer) {
        this.removeConsumer(imageConsumer);
        this.addConsumer(imageConsumer);
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        this.addWaitingConsumer(imageConsumer);
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public Hashtable getProperties() {
        return this.properties;
    }

    @Override
    public ImageProducer getCroppedImageProducer(int n, int n2, int n3, int n4) {
        return new CroppedRasterImageProducer(this, n, n2, n3, n4);
    }

    public synchronized void produceCroppedImage(ImageConsumer imageConsumer, Rectangle rectangle) {
        this.waitFinished();
        this.initConsumer(imageConsumer);
        imageConsumer.setDimensions(rectangle.width, rectangle.height);
        imageConsumer.setHints(this.DEFAULT_HINTS);
        try {
            this.sendRegionToConsumerFully(imageConsumer, rectangle);
            imageConsumer.imageComplete(3);
        }
        catch (Exception exception) {
            imageConsumer.imageComplete(1);
        }
    }

    protected MulticastImageConsumer getDirectConsumer() {
        return this.directConsumer;
    }

    protected boolean hasDirectConsumer() {
        return !this.directConsumer.isEmpty();
    }

    protected abstract void sendToConsumerFully(ImageConsumer var1) throws ImageAccessException;

    protected abstract void sendRegionToConsumerFully(ImageConsumer var1, Rectangle var2) throws ImageAccessException;

    protected void initConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setColorModel(this.getColorModel());
        imageConsumer.setProperties(this.properties);
    }

    protected ColorModel getAppropriateColorModel(ColorModel colorModel) {
        return colorModel;
    }

    protected void setModified() {
        if (!this.modified) {
            this.modified = true;
            this.directConsumer.setHints(this.hints);
            this.productionStarted = true;
            if (this.decodingController != null) {
                this.decodingController.requestDecoding();
            }
        }
    }

    @Override
    public void getChannelRectangle(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) throws ImageAccessException {
        try {
            if (this.rowBuf == null) {
                this.rowBuf = new int[n4];
            }
            for (int i = 0; i < n5; ++i) {
                this.getRowRGB(n3 + i, this.rowBuf, 0);
                for (int j = 0; j < n4; ++j) {
                    byArray[n6 + j + i * n7] = (byte)(this.rowBuf[j] >>> n);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    public synchronized void getChannelRow(int n, int n2, byte[] byArray, int n3) throws ImageAccessException {
        this.getChannelRectangle(n, 0, n2, this.getWidth(), 1, byArray, n3, 0);
    }

    @Override
    public synchronized void getRectangleRGBChannels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        for (int i = 0; i < n4; ++i) {
            this.getRowRGB(n2 + i, this.rowBuf, 0);
            int n7 = 0;
            int n8 = 0;
            for (int j = 0; j < n3; ++j) {
                byArray[i * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 16);
                byArray[i * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 8);
                byArray[i * n6 + n8++ + n5] = (byte)this.rowBuf[n7++];
            }
        }
    }

    @Override
    public synchronized void getRectangleARGBChannels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        for (int i = 0; i < n4; ++i) {
            this.getRowRGB(n2 + i, this.rowBuf, 0);
            int n7 = 0;
            int n8 = 0;
            for (int j = 0; j < n3; ++j) {
                byArray[i * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 24);
                byArray[i * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 16);
                byArray[i * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 8);
                byArray[i * n6 + n8++ + n5] = (byte)this.rowBuf[n7++];
            }
        }
    }

    @Override
    public synchronized void getRectangleRGBAChannels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        for (int i = 0; i < n4; ++i) {
            this.getRowRGB(n2 + i, this.rowBuf, 0);
            int n7 = 0;
            int n8 = 0;
            for (int j = 0; j < n3; ++j) {
                byArray[i * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 16);
                byArray[i * n6 + n8++ + n5] = (byte)(this.rowBuf[n7] >>> 8);
                byArray[i * n6 + n8++ + n5] = (byte)this.rowBuf[n7];
                byArray[i * n6 + n8++ + n5] = (byte)(this.rowBuf[n7++] >>> 24);
            }
        }
    }

    @Override
    public void setWaitForOptions(boolean bl) {
        this.waitForOptions = bl;
    }

    @Override
    public boolean mustWaitForOptions() {
        return this.waitForOptions;
    }
}

