/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.JimiRasterImageSupport;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;

public class MemoryBitRasterImage
extends JimiRasterImageSupport
implements BitRasterImage {
    protected byte[] imageData;
    protected byte[] pixelBuffer = new byte[1];
    protected byte[] rowBuffer;
    protected byte[] rowUnpackedBuffer;
    protected int rowByteWidth;

    public MemoryBitRasterImage(int n, int n2, ColorModel colorModel) {
        super(n, n2, colorModel);
        int n3 = colorModel.getRGB(0);
        int n4 = colorModel.getRGB(1);
        byte[] byArray = new byte[]{(byte)(n3 >> 24 & 0xFF), (byte)(n4 >> 24 & 0xFF)};
        byte[] byArray2 = new byte[]{(byte)(n3 >> 16 & 0xFF), (byte)(n4 >> 16 & 0xFF)};
        byte[] byArray3 = new byte[]{(byte)(n3 >> 8 & 0xFF), (byte)(n4 >> 8 & 0xFF)};
        byte[] byArray4 = new byte[]{(byte)(n3 >> 0 & 0xFF), (byte)(n4 >> 0 & 0xFF)};
        IndexColorModel indexColorModel = new IndexColorModel(8, 2, byArray2, byArray3, byArray4, byArray);
        this.setColorModel(indexColorModel);
        this.rowByteWidth = (n + 7) / 8;
        try {
            this.initStorage();
        }
        catch (JimiException jimiException) {
            this.setError();
        }
    }

    protected void initStorage() throws JimiException {
        this.imageData = new byte[this.rowByteWidth * this.getHeight()];
        this.rowBuffer = new byte[this.rowByteWidth];
        this.rowUnpackedBuffer = new byte[this.rowByteWidth * 8];
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public void setRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        this.setModified();
        this.sendRectangle(n, n2, n3, n4, byArray, n5, n6);
        this.storeRectangle(n, n2, n3, n4, byArray, n5, n6);
    }

    public void sendRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        multicastImageConsumer.setPixels(n, n2, n3, n4, this.getColorModel(), byArray, n5, n6);
    }

    public void storeRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        for (int i = 0; i < n4; ++i) {
            JimiUtil.packOneBitPixels(byArray, n5 + i * n6, this.imageData, (n2 + i) * this.rowByteWidth, n, n3);
        }
    }

    @Override
    public void setRow(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.setRectangle(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    @Override
    public void setPixel(int n, int n2, byte by) throws ImageAccessException {
        this.setModified();
        this.storePixel(n, n2, by);
        this.sendPixel(n, n2, by);
    }

    protected synchronized void sendPixel(int n, int n2, byte by) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        this.pixelBuffer[0] = by;
        multicastImageConsumer.setPixels(n, n2, 1, 1, this.getColorModel(), this.pixelBuffer, 0, 0);
    }

    protected void storePixel(int n, int n2, byte by) throws ImageAccessException {
        int n3;
        byte by2 = (byte)(1 << 7 - n % 8);
        int n4 = n3 = (n >>> 3) + n2 * this.rowByteWidth;
        this.imageData[n4] = (byte)(this.imageData[n4] & ~by2);
        int n5 = n3;
        this.imageData[n5] = (byte)(this.imageData[n5] | by2);
    }

    @Override
    public void getRectangleRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        ColorModel colorModel = this.getColorModel();
        for (int i = 0; i < n4; ++i) {
            this.getRow(n2 + i, this.rowUnpackedBuffer, 0);
            for (int j = 0; j < n3; ++j) {
                int n7 = i * n6 + j;
                nArray[n7] = colorModel.getRGB(this.rowUnpackedBuffer[j]);
            }
        }
    }

    @Override
    public void getRowRGB(int n, int[] nArray, int n2) throws ImageAccessException {
        this.getRectangleRGB(0, n, this.getWidth(), 1, nArray, n2, this.getWidth());
    }

    @Override
    public int getPixelRGB(int n, int n2) throws ImageAccessException {
        return this.getColorModel().getRGB(this.getPixel(n, n2));
    }

    @Override
    public void getRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        for (int i = 0; i < n4; ++i) {
            JimiUtil.expandOneBitPixels(this.imageData, byArray, n3, (n2 + i) * (this.rowByteWidth * 8) + n, n5 + i * n6);
        }
    }

    @Override
    public void getRow(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.getRectangle(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    @Override
    public byte getPixel(int n, int n2) throws ImageAccessException {
        return (this.imageData[n / 8 + n2 * this.rowByteWidth] & 7 - n % 8) == 0 ? (byte)0 : 1;
    }

    @Override
    public void setRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        this.setModified();
        this.sendRectanglePacked(n, n2, n3, n4, byArray, n5, n6);
        this.storeRectanglePacked(n, n2, n3, n4, byArray, n5, n6);
    }

    public void storeRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(byArray, n5 + i * n6, this.imageData, n / 8 + (n2 + i) * this.rowByteWidth, n3 / 8);
        }
    }

    protected void sendRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        n5 *= 8;
        for (int i = 0; i < n4; ++i) {
            JimiUtil.expandOneBitPixels(byArray, this.rowUnpackedBuffer, n5 + n3, i * n3 * 8, i * n3);
        }
        multicastImageConsumer.setPixels(n, n2, n3, n4, this.getColorModel(), this.rowUnpackedBuffer, 0, n3);
    }

    @Override
    public void setRowPacked(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.setRectanglePacked(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    @Override
    public void getRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(this.imageData, n / 8 + (n2 + i) * this.rowByteWidth, byArray, n5 + i * n6, n3 / 8);
        }
    }

    @Override
    public void getRowPacked(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.getRectanglePacked(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    @Override
    protected void sendToConsumerFully(ImageConsumer imageConsumer) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            JimiUtil.expandOneBitPixels(this.imageData, this.rowUnpackedBuffer, n, this.rowByteWidth * 8 * i, 0);
            imageConsumer.setPixels(0, i, n, 1, this.getColorModel(), this.rowUnpackedBuffer, 0, 0);
        }
    }

    @Override
    protected void sendRegionToConsumerFully(ImageConsumer imageConsumer, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        ColorModel colorModel = this.getColorModel();
        for (int i = 0; i < rectangle.height; ++i) {
            JimiUtil.expandOneBitPixels(this.imageData, this.rowUnpackedBuffer, rectangle.width, this.rowByteWidth * 8 * (i + n2) + n, 0);
            imageConsumer.setPixels(0, i, n3, 1, colorModel, this.rowUnpackedBuffer, 0, 0);
        }
    }

    @Override
    public byte[] asByteArray() {
        return null;
    }
}

