/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.JimiRasterImageSupport;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;

public class MemoryCompressedBitRasterImage
extends JimiRasterImageSupport
implements BitRasterImage {
    private static final byte BYTE0 = 0;
    private static final byte BYTE1 = 1;
    private static final int BYTE_SIZE = 8;
    private static final int[] BYTE_BITS = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private static final int ISHORT_MAX = Short.MAX_VALUE;
    private static final int ISHORT_MIN = Short.MIN_VALUE;
    private static final short SHORT_MAX = Short.MAX_VALUE;
    private static final short SHORT_MIN = Short.MIN_VALUE;
    private short[] elementData;
    private int elementCount = 0;
    private int capacityIncrement = 0;
    protected byte[] rowUnpackedBuffer;
    protected int rowByteWidth;
    private byte[] byte1Buffer;
    private byte[] byte0Buffer;
    private int lastValue = 0;
    private long maxBits = 0L;
    private long bitCount = 0L;

    public MemoryCompressedBitRasterImage(int n, int n2, ColorModel colorModel) {
        super(n, n2, colorModel);
        this.capacityIncrement = (n + n2) / 2;
        this.elementData = new short[this.capacityIncrement * 5];
        this.maxBits = n * n2;
        int n3 = colorModel.getRGB(0);
        int n4 = colorModel.getRGB(1);
        byte[] byArray = new byte[]{(byte)(n3 >> 24 & 0xFF), (byte)(n4 >> 24 & 0xFF)};
        byte[] byArray2 = new byte[]{(byte)(n3 >> 16 & 0xFF), (byte)(n4 >> 16 & 0xFF)};
        byte[] byArray3 = new byte[]{(byte)(n3 >> 8 & 0xFF), (byte)(n4 >> 8 & 0xFF)};
        byte[] byArray4 = new byte[]{(byte)(n3 >> 0 & 0xFF), (byte)(n4 >> 0 & 0xFF)};
        IndexColorModel indexColorModel = new IndexColorModel(8, 2, byArray2, byArray3, byArray4, byArray);
        this.setColorModel(indexColorModel);
        this.rowByteWidth = (n + 7) / 8;
        try {
            this.initStorage();
        }
        catch (JimiException jimiException) {
            this.setError();
        }
    }

    protected void initStorage() throws JimiException {
        int n = this.rowByteWidth * 8;
        this.rowUnpackedBuffer = new byte[n];
        this.byte1Buffer = new byte[n];
        this.byte0Buffer = new byte[n];
        for (int i = n - 1; i >= 0; --i) {
            this.byte1Buffer[i] = 1;
            this.byte0Buffer[i] = 0;
        }
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public void setRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        this.setModified();
        this.sendRectangle(n, n2, n3, n4, byArray, n5, n6);
        this.storeRectangle(n, n2, n3, n4, byArray, n5, n6);
    }

    public void sendRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        multicastImageConsumer.setPixels(n, n2, n3, n4, this.getColorModel(), byArray, n5, n6);
    }

    public void storeRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        throw new ImageAccessException("Speicherung nicht Implementiert");
    }

    @Override
    public void setRow(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.setRectangle(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    @Override
    public void setPixel(int n, int n2, byte by) throws ImageAccessException {
        this.setModified();
        this.storePixel(n, n2, by);
        this.sendPixel(n, n2, by);
    }

    protected synchronized void sendPixel(int n, int n2, byte by) throws ImageAccessException {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        throw new ImageAccessException("Speicherung nicht Implementiert");
    }

    protected void storePixel(int n, int n2, byte by) throws ImageAccessException {
        throw new ImageAccessException("Speicherung nicht Implementiert");
    }

    @Override
    public void getRectangleRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        throw new ImageAccessException("Speicherung nicht Implementiert");
    }

    @Override
    public void getRowRGB(int n, int[] nArray, int n2) throws ImageAccessException {
        this.getRectangleRGB(0, n, this.getWidth(), 1, nArray, n2, this.getWidth());
    }

    @Override
    public int getPixelRGB(int n, int n2) throws ImageAccessException {
        return this.getColorModel().getRGB(this.getPixel(n, n2));
    }

    @Override
    public void getRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        throw new ImageAccessException("Speicherung nicht Implementiert");
    }

    @Override
    public void getRow(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.getRectangle(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    @Override
    public byte getPixel(int n, int n2) throws ImageAccessException {
        throw new ImageAccessException("Speicherung nicht Implementiert");
    }

    @Override
    public final void setRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        this.setModified();
        this.sendRectanglePacked(n, n2, n3, n4, byArray, n5, n6);
        this.storeRectanglePacked(n, n2, n3, n4, byArray, n5, n6);
    }

    public final void storeRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        for (int i = 0; i < n4; ++i) {
            this.addBytes(byArray, n5 + i * n6, n5 + i * n6 + n3 / 8, n6);
        }
    }

    protected final void sendRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        n5 *= 8;
        for (int i = 0; i < n4; ++i) {
            JimiUtil.expandOneBitPixels(byArray, this.rowUnpackedBuffer, n5 + n3, i * n3 * 8, i * n3);
        }
        multicastImageConsumer.setPixels(n, n2, n3, n4, this.getColorModel(), this.rowUnpackedBuffer, 0, n3);
    }

    @Override
    public void setRowPacked(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.setRectanglePacked(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    @Override
    public void getRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        throw new ImageAccessException("Speicherung nicht Implementiert");
    }

    @Override
    public void getRowPacked(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.getRectanglePacked(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    @Override
    protected void sendToConsumerFully(ImageConsumer imageConsumer) throws ImageAccessException {
        throw new ImageAccessException("Speicherung nicht Implementiert");
    }

    @Override
    protected final void sendRegionToConsumerFully(ImageConsumer imageConsumer, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = this.getWidth();
        ColorModel colorModel = this.getColorModel();
        int n4 = n2 * n3 + n;
        int n5 = 0;
        int n6 = 0;
        int n7 = rectangle.width;
        int n8 = 0;
        block0: for (int i = 0; i < this.elementCount; ++i) {
            short s = this.elementData[i];
            n5 += s > 0 ? s : -s;
            while (n5 > n4) {
                int n9 = n7 - n6;
                int n10 = n5 - (n4 + n6);
                int n11 = n9 < n10 ? n9 : n10;
                System.arraycopy(s > 0 ? this.byte1Buffer : this.byte0Buffer, 0, this.rowUnpackedBuffer, n6, n11);
                if ((n6 += n11) != n7) continue block0;
                imageConsumer.setPixels(0, n8, rectangle.width, 1, colorModel, this.rowUnpackedBuffer, 0, 0);
                if (++n8 >= rectangle.height) {
                    return;
                }
                n4 += n3;
                n6 = 0;
            }
        }
    }

    @Override
    public byte[] asByteArray() {
        return null;
    }

    private void addBytes(byte[] byArray, int n, int n2, int n3) {
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            this.addByte(byArray[i]);
        }
        if ((n3 -= 8 * n2) > 0) {
            this.addByte(byArray[n4], n3);
        }
    }

    private void addByte(byte by, int n) {
        for (int i = 0; i < n; ++i) {
            if ((by & BYTE_BITS[i]) != 0) {
                this.increase(1);
                continue;
            }
            this.decrease(1);
        }
        this.bitCount += (long)n;
        if (this.bitCount == this.maxBits && this.lastValue != 0) {
            this.addElement((short)this.lastValue);
        }
    }

    private void addByte(byte by) {
        if (by == -1) {
            this.increase(8);
        } else if (by == 0) {
            this.decrease(8);
        } else {
            for (int i = 0; i < 8; ++i) {
                if ((by & BYTE_BITS[i]) != 0) {
                    this.increase(1);
                    continue;
                }
                this.decrease(1);
            }
        }
        this.bitCount += 8L;
        if (this.bitCount == this.maxBits && this.lastValue != 0) {
            this.addElement((short)this.lastValue);
        }
    }

    private void increase(int n) {
        if (this.lastValue < 0) {
            this.addElement((short)this.lastValue);
            this.lastValue = n;
        } else {
            this.lastValue += n;
            if (this.lastValue > Short.MAX_VALUE) {
                this.addElement((short)Short.MAX_VALUE);
                this.lastValue -= Short.MAX_VALUE;
            }
        }
    }

    private void decrease(int n) {
        if (this.lastValue > 0) {
            this.addElement((short)this.lastValue);
            this.lastValue = -n;
        } else {
            this.lastValue -= n;
            if (this.lastValue < Short.MIN_VALUE) {
                this.addElement((short)Short.MIN_VALUE);
                this.lastValue -= Short.MIN_VALUE;
            }
        }
    }

    private void addElement(short s) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = s;
    }

    private void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            short[] sArray = this.elementData;
            double d = (double)this.bitCount / (double)this.maxBits;
            if (d < 0.5) {
                n3 = n2 * 2;
            } else {
                int n4 = (int)((double)n2 / d) - n2;
                n3 = n2 + (int)((double)n4 * d) + 1000;
            }
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new short[n3];
            System.arraycopy(sArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    private String toBinaryString(byte by) {
        StringBuffer stringBuffer = new StringBuffer(8);
        int n = 2;
        int n2 = n - 1;
        for (int i = 0; i < 8; ++i) {
            stringBuffer.append(Character.forDigit(by & n2, n));
            by = (byte)(by >>> 1);
        }
        return stringBuffer.reverse().toString();
    }
}

