/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.ChanneledIntRasterImage;
import com.sun.jimi.core.raster.JimiRasterImageSupport;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;

public class MemoryIntRasterImage
extends JimiRasterImageSupport
implements ChanneledIntRasterImage {
    protected int[] imageData;
    protected int[] pixelBuffer = new int[1];

    public MemoryIntRasterImage(int n, int n2, ColorModel colorModel) {
        super(n, n2, colorModel);
        try {
            this.initStorage();
        }
        catch (JimiException jimiException) {
            this.setError();
        }
    }

    protected void initStorage() throws JimiException {
        this.imageData = new int[this.getWidth() * this.getHeight()];
    }

    @Override
    public void getRectangleRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        ColorModel colorModel = this.getColorModel();
        try {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    nArray[n5 + j + i * n6] = colorModel.getRGB(this.imageData[n + j + (n2 + i) * this.getWidth()]);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    @Override
    public void getRowRGB(int n, int[] nArray, int n2) throws ImageAccessException {
        this.getRectangleRGB(0, n, this.getWidth(), 1, nArray, n2, 0);
    }

    @Override
    public int getPixelRGB(int n, int n2) throws ImageAccessException {
        return this.getColorModel().getRGB(this.imageData[n + n2 * this.getWidth()]);
    }

    @Override
    public void getRectangle(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        try {
            for (int i = 0; i < n4; ++i) {
                System.arraycopy(this.imageData, n + (n2 + i) * this.getWidth(), nArray, n5 + i * n6, this.getWidth());
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    @Override
    public void getRow(int n, int[] nArray, int n2) throws ImageAccessException {
        this.getRectangle(0, n, this.getWidth(), 1, nArray, n2, 0);
    }

    @Override
    public int getPixel(int n, int n2) throws ImageAccessException {
        try {
            return this.imageData[n + n2 * this.getWidth()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ImageAccessException(arrayIndexOutOfBoundsException.toString());
        }
    }

    @Override
    public void getChannelRectangle(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) throws ImageAccessException {
        try {
            int[] nArray = new int[n4];
            for (int i = 0; i < n5; ++i) {
                this.getRowRGB(n3 + i, nArray, 0);
                for (int j = 0; j < n4; ++j) {
                    byArray[n6 + j + i * n7] = (byte)(nArray[j] >>> n);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    @Override
    public void getChannelRow(int n, int n2, byte[] byArray, int n3) throws ImageAccessException {
        this.getChannelRectangle(n, 0, n2, this.getWidth(), 1, byArray, n3, 0);
    }

    @Override
    public void setRectangle(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        this.setModified();
        if (this.forceRGB) {
            this.toRGB(nArray, n3, n4, n5, n6);
        }
        this.sendRectangle(n, n2, n3, n4, nArray, n5, n6);
        this.storeRectangle(n, n2, n3, n4, nArray, n5, n6);
    }

    @Override
    public void setRow(int n, int[] nArray, int n2) throws ImageAccessException {
        this.setRectangle(0, n, this.getWidth(), 1, nArray, n2, 0);
    }

    @Override
    public void setPixel(int n, int n2, int n3) throws ImageAccessException {
        this.setModified();
        if (this.forceRGB) {
            n3 = this.toRGB(n3);
        }
        this.sendPixel(n, n2, n3);
        this.storePixel(n, n2, n3);
    }

    public void storeRectangle(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        try {
            for (int i = 0; i < n4; ++i) {
                System.arraycopy(nArray, n5 + i * n6, this.imageData, n + (n2 + i) * this.getWidth(), n3);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    public void storeRow(int n, int[] nArray, int n2) throws ImageAccessException {
        this.storeRectangle(0, n, this.getWidth(), 1, nArray, n2, 0);
    }

    public void storePixel(int n, int n2, int n3) throws ImageAccessException {
        try {
            this.imageData[n + n2 * this.getWidth()] = n3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ImageAccessException(arrayIndexOutOfBoundsException.toString());
        }
    }

    @Override
    public void setChannelRectangle(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) throws ImageAccessException {
        this.setModified();
        this.storeChannelRectangle(n, n2, n3, n4, n5, byArray, n6, n7);
    }

    @Override
    public void setChannelRow(int n, int n2, byte[] byArray, int n3) throws ImageAccessException {
        this.setChannelRectangle(n, 0, n2, this.getWidth(), 1, byArray, n3, 0);
    }

    @Override
    public void setChannelPixel(int n, int n2, int n3, byte by) throws ImageAccessException {
        this.setModified();
        int n4 = n2 + n3 * this.getWidth();
        this.imageData[n4] = this.imageData[n4] | (by & 0xFF) << n;
    }

    public void storeChannelRectangle(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) throws ImageAccessException {
        try {
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n4; ++j) {
                    int n8 = n2 + j + (n3 + i) * this.getWidth();
                    this.imageData[n8] = this.imageData[n8] | (byArray[n6 + j + i * n7] & 0xFF) << n;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    protected void sendRectangle(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        multicastImageConsumer.setPixels(n, n2, n3, n4, this.getColorModel(), nArray, n5, this.getWidth());
    }

    protected void sendRow(int n, int[] nArray, int n2) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        multicastImageConsumer.setPixels(0, n, this.getWidth(), 1, this.getColorModel(), nArray, n2, 0);
    }

    protected synchronized void sendPixel(int n, int n2, int n3) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        this.pixelBuffer[0] = n3;
        multicastImageConsumer.setPixels(n, n2, 1, 1, this.getColorModel(), this.pixelBuffer, 0, 1);
    }

    @Override
    protected void sendToConsumerFully(ImageConsumer imageConsumer) throws ImageAccessException {
        imageConsumer.setPixels(0, 0, this.getWidth(), this.getHeight(), this.getColorModel(), this.imageData, 0, this.getWidth());
    }

    @Override
    protected void sendRegionToConsumerFully(ImageConsumer imageConsumer, Rectangle rectangle) throws ImageAccessException {
        int n = rectangle.x + rectangle.y * this.getWidth();
        imageConsumer.setPixels(0, 0, rectangle.width, rectangle.height, this.getColorModel(), this.imageData, n, this.getWidth());
    }

    protected void toRGB(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = n - n4;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[n3] = this.sourceColorModel.getRGB(nArray[n3]);
                ++n3;
            }
            n3 += n5;
        }
    }

    protected int toRGB(int n) {
        return this.sourceColorModel.getRGB(n);
    }

    @Override
    protected ColorModel getAppropriateColorModel(ColorModel colorModel) {
        if (colorModel instanceof IndexColorModel) {
            return colorModel;
        }
        if (colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            if (directColorModel.getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255) {
                return colorModel;
            }
            if (directColorModel.getAlphaMask() == 0) {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
        }
        return ColorModel.getRGBdefault();
    }

    @Override
    public int[] asIntArray() {
        return this.imageData;
    }
}

